/*
	$Id: combobox_default.h,v 1.18 2001/12/27 22:58:40 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#ifndef combobox_default
#define combobox_default

#include "API/GUI/combobox.h"
#include "API/GUI/component_style.h"

class CL_Font;
class CL_Surface;
class CL_StyleManager_Default;

class CL_ComboBox_Default : public CL_ComponentStyle
{
public:
	CL_ComboBox_Default(
		CL_ComboBox *combobox,
		CL_StyleManager_Default *style);
	
	virtual ~CL_ComboBox_Default();

private:
	void on_paint();
	void on_listbox_activated(int index);
//	void on_listbox_deactivated();
	void on_listbox_highlighted(int selection);
	void on_listbox_cancel();
	void on_set_options(const CL_ComponentOptions &options);

	CL_ComboBox *combobox;

	CL_StyleManager_Default *style;
	CL_ResourceManager *resources;
	CL_Font *fnt_options;
	CL_Surface *sur_select_normal;
	CL_Surface *sur_select_toggled;
	CL_Surface *sur_select_disabled;

	int button_width;
	int button_height;

//	CL_SelectionList *select_list;

	CL_Slot slot_set_options;
	CL_Slot slot_selection_slot;
	CL_Slot slot_selection_cancel_slot;
	CL_Slot slot_activated, slot_deactivated, slot_paint;
};

#endif

