/*
	$Id: combobox_default.cpp,v 1.39 2002/01/08 10:13:15 sphair Exp $
	
	ClanGUI, copyrights by various people. Have a look in the CREDITS file.
	
	This sourcecode is distributed using the Library GNU Public Licence,
	version 2 or (at your option) any later version. Please read LICENSE
	for details.
*/

#include "precomp.h"
#include <cstdio>
#include "API/Display/Display/surface.h"
#include "API/Display/Font/font.h" 
#include "API/Core/Resources/resource_manager.h"
#include "API/GUI/gui_manager.h"
#include "API/GUI/stylemanager_default.h"
#include "combobox_default.h"
#include "button_default.h"

#define X_TEXT_OFFSET 4
#define Y_TEXT_OFFSET 2

CL_ComboBox_Default::CL_ComboBox_Default(
	CL_ComboBox *_combobox,
	CL_StyleManager_Default *_style) : CL_ComponentStyle(_combobox), combobox(_combobox)
{
	style = _style;
	resources = style->get_resources();
	fnt_options = CL_Font::load("ComboBox/font", resources);
	sur_select_normal = CL_Surface::load("ComboBox/select_normal", resources);
	sur_select_toggled = CL_Surface::load("ComboBox/select_toggled", resources);
	sur_select_disabled = CL_Surface::load("ComboBox/select_disabled", resources);

	button_width = sur_select_normal->get_width();
	button_height = sur_select_normal->get_height();

	CL_Rect pos = combobox->get_position();
	pos.y1 += button_height;
	combobox->set_position(pos);

//	select_list = NULL;
	// TODO: Too ugly hack!:
//	combobox->skip_next_activation = false;

/*	CL_ComponentOptions b_options;
	#ifdef BORLAND
		b_options.options.insert(std::make_pair(std::string("x") , std::string(CL_String(combobox->get_width()-button_width-1))));
		b_options.options.insert(std::make_pair(std::string("y") , std::string("0")));
		b_options.options.insert(std::make_pair(std::string("width") , std::string(CL_String(button_width))));
		b_options.options.insert(std::make_pair(std::string("height") , std::string(CL_String(button_height))));
		b_options.options.insert(std::make_pair(std::string("sur_normal") , std::string("Combobox/select_normal")));
		b_options.options.insert(std::make_pair(std::string("sur_toggled") , std::string("Combobox/select_toggled")));
		b_options.options.insert(std::make_pair(std::string("sur_disabled") , std::string("Combobox/select_disabled")));
	#else
		b_options.options.insert(std::make_pair<std::string const, std::string>("x", CL_String(combobox->get_width()-button_width-1)));
		b_options.options.insert(std::make_pair<std::string const, std::string>("y", "0"));
		b_options.options.insert(std::make_pair<std::string const, std::string>("width", CL_String(button_width)));
		b_options.options.insert(std::make_pair<std::string const, std::string>("height", CL_String(button_height)));
		b_options.options.insert(std::make_pair<std::string const, std::string>("sur_normal", "Combobox/select_normal"));
		b_options.options.insert(std::make_pair<std::string const, std::string>("sur_toggled", "Combobox/select_toggled"));
		b_options.options.insert(std::make_pair<std::string const, std::string>("sur_disabled", "Combobox/select_disabled"));
	#endif

	// TODO: Fix this
	combobox->set_select_button(
		new CL_Button_Bitmap(
			b_options,
			combobox,
			style));
*/
	slot_set_options = combobox->sig_set_options().connect(this, &CL_ComboBox_Default::on_set_options);
	slot_activated = combobox->sig_activated().connect(this, &CL_ComboBox_Default::on_listbox_activated);
//	slot_deactivated = combobox->sig_deactivated().connect(this, &CL_ComboBox_Default::on_listbox_deactivated);
	slot_paint = combobox->sig_paint().connect(this, &CL_ComboBox_Default::on_paint);
}

CL_ComboBox_Default::~CL_ComboBox_Default()
{
/*	delete fnt_options;
	delete sur_select_normal;
	delete sur_select_toggled;
	delete sur_select_disabled;
*/
}

void CL_ComboBox_Default::on_paint()
{
/*	style->fill_rect(0, 0, combobox->get_width(), combobox->get_height(), GUICOL_TEXT_BG);

	style->draw_line(0, 0, combobox->get_width()-1, 0, GUICOL_TOP_SHADE);
	style->draw_line(0, 0, 0, combobox->get_height()-1, GUICOL_TOP_SHADE);

	style->draw_line(1, 1, combobox->get_width()-2, 1, GUICOL_DARK_OUTLINE);
	style->draw_line(1, 1, 1, combobox->get_height()-2, GUICOL_DARK_OUTLINE);

	style->draw_line(0, combobox->get_height()-1, combobox->get_width(), combobox->get_height()-1, GUICOL_BRIGHT_OUTLINE);
	style->draw_line(combobox->get_width()-1, 0, combobox->get_width()-1, combobox->get_height(), GUICOL_BRIGHT_OUTLINE);

	style->draw_line(1, combobox->get_height()-2, combobox->get_width()-1, combobox->get_height()-2, GUICOL_CONTOUR);
	style->draw_line(combobox->get_width()-2, 1, combobox->get_width()-2, combobox->get_height()-1, GUICOL_CONTOUR);
*/	
	fnt_options->print_left(X_TEXT_OFFSET, Y_TEXT_OFFSET, combobox->get_current_text().c_str());
}

void CL_ComboBox_Default::on_listbox_activated(int index)
{
	// TODO: Fix this:
/*	CL_ComponentOptions b_options;
	delete select_list;

	CL_Rect screen = combobox->get_screen_rect();
	#ifdef BORLAND
		b_options.options.insert(std::make_pair(std::string("x"), std::string(CL_String(screen.x1))));
		b_options.options.insert(std::make_pair(std::string("y"), std::string(CL_String(screen.y2))));
		b_options.options.insert(std::make_pair(std::string("width"), std::string(CL_String(combobox->get_width()))));
		b_options.options.insert(std::make_pair(std::string("value"), std::string(CL_String(combobox->get_selection()))));
	#else
		b_options.options.insert(std::make_pair<std::string const, std::string>("x", CL_String(screen.x1)));
		b_options.options.insert(std::make_pair<std::string const, std::string>("y", CL_String(screen.y2)));
		b_options.options.insert(std::make_pair<std::string const, std::string>("width", CL_String(combobox->get_width())));
		b_options.options.insert(std::make_pair<std::string const, std::string>("value", CL_String(combobox->get_current_item())));
	#endif

	select_list = new CL_SelectionList(b_options, NULL, style, fnt_options, combobox->m_options);
	selection_slot = select_list->sig_activated.connect(
		this, &CL_ComboBox_Default::on_listbox_selection);
	selection_cancel_slot = select_list->sig_cancelled.connect(
		this, &CL_ComboBox_Default::on_listbox_cancel);
	combobox->get_gui_manager()->add_child(select_list);
	select_list->set_focus();
*/
}

/*void CL_ComboBox_Default::on_listbox_deactivated()
{
	if (select_list != NULL)
	{
		select_list->close();
//		get_gui_manager()->remove_component(select_list);
		delete select_list;
		select_list = NULL;
	}
}
*/
void CL_ComboBox_Default::on_listbox_highlighted(int selection)
{
	combobox->set_current_item(selection);
	// TODO: fix this
//	combobox->activated = false;
}

void CL_ComboBox_Default::on_listbox_cancel()
{
	// TODO: fix this
//	if (combobox->activated) combobox->skip_next_activation = true;
///	combobox->activated = false;
}

void CL_ComboBox_Default::on_set_options(const CL_ComponentOptions &options)
{
}

