/*
	$Id: main.cpp,v 1.8 2001/11/29 05:19:46 plasmoid Exp $

	------------------------------------------------------------------------
	ClanLib, the platform independent game SDK.

	This library is distributed under the GNU LIBRARY GENERAL PUBLIC LICENSE
	version 2. See COPYING for details.

	For a total list of contributers see CREDITS.

	------------------------------------------------------------------------
*/

//---------------------------------------------------------------------------

#include <iostream.h>
#include <string>
#include <conio.h>
#include "generator.h"
#pragma hdrstop

//---------------------------------------------------------------------------

#pragma argsused
int main(int argc, char* argv[])
{
	char tasm;

  Workspace work;

  std::list<std::string> libs_list_shared;
	std::list<std::string> libs_list_release;
	std::list<std::string> libs_list_debug;
	std::list<std::string> defines_list;
  
  defines_list.push_back("WIN32");
  defines_list.push_back("_WINDOWS");
  defines_list.push_back("USE_OPENGL");
  defines_list.push_back("USE_NETWORK");
  defines_list.push_back("BORLAND");
  defines_list.push_back("USE_CLANSOUND");
  defines_list.push_back("USE_I386_ASSEMBLER");
//  defines_list.push_back("WIN32_LEAN_AND_MEAN");

  cout << "Welcome to ClanLib Borland Configurer!" <<endl;
	cout<<"Do you have TASM?[y/n]";
	cin>>tasm;
	if(tasm == 'y' || tasm == 'Y')
  	defines_list.push_back("USE_TASM");

  Project app("Application","libApp",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project core("Core","libCore",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project display("Display","libDisplay",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project gl("GL","libGL",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project gui("GUI","libGUI",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project javascript("JPEG","libJpeg",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project jpeg("JavaScript","libJavaScript",libs_list_shared,libs_list_release,libs_list_debug,defines_list);

  Project lua("Lua","libLua",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project midi("Midi","libMidi",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project mikmod("MikMod","libMikMod",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project network("Network","libNetwork",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project png("PNG","libPng",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project sound("Sound","libSound",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project smallJPEG("SmallJPEG","libSmallJPEG",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project ttf("TTF","libTTF",libs_list_shared,libs_list_release,libs_list_debug,defines_list);
  Project vorbis("Vorbis","libVorbis",libs_list_shared,libs_list_release,libs_list_debug,defines_list);

  work.projects.push_back(app);
  work.projects.push_back(core);
  work.projects.push_back(display);
  work.projects.push_back(gl);
  work.projects.push_back(gui);
  work.projects.push_back(jpeg);
  work.projects.push_back(lua);
  work.projects.push_back(midi);
  work.projects.push_back(mikmod);
  work.projects.push_back(network);
  work.projects.push_back(png);
  work.projects.push_back(smallJPEG);
  work.projects.push_back(sound);
  work.projects.push_back(ttf);
  work.projects.push_back(vorbis);

  create_release(work);
  create_makefile(work);



  cout <<"Project creation complete(press any key to quit)." <<endl;

  while(!kbhit()) ;
	return 0;
}
//---------------------------------------------------------------------------
 