#include <iostream.h>
#include <ClanLib/core.h>
#include <ClanLib/gui.h>
#include <ClanLib/display.h>
#include <ClanLib/application.h>

class DialogTest : public CL_ClanApplication
{
public:
	char *get_title() { return "DialogTest"; }
	
	int main(int argc,char **argv)
	{
		try
		{
			CL_SetupCore::init();
			CL_SetupGUI::init();
			
			CL_SetupDisplay::init();
			CL_Display::set_videomode(640,480,16,false,false,false);

			resource = CL_ResourceManager::create("resources.scr", false);
			style = new CL_StyleManager_Default(resource);

			CL_Dialog::run("At last","I'm the f&$@ing dialog", style);
		}
		catch (CL_Error e)
		{
			std::cout << e.message.c_str() << std::endl;
		}
		catch (...)
		{
			std::cout << "Ugga" << std::endl;
		}

		return 0;
	}

protected:
	CL_ResourceManager *resource;
	CL_StyleManager *style;
} app;

