;;; -*- Syntax: Ansi-Common-Lisp; Base: 10; Mode: lisp; Package: imho -*-
;;; $Id: test-harness.lisp,v 1.1 2001/11/27 17:30:53 jesse Exp $
;;;
;;; Copyright (c) 1999, 2000, 2001 onShore Development, Inc.
;;;
;;; See the file 'COPYING' in this directory for terms.
;;;
;;; Allow programmatic testing of imho user interfaces.

(in-package :imho)

(defun th-get-session (app)
  (if-bind (app (find-application app))
      (begin-session app)
      nil))

(defun th-handle-request (session &key method method-arg element args)
  (let ((request (make-request :application (session-application session)
                               :response-callback #'th-response-callback
                               :session session
                               :callee (when element (element-external-name element))
                               :args method-arg
                               :method method)))
    (update-alist :remotehost #x7f000001 (request-headers-in request))
    (dolist (arg args)
      (let ((child (child-element element (car arg) :if-does-not-exist :error)))
        (push (list (element-external-name child) (cdr arg))
              (request-client-content request))))
    (handle-request request)))

(defun th-response-callback (request)
  (request-response-element request))