C********************************************************************
C     EQUALITY CONSTRAINED RECURSIVE QUADRATIC PROGRAMMING WITH
C     MULTIPLE INACTIVATION AND SUPERLINEARLY CONVERGENT PROJECTED
C     BFGS-UPDATE (VERSION 12/93 SPELLUCCI )
C********************************************************************
      SUBROUTINE O8OPTI
      INCLUDE 'O8COMM.INC'
      INCLUDE 'O8CONS.INC'
      INCLUDE 'O8QPDU.INC'
      INCLUDE 'O8FINT.INC'
C*******  LOCAL VARIABLES
      INTEGER L,L0,I,J,K,CSSSIG,CSIRUP,CSREG,CSCHGX
      INTEGER CSMDPH
      DOUBLE PRECISION DELSIG,DELX,SUM,TERM
      DOUBLE PRECISION UMIN,TERM1,SCFH,UNORM
      DOUBLE PRECISION DEL1
      DOUBLE PRECISION QTX(NX)
      DOUBLE PRECISION YY(NX),YX(NX),TRVEC(NX)
      INTEGER IUMIN,RANK0,NR0,CSDIFX,CLWOLD
      INTEGER DELIST(0:NRESM),NRBAS,BINDBA(NRESM)
      DOUBLE PRECISION EPS,DELOLD,UMINSC,FAC,SLACKN,TAUQP0
      DOUBLE PRECISION O8SC1,O8SC3,O8VECN
      EXTERNAL O8SC1,O8SC3,O8VECN
      LOGICAL NPERM,QPNEW,ETAINI,VIOBND
      SAVE
C INITIALIZATION
C SAVE STARTING POINT FOR LATER PRINTING ONLY
      DO I=1,N
        D(I)=ZERO
        D0(I)=ZERO
      ENDDO
      ITSTEP=0
      ALIST(0)=NH
      DELIST(0)=0
      VIOLIS(0)=0
      UPSI=ZERO
      PSI=ZERO
      PSI0=ZERO
      SIG0=ZERO
      D0NORM=ONE
      UNORM=ONE
C*** IN ORDER TO HAVE COSPHI WELL DEFINED FOR ITSTEP=1
      DNORM=ONE
      DEL=DEL0
C*** COUNT SUCCESSIVE REGULARIZATION STEPS
      CSREG=0
C*** COUNT SUCCESSIVE SMALL CHANGES IN X
      CSCHGX=0
C*** COUNT SMALL DIFFERENCES OF FX
      CSDIFX=0
C*** COUNT IRREGULAR QUASI-NEWTON-UPDATES
      CSIRUP=0
C*** COUNT SUCCESSIVE SMALL STEPSIZES
      CSSSIG=0
C*** COUNT SUCCESSIVE SMALL DIFFERENCES OF PENALTY-FUNCTION
      CSMDPH=0
      MATSC=ONE
C  FORMERLY TAUQP=TP2 IS WORSE
      TAUQP=ONE
      NPERM=.FALSE.
      IDENT=.FALSE.
      ETAINI=.FALSE.
      IF ( N .GT. 100 .OR. NRES .GT. 100 ) TE3=.FALSE.
      DO  I = 1,N
        PERM(I)=I
        PERM1(I)=I
      ENDDO
      DO I = 1,NH
        BIND0(I)=1
        BIND(I)=1
        ALIST(I)=I
      ENDDO
      IF ( ANALYT ) THEN
        EPS=MIN(EPSX,SQRT(EPSMAC))
      ELSE
        EPS=EPSDIF
        IF ( EPSX .LT. EPSDIF**2 ) EPSX=EPSDIF**2
      ENDIF
      EPS=MAX(EPSMAC*TP3,MIN(TM3,EPS))
C**** CALLING FOR EXTERNAL FUNCTION EVALUATION NECESSARY ONLY IF
C     CORR=.TRUE.
C
C******* FUNCTION AND GRADIENT VALUES, FROM XTR=X*XSC
      DO I =1 ,NRES
        IF ( I .LE. NH ) THEN
          CFUERR(I)=.FALSE.
          CALL ESH(I,X,RES(I))
          IF ( CFUERR(I) ) THEN
            IF ( .NOT. SILENT ) CALL O8MSG(23)
            OPTITE=-10
            RETURN
          ENDIF
          TERM=ABS(RES(I))
          IF ( .NOT. GCONST(I) ) THEN
C******* WE ASSUME THAT THE GRADIENT CAN BE EVALUATED WHENEVER
C******* THE FUNCTION CAN
            CALL ESGRADH(I,X,YY)
            VAL(I)=.TRUE.
            DO  J=1,N
              GRES(J,I)=YY(J)
            ENDDO
          ENDIF
        ELSE
          BIND(I)=0
          CFUERR(I)=.FALSE.
          CALL ESG(I-NH,X,RES(I))
          IF ( CFUERR(I) ) THEN
            IF ( .NOT. SILENT ) CALL O8MSG(23)
            OPTITE=-10
            RETURN
          ENDIF
          TERM=-MIN(ZERO,RES(I))
          IF ( RES(I) .LE. DELMIN ) THEN
            BIND(I)=1
            ALIST(0)=ALIST(0)+1
            ALIST(ALIST(0))=I
            IF ( .NOT. GCONST(I) ) THEN
              VAL(I)=.TRUE.
C****** WE ASSUME THAT THE GRADIENT CAN BE EVALUATED
C       WHENEVER THE FUNCTION CAN
              CALL ESGRADG(I-NH,X,YY)
              DO J =1,N
                GRES(J,I)=YY(J)
              ENDDO
            ENDIF
          ENDIF
        ENDIF
        UPSI=UPSI+TERM
        PSI=PSI+TERM*W(I)
        IF ( VAL(I) .AND. .NOT. GCONST(I) )
     F    GRESN(I)=MAX(ONE,O8VECN(1,N,YY))
      ENDDO
  100 CONTINUE
C****************************************************************
C     OBTAINING A POINT FEASIBLE WITHIN TAU0 FIRST
C****************************************************************
      IF ( UPSI .GE. TAU0 ) THEN
        SCF=ZERO
        PHASE=-1
      ELSE
        FFUERR=.FALSE.
        CALL ESF(X,FX)
        IF ( FFUERR ) THEN
          IF ( .NOT. SILENT ) CALL O8MSG(22)
          OPTITE=-9
          RETURN
        ENDIF
        IF ( .NOT. VAL(0) ) THEN
C*** WE ASSUME THAT THE GRADIENT EVALUATION CAN BE DONE
C*** WHENEVER THE FUNCTION HAS BEEN EVALUATED
          CALL ESGRADF(X,GRADF)
          VAL(0)=.TRUE.
        ENDIF
        SCF=ONE
        PHASE=0
        FXST=FX
        PSIST=PSI
        UPSIST=UPSI
        DO J=1,NRES
          RESST(J)=RES(J)
        ENDDO
        ETA=ZERO
      ENDIF
C*******************************************************************
  200 CONTINUE
C*******************************************************************
C     MAIN ITERATION LOOP: GETTING A BETTER X
C*******************************************************************
      IF ( .NOT. IDENT ) THEN
        ITSTEP=ITSTEP+1
        IF ( ITSTEP .GT. ITERMA ) THEN
          OPTITE=-THREE
          ITSTEP=ITERMA
          B2N=ACCINF(ITSTEP,8)
          B2N0=ACCINF(ITSTEP,7)
          RETURN
        ENDIF
        QPNEW=.FALSE.
        QPTERM=0
        DELOLD=DEL
        DEL=ZERO
        B2N0=-ONE
        B2N=-ONE
        SINGUL=.FALSE.
        NPERM=.FALSE.
        DO I=1,N
          NPERM=NPERM .OR. (PERM(I) .NE. PERM1(I))
          PERM(I)=PERM1(I)
        ENDDO
        DO I=1,NRES
          DIAG(I)=ZERO
        ENDDO
      ENDIF
C*******************************
C     CURRENT VALID ROW PERMUTATION FOR QR-DECOMPOSITION OF
C     MATRIX OF BINDING GRADIENTS IN ORDER TO OBTAIN CONTINUITY
C     OF THE QR-DECOMPOSITION  IS GIVEN BY PERM
C*******************************
      NR=ALIST(0)
      NRBAS=NR
      DO I=1,NRES
        BINDBA(I)=BIND(I)
      ENDDO
      DO J=1,32
        ACCINF(ITSTEP,J)=ZERO
      ENDDO
      GFN=O8VECN(1,N,GRADF)
C***** COMPUTE NEW WEIGHT OF OBJECTIVE FUNCTION IF USEFUL
      IF ( NRES .GT. 0 .AND. PHASE .GE. 0 .AND. .NOT. IDENT
     F    .AND. ITSTEP .GT. 1 .AND.
     F    ( (ACCINF(ITSTEP-1,10) .EQ. -1. .AND.  SCF0 .EQ. ONE )
     F    .OR. ACCINF(ITSTEP-1,10) .EQ. 1. )   ) THEN
C***   TRY RESCALING THE OBJECTIVE FUNCTION
        TERM=ZERO
        DO I=1,NRES
          IF ( GUNIT(1,I) .NE. 1 ) TERM=MAX(TERM,GRESN(I))
        ENDDO
        SCFH=TERM/MAX(ONE/SCFMAX,GFN)
        IF ( SCFH .LT. ONE/SCFMAX ) SCFH=ONE/SCFMAX
        IF ( SCFH .GT. SCFMAX ) SCFH=SCFMAX
        IF ( (FXST-FX)*SCFH+SCFH/SCF*(PSIST-PSI) .GE.
     F     SCFH/SCF*ETA*CLOW .AND. LASTCH .LE. ITSTEP-4
     F     .AND. SCFH .LT. TM1*SCF .OR. SCFH .GT. TP1*SCF )THEN
C*** RESCALE THE OBJECTIVE FUNCTION IF THIS SEEMS PROMISING AND THE
C*** CHANGE IS SIGNIFICANT
          CLOW=CLOW+1
          TERM=SCFH/SCF
          PSI=PSI*TERM
          PSIST=PSIST*TERM
          DO I=1,NRES
            U(I)=U(I)*TERM
          ENDDO
          UNORM=UNORM*TERM
          SCF=SCFH
          LASTCH=ITSTEP
          TERM=SQRT(TERM)
          DO  I=1,N
            DIAG0(I)=TERM*DIAG0(I)
            DO  J=1,N
              A(J,I)=A(J,I)*TERM
            ENDDO
          ENDDO
          MATSC=MATSC*TERM
          IF ( .NOT. SILENT ) CALL O8MSG(2)
        ENDIF
      ENDIF
      ACCINF(ITSTEP,1)=ITSTEP
      ACCINF(ITSTEP,2)=FX
      ACCINF(ITSTEP,3)=SCF
      ACCINF(ITSTEP,4)=PSI
      ACCINF(ITSTEP,5)=UPSI
      IF ( .NOT. SILENT ) CALL O8INFO(1)
C
C***  BEGIN SOLVER
C*******************************************************************
C     QR-DECOMPOSITION OF MATRIX OF BINDING GRADIENTS
C*******************************************************************
      IF ( NR .GE. 1 ) THEN
        CALL O8DEC(1,NR)
      ELSE
        RANK=0
      ENDIF
      CALL O8LEFT(A,GRADF,YY,TERM,N)
      DO I=1,N
        QGF(I)=YY(PERM(I))
      ENDDO
      CALL O8HT(1,0,1,RANK,N,QR,BETAQ,QGF,TRVEC)
      DO I=1,N
        QGF(I)=TRVEC(I)
      ENDDO
      IF ( RANK .NE. NR .AND. .NOT. SILENT ) CALL O8MSG(1)
C*******************************************************************
C     COMPUTE DEL AS FUNCTION OF X (FORCING INFEASIBILITY AND
C     THE PROJECTED GRADIENT TO ZERO)
C*******************************************************************
      B2N0=O8VECN(RANK+1,N,QGF)
      SUM=ZERO
      DO I=1,NRES
        IF ( I.LE.NH ) THEN
          SUM=SUM+ABS(RES(I))/GRESN(I)
        ELSE
          SUM=SUM-MIN(ZERO,RES(I))/GRESN(I)
        ENDIF
      ENDDO
      IF ( ITSTEP .GT. 1 .AND. ACCINF(ITSTEP-1,8) .GE. ZERO
     F     .AND. .NOT. ETAINI
     F     .AND. ACCINF(ITSTEP-1,18) .GE. 0  ) THEN
        ETAINI=.TRUE.
        ETA=(ACCINF(ITSTEP-1,8)/MAX(ONE,GFN)+SUM
     F       +MIN(ONE,SLACKN)+MIN(ONE,ABS(UMINSC)))/MIN(30*N,ITERMA)
        LEVEL=ETA
      ENDIF
      DELX=DELMIN
      TERM=SCF*(FX0-FX)+PSI0-PSI
      IF ( TERM .GT. ZERO .AND. SCF .NE. ZERO )
     F     DELX=MAX(DELX,EXP(P7*P7*LOG(TERM)))
      IF ( SCF .EQ. ZERO ) DELX=MIN(DEL0*TM4,MAX(DELX,UPSI*TM2))
      DELSIG=DELMIN
C**** DEL SHOULD BE LARGE ENOUGH TO INCLUDE CONSTRAINTS HIT IN
C**** STEP BEFORE . VIOLIS COMES FROM UNIMIN
      DO I=1,VIOLIS(0)
        J=VIOLIS(I)
        DELSIG=MAX(DELSIG,
     F    RES(J)/GRESN(J)/DELFAC(J)*(ONE+TM1))
      ENDDO
      DEL=MIN(DEL0,MAX(MIN(DELSIG,FIVE*DELX),DELX))
      IF ( VIOLIS(0) .EQ. 0 ) DEL=MIN(DEL,DEL01)
C************************************************************
C     IF PHASE=2 DON'T LOOSE A BINDING CONSTRAINT
C     PHASE=2 IMPLIES DELIST(0)=0
C************************************************************
      IF ( PHASE .EQ. 2 .AND. VIOLIS(0) .EQ. 0 ) THEN
        DO I=NH+1,NRES
          IF ( BIND0(I) .EQ. 1 )
     F    DEL=MIN(DEL01,MAX(DEL,ABS(RES(I))/GRESN(I)))
        ENDDO
      ENDIF
C*** REDUCE DEL BY A FIXED FACTOR ( TM2) IF USEFUL,
C    THAT IS IF DELETE-LIST
C*** IN THE PREVIOUS STEP WAS NOT EMPTY
      TERM=DEL
      DO I=1,DELIST(0)
        J=DELIST(I)
        TERM1=RES(J)/GRESN(J)*(ONE-TM2)/DELFAC(J)
        IF ( TERM1 .GE. DEL*TM2 ) TERM=MIN(TERM,TERM1)
      ENDDO
      DEL=TERM
C***  IF DELTA BECOMES TOO LARGE, WE MAY LOOSE COMPLEMENTARY SLACKNESS
      IF ( ITSTEP .GT. 1 .AND. .NOT. IDENT .AND. SCF .NE. ZERO ) THEN
        TERM=ZERO
        DO I=NH+1,NRES
          TERM=TERM+
     F    MAX(ZERO,RES(I)/GRESN(I)-DELMIN)
     F    *MAX(ZERO,U(I)-SMALLW)/GRESN(I)
        ENDDO
        IF ( TERM .GT. ZERO ) THEN
          DO I=NH+1,NRES
            IF ( U(I) .GT. SMALLW .AND. RES(I)/GRESN(I) .GT. DELMIN )
     F      THEN
              DEL=MAX(DELMIN,
     F          MIN(DEL,RES(I)/GRESN(I)*(ONE-TM2)/DELFAC(I)))
            ENDIF
          ENDDO
        ENDIF
      ENDIF
C***  IF THE CURRENT STEP WAS SINGULAR AND NOT SUCCESSFUL,
C***  TRY A GREATER DEL
C***  THE SAME, IF QPTERM IN THE LAST STEP DID SIGNAL TROUBLE, BUT
C***  STEPSIZE SELECTION WAS NEVERTHELESS SUCCESSFUL
      IF ( ITSTEP .GT. 1
     F     .AND. ACCINF(ITSTEP-1,30) .LT. 0.
     F   ) DEL=MIN(TP1*DELOLD,DEL0)
C*************************************************************
C     INCLUDE NEARLY BINDING INEQUALITY CONSTRAINTS
C*************************************************************
      DO I=NH+1,NRES
        TERM=RES(I)/GRESN(I)
        IF ( BIND(I) .EQ. 0 .AND. TERM .LE. DEL*DELFAC(I) ) THEN
C  IT MAY BE USEFUL TO INCLUDE  CONSTRAINTS>0  IF  NEAR ITS BOUNDARY
C  BUT AVOID IT, IF THE CONSTRAINT WAS IN THE OLD DELETE-LIST
            BIND(I)=1
            ALIST(0)=ALIST(0)+1
            ALIST(ALIST(0))=I
            IF ( .NOT. VAL(I) ) THEN
              VAL(I)=.TRUE.
              CALL ESGRADG(I-NH,X,YY)
              DO J=1,N
                GRES(J,I)=YY(J)
              ENDDO
              GRESN(I)=MAX(ONE,O8VECN(1,N,YY))
            ENDIF
        ENDIF
      ENDDO
      RANK0=RANK
      NR0=NR
      NR=ALIST(0)
      CALL O8DEC(NR0+1,NR)
      IF ( RANK .NE. NR .AND. .NOT. SILENT ) CALL O8MSG(3)
      CALL O8HT(1,0,RANK0+1,RANK,N,QR,BETAQ,QGF,TRVEC)
      DO I=1,N
        QGF(I)=TRVEC(I)
      ENDDO
      DO I=1,N
        YY(I)=-QGF(I)*SCF
      ENDDO
      DO I=1,NRES
        YU(I)=ZERO
      ENDDO
C************************************************************
C     FIRST COMPUTATION OF LAGRANGIAN MULTIPLIERS U
C************************************************************
      CALL O8SOL(1,RANK,YY,YU)
      UMIN=ZERO
      UNORM=ZERO
      DO I=1,NRES
        U(I)=ZERO
      ENDDO
      IUMIN=0
      UMINSC=ZERO
      DO I=1,RANK
        UNORM=MAX(UNORM,ABS(YU(I)))
        K=ALIST(COLNO(I))
        U(K)=-YU(I)
        IF ( K .GT. NH ) THEN
          IF ( -YU(I)/GRESN(K) .LT. UMINSC ) THEN
            IUMIN=K
            UMINSC=-YU(I)/GRESN(K)
          ENDIF
        ENDIF
      ENDDO
      IF ( SCF .NE. ZERO ) THEN
        DO I=1,N
          YX(I)=SCF*GRADF(I)
          DO J=1,NRES
            YX(I)=YX(I)-GRES(I,J)*U(J)
          ENDDO
        ENDDO
        B2N=O8VECN(1,N,YX)/SCF
      ELSE
        B2N=-ONE
      ENDIF
      IF ( .NOT. SILENT ) CALL O8INFO(3)
C********** COMPUTE NEW DELTA
      DEL1=DEL
      IF ( B2N .GE. ZERO  )
     F DEL1=MAX(DEL,
     F   TM1*MIN(DEL0,
     F   EXP(P7*LOG( ABS(B2N)/(GFN+ONE) + MAX(ZERO,-UMINSC) + SUM))  ))
C**** EXCLUDE CONSTRAINTS WHICH WERE CANDIDATES FOR INACTIVATING
C     IN THE PREVIOUS STEP
C**** IF USEFUL
      DO I=1,DELIST(0)
        J=DELIST(I)
        TERM1=RES(J)/GRESN(J)*(ONE-TM2)/DELFAC(J)
        IF ( TERM1 .GE. DEL1*TM2 ) DEL1=MAX(DELMIN,MIN(DEL1,TERM1))
      ENDDO
      SLACKN=ZERO
      DO I=NH+1,NRES
        SLACKN=SLACKN+
     F  MAX(ZERO,RES(I)/GRESN(I)-DELMIN)*MAX(ZERO,U(I)-SMALLW)/GRESN(I)
      ENDDO
      IF ( UPSI .LE. DELMIN .AND. B2N .LE. EPSX*(GFN+ONE)
     F     .AND. B2N .NE. -ONE
     F     .AND. UMINSC .GE. -SMALLW .AND.
     F     SLACKN .LE. DELMIN*SMALLW*NRES ) THEN
C SUFFICIENT ACCURACY IN KUHN-TUCKER CONDITIONS
        OPTITE=ZERO
        RETURN
      ENDIF
C******** INCLUDE ADDITIONAL CONSTRAINTS IF NECESSARY
      L0=ALIST(0)
      DO I=1,NRES
        TERM=RES(I)/GRESN(I)/DELFAC(I)
        IF ( TERM .GT. DEL .AND. TERM .LE. DEL1
     F      .AND. BIND(I) .EQ. 0) THEN
          BIND(I)=1
          ALIST(0)=ALIST(0)+1
          ALIST(ALIST(0))=I
          IF ( .NOT. VAL(I) ) THEN
            VAL(I)=.TRUE.
            CALL ESGRADG(I-NH,X,YY)
            DO J=1,N
              GRES(J,I)=YY(J)
            ENDDO
            GRESN(I)=MAX(ONE,O8VECN(1,N,YY))
          ENDIF
        ENDIF
      ENDDO
      DEL=DEL1
      ACCINF(ITSTEP,6)=DEL
      ACCINF(ITSTEP,7)=B2N0
      ACCINF(ITSTEP,9)=ALIST(0)
      ACCINF(ITSTEP,10)=-1.
      NR=ALIST(0)
      IF ( L0 .NE. NR ) THEN
        RANK0=RANK
        CALL O8DEC(L0+1,NR)
        CALL O8HT(1,0,RANK0+1,RANK,N,QR,BETAQ,QGF,TRVEC)
        DO I=1,N
          QGF(I)=TRVEC(I)
        ENDDO
      ENDIF
      IF ( .NOT. SILENT ) CALL O8INFO(2)
      IF ( RANK .NE. NR ) THEN
        IF ( .NOT. SILENT ) CALL O8MSG(4)
        GOTO 400
      ENDIF
C************************************************************
C     SECOND SOLUTION FOR MULTIPLIERS, RANK MAY HAVE CHANGED !
C************************************************************
      DO I=1,N
        YY(I)=-QGF(I)*SCF
      ENDDO
      DO I=1,NRES
        YU(I)=ZERO
      ENDDO
      CALL O8SOL(1,RANK,YY,YU)
C*** REMEMBER THE COLUMN INTERCHANGES IN QR!
C*** YU(I) CORRESPONDS TO U(ALIST(COLNO(I))
      UMIN=ZERO
      UNORM=ZERO
      DO I=1,NRES
        U(I)=ZERO
      ENDDO
      IUMIN=0
      UMINSC=ZERO
      DO I=1,RANK
        UNORM=MAX(UNORM,ABS(YU(I)))
        K=ALIST(COLNO(I))
        U(K)=-YU(I)
        IF ( K .GT. NH ) THEN
          UMIN=MIN(UMIN,-YU(I))
          IF ( -YU(I)/GRESN(K) .LT. UMINSC ) THEN
            IUMIN=K
            UMINSC=-YU(I)/GRESN(K)
          ENDIF
        ENDIF
      ENDDO
      IF ( SCF .NE. ZERO ) THEN
        DO I=1,N
          YX(I)=SCF*GRADF(I)
          DO J=1,NRES
            YX(I)=YX(I)-GRES(I,J)*U(J)
          ENDDO
        ENDDO
        B2N=O8VECN(1,N,YX)/SCF
      ENDIF
      ACCINF(ITSTEP,8)=B2N
      ACCINF(ITSTEP,11)=UMIN
      CALL O8SHMS
      IF ( .NOT. SILENT ) CALL O8INFO(4)
      DELIST(0)=0
      IF ( PHASE .GE. 0 .AND. B2N .NE. -ONE ) THEN
        IF ( ABS(UMINSC) .GE. MAX(SMALLW,ABS(B2N)/(GFN+ONE)*C1D)) THEN
          DO I=NH+1,NR
            K=ALIST(COLNO(I))
            IF ( -YU(I)/GRESN(K) .LE. -SMALLW
     F            ) THEN
              DELIST(0)=DELIST(0)+1
              DELIST(DELIST(0))=K
            ENDIF
          ENDDO
        ENDIF
      ENDIF
C*** THE NEW DELIST DOESN'T INFLUENCE THE CURRENT D BUT ONLY THE
C*** COMPUTATION
C*** OF THE NEXT DEL
C***************************************************************
      EQRES=.TRUE.
      DO I =1,NRES
        EQRES=EQRES .AND. ( BIND(I) .EQ. BIND0(I) )
      ENDDO
C
C
C*****  COMPUTE CONDITION NUMBER ESTIMATORS OF DIAG-R AND DIAG OF
C*****  CHOLESKY-DECOMPOSITION OF B
      IF ( NR .GT. 1 ) THEN
        TERM=ZERO
        TERM1=ONE
        DO I=1,NR
          TERM=MAX(TERM,ABS(DIAG(I)))
          TERM1=MIN(TERM1,ABS(DIAG(I)))
        ENDDO
        ACCINF(ITSTEP,13)=TERM/TERM1
      ELSEIF ( NR .EQ. 1 ) THEN
        ACCINF(ITSTEP,13)=1.
      ELSE
        ACCINF(ITSTEP,13)=-1.
      ENDIF
      TERM=ABS(A(1,1))
      TERM1=ABS(A(1,1))
      I=2
      DO WHILE ( I .LE. N )
          TERM=MAX(TERM,ABS(A(I,I)))
          TERM1=MIN(TERM1,ABS(A(I,I)))
          I=I+1
      ENDDO
      ACCINF(ITSTEP,14)=(TERM/TERM1)**2
      IF ( .NOT. SILENT ) CALL O8INFO(5)
C*** SINCE A REPRESENTS THE CHOLESKY-FACTOR, THIS SQUARE
      SLACKN=ZERO
      DO I=NH+1,NRES
        SLACKN=SLACKN+
     F  MAX(ZERO,RES(I)/GRESN(I)-DELMIN)*MAX(ZERO,U(I)-SMALLW)/GRESN(I)
      ENDDO
      IF (  UMIN .GE. -SMALLW .AND.
     F      SLACKN .LE. DELMIN*SMALLW*NRES  .AND.
     F      UPSI .LE. NRES*DELMIN .AND. UPSI0 .LE. NRES*DELMIN
     F      .AND. ABS(FX-FX0) .LE. EPS*(ABS(FX)+ONE) .AND.
     F      B2N .NE. -ONE .AND.
     F      B2N .LE. TP2*EPSX*(GFN+ONE)    ) THEN
        CSDIFX=CSDIFX+1
      ELSE
        CSDIFX=0
      ENDIF
      IF ( PHASE .GE. 0 .AND.
     F     (ACCINF(ITSTEP,14) .GT. TP3 .OR. .NOT. ANALYT ) .AND.
     F    CSDIFX .GT. N     ) THEN
          OPTITE=FOUR
C****     TO AVOID POSSIBLE SLOW CONVERGENCE WITH SINGULAR
C****     PROJECTED HESSIAN OR INACCURATE NUMERICAL GRADIENTS
          RETURN
      ENDIF
C
C
C****** COMPUTE DAMPING FACTOR FOR TANGENTIAL COMPONENT IF UPSI>TAU0/2
      SCF0=ONE
      IF ( PHASE .GE. 0 .AND. UPSI .GT. TAU0*P5 )
     F   SCF0=MAX(ONE/SCFMAX,
     F        (TWO*(TAU0-UPSI)/TAU0)*UPSI*TM1/MAX(ONE,GFN) )/SCF
      ACCINF(ITSTEP,15)=SCF0
C
C
C************************************************************
C   COMPUTE TANGENTIAL COMPONENT
C************************************************************
      DO I=NR+1,N
        QTX(I)=YY(I)*SCF0
      ENDDO
C
C
C**** QTX(NR+1),..,QTX(N) IS S2
C************************************************************
C   COMPUTE RIGHT HAND SIDE AND VERTICAL COMPONENT
C   USE DAMPING FOR INACTIVATION DIRECTION IF VERY LARGE
C   NO INDIRECT INACTIVATION IF INFEASIBILITY LARGE AND
C   WE ARE NOT ALMOST STATIONARY ON THE CURRENT MANIFOLD
C************************************************************
      FAC=ONE
      IF ( -UMIN*C1D .GT. B2N+UPSI .AND. B2N .NE. -ONE ) FAC=C1D
      IF ( UPSI .GT. TAU0*P5 ) FAC=ZERO
      DO I=1,NR
        K=ALIST(COLNO(I))
        TERM=RES(K)
        IF ( K .GT. NH .AND. -YU(I) .LT. ZERO
     F       .AND. TERM .GT. ZERO ) TERM=-TERM
        IF ( K .GT. NH .AND. -YU(I) .LT. ZERO )
     F       TERM=TERM-YU(I)*FAC
        YX(I)=-TERM
      ENDDO
      CALL O8SOLT(1,NR,YX,QTX)
C**** QTX IS TRANSFORMED  DIRECTION OF DESCENT FOR PHI
      CALL O8HT(-1,0,1,NR,N,QR,BETAQ,QTX,YX)
      DO I=1,N
        QTX(PERM(I))=YX(I)
      ENDDO
C**** SOLVE L(TRANSP)*D=QTX, L = A = CHOLESKY-FACTOR OF B
      CALL O8RGHT(A,QTX,D,TERM,N)
C**** END SOLVER
C***** COMPUTE NEW PENALTY WEIGHTS : REGULAR CASE
      CLWOLD=CLOW
      IF ( PHASE .GE. 0  ) CALL O8SCE
      IF ( CLOW .GT. CLWOLD ) THEN
C*** TAU_QP DEPENDS ON THE (NEW) WEIGHTS
        TERM=W(1)
        DO I=1,NRES
          TERM=MAX(TERM,W(I))
        ENDDO
        TAUQP=MAX(ONE,MIN(TAUQP,TERM))
      ENDIF
C
C
C
C**** COMPUTE PARAMETER PHASE AND STOPPING CRITERION
      IF ( UMINSC .LT. -SMALLW ) PHASE=MIN(1,PHASE)
      IF ( .NOT. EQRES ) PHASE=MIN(0,PHASE)
      IF ( EQRES .AND. UPSI .LT. TAU0 ) PHASE=MAX(1,PHASE)
C*** RESCALE AND PROJECT D IF APPROPRIATE
      CALL O8CUTD
C*** COMPUTE THE DIRECTIONAL DERIVATIVE DIRDER
      CALL O8DIRD
C*** TERMINATE IF CORRECTION IS SMALL
      IF ( DNORM .LE. EPSX*(XNORM+EPSX) .AND. UPSI .LE. DELMIN
     F     .AND. B2N .NE. -ONE
     F     .AND. UMINSC .GE. -SMALLW .AND. B2N .LE. EPSX*(GFN+ONE) )
     F     THEN
        OPTITE=ONE
        RETURN
      ENDIF
  350 CONTINUE
C***** REENTER FROM THE SINGULAR CASE: DIRDER HAS BEEN COMPUTED ALREADY
      ACCINF(ITSTEP,16)=XNORM
      ACCINF(ITSTEP,17)=DNORM
      ACCINF(ITSTEP,18)=PHASE
C***** COMPUTE STEPSIZE
      CFINCR=ICF
C****
C****
C**** IF NO DESCENT DIRECTION IS OBTAINED, CHECK WHETHER RESTARTING
C**** THE METHOD
C**** MIGHT HELP
      IF ( DIRDER .GE. ZERO  ) THEN
C**** NO DIRECTION OF DESCENT
        IF ( .NOT. SILENT ) CALL O8MSG(11)
        STPTRM=-TWO
        SIG=ZERO
        GOTO 360
      ENDIF
C**** IF DIRECTIONAL DERIVATIVE CORRECT BUT VERY SMALL, TERMINATE
C**** SINCE NO FURTHER PROGRESS MIGHT BE POSSIBLE
      IF (-DIRDER.LE.EPSMAC*TP2*(SCF*ABS(FX)+PSI+ONE))THEN
        IF ( UPSI .GT. DELMIN*NRES ) THEN
          OPTITE = -ONE
          STPTRM = -ONE
        ELSE
          OPTITE = TWO
          STPTRM = ONE
        ENDIF
        SIG = ZERO
        GOTO 360
      ENDIF
C*** PHASE = 2 : WE MAY HOPE TO OBTAIN SUPERLINEAR CONVERGENCE
C*** SWITCH TO MARATOS-CORRECTION IS ON THEN
C*** RETURN TO PHASE=1 IF FIRST ORDER CORRECTION LARGE
      IF ( PHASE .GE. 1
     F .AND. DNORM .LE. SMALLD*(XNORM+SMALLD) .AND. SCF0 .EQ. ONE .AND.
     F     UMINSC .GE. -SMALLW  .AND. .NOT. SINGUL) PHASE=2
      IF ( PHASE .EQ. 2 .AND. DNORM .GT. (XNORM+SMALLD) )
C*** RETURN TO PHASE 1 SINCE CORRECTION LARGE AGAIN
     F     PHASE=1
C
C
      CALL O8SMAX
C*** STMAXL IS THE MAXIMAL STEPSIZE SUCH THAT POINT ON PROJECTED
C*** RAY CHANGES WITH SIGMA, BUT SIGLA AT MOST
      DO I=1,N
        DD(I)=ZERO
        X1(I)=X(I)+D(I)
      ENDDO
C**** CORRECTION ADDED . ERROR MESSAGE FROM RSI-FRANCE
      VIOBND=.FALSE.
      DO I=1,N
        IF ( (LLOW(I) .AND. X1(I) .LT. UG(I)-TAUBND) .OR.
     *    (LUP(I) .AND. X1(I) .GT. OG(I)+TAUBND) ) VIOBND=.TRUE.
      ENDDO
C**** END CORRECTION
C**** COMPUTE SECOND ORDER CORRECTION OF INFEASIBILITY IF USEFUL
      IF ( PHASE .EQ. 2 .AND. DNORM .GT. XNORM*SQRT(EPSMAC)
     F  .AND. (.NOT. SINGUL)  .AND. (.NOT. VIOBND) ) THEN
       IF ( BLOC ) CALL USER_EVAL(X1,-1)
C***** ONLY FUNCTION VALUES, FROM XTR=XSC*X1
        DO I=1,ALIST(0)
          YX(I)=ZERO
          IF ( I.LE. NH .AND. .NOT. GCONST(ALIST(I)) ) THEN
            CFUERR(I)=.FALSE.
            CALL ESH(I,X1,YX(I))
            IF ( CFUERR(I) ) GOTO 355
          ELSE
            IF ( .NOT. GCONST(ALIST(I)) ) THEN
              CFUERR(ALIST(I))=.FALSE.
              CALL ESG(ALIST(I)-NH,X1,YX(I))
              IF ( CFUERR(ALIST(I)) ) GOTO 355
            ENDIF
          ENDIF
          YX(I)=-YX(I)
        ENDDO
        DO I=1,ALIST(0)
          YY(I)=YX(COLNO(I))
        ENDDO
        CALL O8SOLT(1,NR,YY,DD)
        DO I=NR+1,N
          DD(I)=ZERO
        ENDDO
        CALL O8HT(-1,0,1,NR,N,QR,BETAQ,DD,YX)
        DO I=1,N
          DD(PERM(I))=YX(I)
        ENDDO
        CALL O8RGHT(A,DD,DD,TERM,N)
        IF ( SQRT(TERM) .GT. P5*DNORM ) THEN
C*** SECOND ORDER CORRECTION ALMOST AS LARGE AS FIRST ORDER ONE:
C*** NOT USEFUL
          DO I=1,N
            DD(I)=ZERO
          ENDDO
          IF ( .NOT. SILENT ) CALL O8MSG(6)
        ENDIF
      ENDIF
  355 CONTINUE
      IF ( .NOT. SILENT ) CALL O8INFO(7)
C
C
      SIG=MIN(ONE,STMAXL)
      CALL O8UNIM(SIG)
C
C
  360 CONTINUE
      CFINCR=ICF-CFINCR
      IF ( .NOT. SILENT ) CALL O8INFO(10)
C***** COUNT SUCCESSIVE SMALL STEPS
      TERM=SCF*(FX0-FX)+PSI0-PSI
      IF ( ABS(TERM) .LE. EPSPHI*(SCF*ABS(FX)+PSI) ) THEN
       CSMDPH=CSMDPH+1
      ELSE
       CSMDPH=0
      ENDIF
C**** CSMDPH COUNTS CONTIGUOUS SMALL DIFFERENCES OF PENALTY
C**** FUNCTION PHI
      IF ( CSMDPH .GT. NUMSM ) THEN
        OPTITE=SEVEN
        RETURN
      ENDIF
      IF ( SIG .LE. FIVE*TM2 ) THEN
        IF ( SIG0 .LE. FIVE*TM2 ) CSSSIG=CSSSIG+1
      ELSE
        CSSSIG=0
      ENDIF
C***
C***  CSSSIG COUNTS THE NUMBER OF SUCCESSIVE SMALL SIG'S
C***
      ACCINF(ITSTEP,21)=SIG
      ACCINF(ITSTEP,22)=CFINCR
      ACCINF(ITSTEP,23)=DIRDER
      ACCINF(ITSTEP,24)=DSCAL
      ACCINF(ITSTEP,25)=COSPHI
      ACCINF(ITSTEP,26)=VIOLIS(0)
      IF ( SIG .EQ. ZERO .AND. STPTRM .EQ. ONE .AND.
     F     OPTITE .EQ. TWO ) THEN
C******* NO FURTHER SIGNIFICANT PROGRESS POSSIBLE
         IF ( .NOT. SILENT ) CALL O8INFO(17)
         RETURN
      ENDIF
      IF ( STPTRM .EQ. ONE .AND. SIG .LE. TM4 .AND.
     F     ACCINF(ITSTEP,13) .GT. TP4 .AND. .NOT. SINGUL
     F    .AND. NRES .GT. 0) THEN
C*** TRY A REGULARIZED STEP, HOPEFULLY THIS WILL GIVE A BETTER D
C    AND LARGER SIG
           IF ( ACCINF(ITSTEP,14) .GT. TP4 ) CALL O8INIM
           IDENT=.TRUE.
           SINGUL=.TRUE.
           GOTO 400
      ENDIF
      IF ( STPTRM .LT. ZERO ) THEN
C******* STEPSIZE SELECTION FAILED
        IF (  .NOT. IDENT )
     F    THEN
C******* TRY RESTART WITH A = IDENTITY SCALED
          IF ( .NOT. SILENT ) CALL O8MSG(7)
          IDENT=.TRUE.
          DELIST(0)=0
          VIOLIS(0)=0
          CSREG=0
          CSSSIG=0
          CSIRUP=0
          CALL O8INIM
          ALIST(0)=NRBAS
          DO I=1,NRES
            BIND(I)=BINDBA(I)
          ENDDO
          IF ( UPSI .GE. TAU0 ) THEN
            GOTO 100
          ELSE
            GOTO 200
          ENDIF
        ENDIF
        IF ( .NOT. SINGUL .AND. IDENT .AND.
     F     ACCINF(ITSTEP,13) .GT. TP4 .AND. NRES .GT. 0 ) THEN
C**** TRY THE FULL SQP-DIRECTION
C**** THIS MAY BE THE THIRD TRY FOR THIS POINT
          SINGUL=.TRUE.
          IDENT=.TRUE.
          GOTO 400
        ENDIF
        IF ( STPTRM .EQ. -TWO ) THEN
          OPTITE=-FOUR
          RETURN
        ENDIF
        IF ( SIG .EQ. ZERO .AND. OPTITE .EQ. -ONE ) RETURN
C***** UNIDIMENSIONAL SEARCH UNSUCCESSFULLY TERMINATED
        OPTITE=-TWO
        RETURN
      ENDIF
C*****
      IF ( SINGUL .AND. ITSTEP .GT. N .AND. ABS(FX-FX0) .LE.
     F     EPS*(ABS(FX)+ONE) .AND. PHASE .GE. 0
     F     .AND. UPSI .LE. NRES*DELMIN  .AND. UPSI0 .LE. NRES*DELMIN
     F     .AND. SLACKN .LE. DELMIN*SMALLW*NRES
     F     .AND. INFEAS .LE. UPSI
     F     .AND. .NOT. IDENT ) THEN
C****** SINCE MULTIPLIERS MAY BE INCORRECT FOR INFEAS .NE. ZERO BE
C****** CAREFUL. IF MULTIPLIERS ARE IMPORTANT CHECK IN SOLCHK
        OPTITE=FOUR
C****** AVOID SLOW PROGRESS IN CASE OF SINGULAR CONSTRAINTS ****
        RETURN
      ENDIF
C****** RELAXED TERMINATION CRITERIA IN THE SINGULAR CASE
      IF ( SINGUL .AND. UPSI .LE. DELMIN*NRES .AND. UPSI0 .LE.
     F     DELMIN*NRES
     F   .AND.  B2N .NE. -ONE
     F   .AND.  B2N .LE. (GFN+ONE)*EPSX*TP2 .AND. PHASE .GE. 0
     F   .AND. SLACKN .LE. DELMIN*SMALLW*NRES
     F   .AND. INFEAS .LE. UPSI ) THEN
C****** SINCE MULTIPLIERS MAY BE INCORRECT FOR INFEAS .NE. ZERO
C****** BE CAREFUL. IF MULTIPLIERS ARE IMPORTANT CHECK IN SOLCHK
C******
        OPTITE=THREE
        RETURN
      ENDIF
      K=0
      DO I=1,N
        IF ( ABS(DIFX(I)) .GE. EPSX*(ABS(X(I))+TM2)) K=1
      ENDDO
      IF ( K .EQ. 0  ) THEN
        CSCHGX=CSCHGX+1
      ELSE
        CSCHGX=0
      ENDIF
      IF ( CSCHGX .GT. NRESET .AND. SINGUL ) THEN
C**** VERY SLOW PROGRESS IN X IN THE SINGULAR CASE. TERMINATE
        OPTITE=FIVE
        RETURN
      ENDIF
C*********** NEW VALUE OF X HAS BEEN ACCEPTED
      XNORM=O8VECN(1,N,X)
      IDENT=.FALSE.
      CALL O8EGPH(GPHI0)
      DO I=0,NRES
        IF ( .NOT. GCONST(I) )  VAL(I)=.FALSE.
      ENDDO
C
      IF ( BLOC ) CALL USER_EVAL(X,2)
C     EVALUATE GRADIENTS ONLY, SINCE FUNCTION VALUES ARE ALREADY
C     VALID FROM UNIDIMENSIONAL MINIMIZATION
C     ARGUMENT IS XTR=XSC*X
      IF ( PHASE .GE. 0 .AND. .NOT. GCONST(0) ) THEN
        VAL(0)=.TRUE.
        CALL ESGRADF(X,GRADF)
      ENDIF
      DO I=1,ALIST(0)
        L=ALIST(I)
        IF ( .NOT. VAL(L) ) THEN
          VAL(L)=.TRUE.
          IF ( L .LE. NH ) THEN
            CALL ESGRADH(L,X,YX)
          ELSE
            CALL ESGRADG(L-NH,X,YX)
          ENDIF
          DO J=1,N
            GRES(J,L)=YX(J)
          ENDDO
          GRESN(L)=MAX(ONE,O8VECN(1,N,YX))
        ENDIF
      ENDDO
      CALL O8EGPH(GPHI1)
      DO I=1,N
        YX(I)=X(I)-X0(I)
        YY(I)=GPHI1(I)-GPHI0(I)
      ENDDO
C**** SINCE A REPRESENTS THE CHOLESKY-FACTOR, THIS SQRT
      TERM=SQRT(O8VECN(1,N,YY)/O8VECN(1,N,YX))
      IF ( TERM .NE. ZERO .AND. PHASE .GE. 0 )
     F      MATSC=MAX(ONE/SCFMAX,MIN(SCFMAX,TERM/2))
C**** CURRENT SCALING OF IDENTITY IN CASE OF RESTART
C
      ALIST(0)=0
      DO I=1,NRES
        U0(I)=U(I)
        BIND0(I)=BIND(I)
        RES0(I)=RES(I)
        IF ( I.LE. NH ) THEN
          BIND(I)=1
        ELSE
          BIND(I)=0
          IF ( RES(I)/GRESN(I) .LE. DELMIN ) BIND(I)=1
          IF ( .NOT. VAL(I) .AND. BIND(I) .EQ. 1 ) THEN
            VAL(I)=.TRUE.
            CALL ESGRADG(I-NH,X,YX)
            DO J=1,N
              GRES(J,I)=YX(J)
            ENDDO
            GRESN(I)=MAX(ONE,O8VECN(1,N,YX))
          ENDIF
        ENDIF
        IF ( BIND(I) .EQ. 1 ) THEN
          ALIST(0)=ALIST(0)+1
          ALIST(ALIST(0))=I
        ENDIF
      ENDDO
C**** DEFINE EVALUATION SEQUENCE FOR CONSTRAINTS:
C**** NONBINDING INEQUALITIES IN ASCENDING ORDER OF VALUE
C**** BEFORE  THE BINDING ONES (COMMENTED HERE,
C**** TOO EXPENSIVE FOR NG LARGE)
CSORT      K=0
CSORT      DO I=1,NRES
CSORT        IF ( BIND(I) .EQ. 0 ) THEN
CSORT          K=K+1
CSORT          SORT(K)=I
CSORT          WORK(K)=RES(I)
CSORT        ENDIF
CSORT      ENDDO
CSORT      DO I=1,ALIST(0)
CSORT        K=K+1
CSORT        SORT(K)=ALIST(I)
CSORT        WORK(K)=RES(ALIST(I))
CSORT      ENDDO
CSORT      DO I=1,NRES-ALIST(0)
CSORT        TERM=WORK(I)
CSORT        J=I
CSORT        DO K=I+1,NRES-ALIST(0)
CSORT          IF ( WORK(K) .LT. TERM )  THEN
CSORT            TERM=WORK(K)
CSORT            J=K
CSORT          ENDIF
CSORT        ENDDO
CSORT        K=SORT(I)
CSORT        SORT(I)=SORT(J)
CSORT        SORT(J)=K
CSORT        TERM=WORK(I)
CSORT        WORK(I)=WORK(J)
CSORT        WORK(J)=TERM
CSORT      ENDDO
C**** BIND NOW CORRESPONDS TO THE STATE OF THE NEW POINT
C**** BUT THERE MAY BE GRADIENTS EVALUATED AT THE NEW POINT
C**** NOT YET PUT TO BIND
C****
C**** UPDATE THE UNPROJECTED QUASI-NEWTON-MATRIX ANYWAY
C****
      IF ( SCF .NE. ZERO ) THEN
       IF ( CSIRUP .GT. NRESET .OR. CSSSIG .GT. NRESET
     F      .OR. CSREG  .GT. NRESET
     F     ) THEN
         CSREG=0
         CSSSIG=0
         CSIRUP=0
         CALL O8INIM
       ELSE
         CALL O8BFGS
C*** FOR PROJECTED UPDATE:   IF ( .NOT. SILENT ) CALL O8INFO(13)
C*** FOR PANTOJA&MAYNE UPDATE:
         IF ( .NOT. SILENT ) CALL O8INFO(14)
       ENDIF
      ENDIF
C****
C**** PROCEED
C****
      IF(ACCINF(ITSTEP,27) .EQ. ONE ) THEN
        IF( ITSTEP .GT. 1 .AND.
     F    ACCINF(ITSTEP-1,29).NE.ZERO.AND.ACCINF(ITSTEP,29).NE.ZERO)
     F  THEN
C*** C OUNT S UCCESSIVE IR REGULAR UP DATES
          CSIRUP=CSIRUP+1
        ELSE
          CSIRUP=0
        ENDIF
      ENDIF
C**** ACCINF(ITSTEP,27) =1     UPDATE  PANTOJA&MAYNE
C****                   =0     NOUPDATE
C****                   =-1    RESTART
C****                   =2     NORMAL BFGS (NR=0)
C****                   =3     POWELL'S MODIFIED BFGS (NR=0)
C**** ACCINF(ITSTEP,28) =      MODIFICATION TERM TK/ DEN2/DEN1  RESP.
C**** ACCINF(ITSTEP,29) =      MODIFICATION FACTOR TH/XSIK RESP.
C**** CSIRUP COUNTS THE NUMBER OF SUCCESSIVE IRREGULAR UPDATING STEPS
      IF ( PHASE .EQ. -1 ) THEN
        GOTO 100
      ELSE
        GOTO 200
      ENDIF
  400 CONTINUE
      SINGUL=.TRUE.
      PHASE=MIN(PHASE,0)
      ACCINF(ITSTEP,10)=ONE
C************ TRY TO COMPUTE A DESCENT DIRECTION USING
C************ AN EXTENDED QUADRATIC PROGRAM WITH
C************ INDIVIDUAL SLACK VARIABLE FOR ANY CONSTRAINT
C****** COMPUTE DAMPING FACTOR FOR TANGENTIAL COMPONENT IF UPSI>TAU0/2
C****** BY RESCALING F IF POSSIBLE
      SCF0=ONE
      IF ( PHASE .GE. 0 .AND. UPSI .GT. TAU0*P5 ) THEN
        SCFH=MAX(ONE/SCFMAX,
     F      MIN(SCFMAX,
     F          (TWO*(TAU0-UPSI)/TAU0)*UPSI*TAU/MAX(ONE,GFN) ) )
        IF ( (FXST-FX)*SCFH+SCFH/SCF*(PSIST-PSI) .GE.
     F     SCFH/SCF*ETA*CLOW .AND. LASTCH .LE. ITSTEP-4
     F     .AND. SCFH .LT. TM1*SCF .OR. SCFH .GT. TP1*SCF )THEN
C*** RESCALE THE OBJECTIVE FUNCTION IF THIS SEEMS PROMISING AND THE
C*** CHANGE IS SIGNIFICANT
          CLOW=CLOW+1
          TERM=SCFH/SCF
          SCF0=TERM
          PSI=PSI*TERM
          PSIST=PSIST*TERM
          DO I=1,NRES
            U(I)=U(I)*TERM
          ENDDO
          UNORM=UNORM*TERM
          SCF=SCFH
          LASTCH=ITSTEP
          ACCINF(ITSTEP,15)=SCF
          TERM=SQRT(TERM)
          DO  I=1,N
            DIAG0(I)=TERM*DIAG0(I)
            DO  J=1,N
              A(J,I)=A(J,I)*TERM
            ENDDO
          ENDDO
          MATSC=MATSC*TERM
          IF ( .NOT. SILENT ) CALL O8MSG(2)
        ENDIF
      ENDIF
C***  SLACK IS UPSI AT MOST
      ACCINF(ITSTEP,32)=UPSI
      IF ( .NOT. SILENT ) CALL O8INFO(15)
C***
C***
      ACCINF(ITSTEP,13)=-ONE
      TERM=ABS(A(1,1))
      TERM1=TERM
      I=2
      DO WHILE ( I .LE. N )
          TERM=MAX(TERM,ABS(A(I,I)))
          TERM1=MIN(TERM1,ABS(A(I,I)))
          I=I+1
      ENDDO
      ACCINF(ITSTEP,14)=(TERM/TERM1)**2
      IF ( .NOT. SILENT ) CALL O8INFO(5)
      CLWOLD=CLOW
C*** SAVE FOR RESTART
      TAUQP0=TAUQP
      DO I=1,NRES
        U(I)=ZERO
      ENDDO
      DO I=1,N
        DD(I)=ZERO
      ENDDO
C
C
      CALL O8QPDU
      IF ( DNORM .EQ. ZERO .AND. QPTERM .EQ. 1
     F    .AND. OPTITE .EQ. THREE  ) RETURN
      IF ( DNORM .LE. EPSX*(MIN(XNORM,ONE)+EPSX) .AND.
     F     QPTERM .LT. 0  )
     F  THEN
C*** MAY BE IT FAILED BECAUSE OF ILLCONDITIONING
        IF ( UPSI .GE. NRES*DELMIN
     F      .AND. QPNEW ) THEN
C*** RESTARTING THE METHOD HAS BEEN DONE ALREADY: GAME IS OVER
          OPTITE=-ONE
          IF ( .NOT. SILENT ) CALL O8INFO(18)
          RETURN
        ENDIF
        IF ( QPNEW ) THEN
          OPTITE=QPTERM-FIVE
          IF ( .NOT. SILENT ) CALL O8INFO(18)
          RETURN
        ENDIF
C*** TRY A=ID
          QPNEW=.TRUE.
          DO I=1,NRES
            W(I)=ONE
          ENDDO
          LASTCH=ITSTEP
          CALL O8INIM
          IDENT=.TRUE.
C FORMERLY TAUQP=TAUQP0
          TAUQP=ONE
          ALIST(0)=NRBAS
          DO I=1,NRES
            BIND(I)=BINDBA(I)
          ENDDO
          IF ( SCF .EQ. ZERO ) THEN
            GOTO 100
          ELSE
            GOTO 200
          ENDIF
      ENDIF
      ACCINF(ITSTEP,11)=ZERO
      DELIST(0)=0
      UMIN=ZERO
C*** B2N IS DEFINED ALSO INTERNALLY IN O8QPDU
      CALL O8SHMS
      IF ( (QPTERM .GE. 0 .OR. QPTERM .EQ. -3)
     F         .AND. SCF .NE. ZERO ) THEN
        UNORM=ABS(U(1))
        DO I=2,NRES
          UNORM=MAX(UNORM,ABS(U(I)))
        ENDDO
        DO I=1,N
          YX(I)=SCF*GRADF(I)
          DO J=1,NRES
            YX(I)=YX(I)-GRES(I,J)*U(J)
          ENDDO
        ENDDO
        B2N=O8VECN(1,N,YX)/SCF
      ELSE
        B2N=-ONE
C*** SIGNALS "UNDEFINED" HERE
      ENDIF
      IF ( .NOT. SILENT ) CALL O8INFO(2)
      IF ( .NOT. SILENT ) CALL O8INFO(16)
C*** TO AVOID TERMINATION
      IF ( B2N .EQ. -ONE ) B2N=EPSMAC/TOLMAC
      IF ( QPTERM .GE. 0
     F   .AND. DNORM .LE. TM2*EPSX*(EPSX+MIN(ONE,XNORM)))
     F   THEN
           IF ( UPSI .LE. NRES*DELMIN ) THEN
             OPTITE=SIX
           ELSE
             OPTITE=-FIVE
           ENDIF
           RETURN
      ENDIF
C***
C***
C**** CHECK WHETHER QPSOLVER TERMINATED UNSUCCESSFULLY
      IF ( QPTERM .LT. 0 ) THEN
C*** WE HAVE A UNFEASIBLE  SOLUTION FOR QP. TRY IT
C*** BUT DON'T COMPLAIN IF IT FAILS
          IF ( .NOT. SILENT ) CALL O8MSG(10)
      ENDIF
      IF ( CLOW .GT. CLWOLD ) THEN
        TERM=ONE
        DO I=1,NRES
          TERM=MAX(TERM,W(I))
        ENDDO
        TAUQP=MAX(ONE,TERM)
      ENDIF
      IF ( TAUQP .GT. TAUFAC**3*TAUQP0 )TAUQP=TAUFAC**3*TAUQP0
C*** NO CHANGE OF TAUQP OTHERWISE
      B2N0=B2N
      UMIN=ZERO
      UMINSC=ZERO
      IF ( QPTERM .GE. 1 ) THEN
        SLACKN=ZERO
        DO I=NH+1,NRES
          SLACKN=SLACKN+
     F MAX(ZERO,RES(I)/GRESN(I)-DELMIN)*MAX(ZERO,U(I)-SMALLW)/GRESN(I)
        ENDDO
      ELSE
C*** SLACK IS UNDEFINED, SINCE MULTIPLIERS ARE UNDEFINED.
C*** USE THIS VALUE TO PREVENT PREMATURE TERMINATION
        SLACKN=ONE
      ENDIF
      GOTO 350
      END
