      SUBROUTINE SETUP
C   NO SPECIAL USER DATA
      INCLUDE 'O8COMM.INC'
      INCLUDE 'O8FINT.INC'
      TE0=.TRUE.
      TE2=.TRUE.
      RETURN
      END
      SUBROUTINE SETUP0
      INCLUDE 'O8COMM.INC'
CCC   INCLUDE 'O8FINT.INC'
      INTEGER I,J
      DOUBLE PRECISION XST0(10)
      DATA (XST0(I),I=1,10)
     F     /1745.D0,12.D3,11.D1,3048.D0,1974.D0,89.2D0,92.8D0,8.D0,
     1       3.6D0,145.D0/
C   NAME IS IDENT OF THE EXAMPLE/USER AND CAN BE SET AT USERS WILL
C   THE FIRST CHARACTER MUST BE ALPHABETIC.  40 CHARACTERS MAXIMUM
       NAME='ALKYLATION'
C   X IS INITIAL GUESS AND ALSO HOLDS THE CURRENT SOLUTION
C   PROBLEM DIMENSION N=DIM(X), NH=DIM(H), NG=DIM(G)
      N=10
      NH=3
      NG=28
      ANALYT=.TRUE.
      EPSDIF=1.d-16
CCC      EPSFCN=1.D-16
CCC      TAUBND=5.D-6
CCC      BLOC=.TRUE.
CCC      DIFFTYPE=3
      PROU=10
      MEU=20
      NRESET=N
C   DEL0 AND TAU0: SEE BELOW
      DEL0=1.0D0
COLD      DEL0=0.2D0
      TAU0=1.D0
      TAU=0.1D0
      DO I=1,N
      X(I)=XST0(I)
      ENDDO
C    GUNIT-ARRAY, SEE BELOW
      DO J=0,11
      GUNIT(1,J)=-1
      GUNIT(2,J)=0
      GUNIT(3,J)=0
      ENDDO
      DO J=12,31
      GUNIT(1,J)=1
      IF ( J .LE. 21 ) THEN
        GUNIT(2,J)=J-11
        GUNIT(3,J)=1
      ELSE
        GUNIT(2,J)=J-21
        GUNIT(3,J)=-1
      ENDIF
      ENDDO
      RETURN
      END

C     OBJECTIVE FUNCTION
      SUBROUTINE EF(X,FX)
      INCLUDE 'O8FUCO.INC'
      DOUBLE PRECISION FX,X(*)
      ICF=ICF+1
      FX=5.04D0*X(1)+.035D0*X(2)+10.D0*X(3)+3.36D0*X(5)-.063D0*X(4)*X(7)
      RETURN
      END
C     GRADIENT OF OBJECTIVE FUNCTION
      SUBROUTINE EGRADF(X,GRADF)
      INCLUDE 'O8FUCO.INC'
      INTEGER J
      DOUBLE PRECISION X(*),GRADF(*),A(10)
      SAVE A
      DATA A/5.04D0,0.035D0,10.D0,0.D0,3.36D0,5*0.D0/
      ICGF=ICGF+1
      DO      100      J=1,10
      GRADF(J)=A(J)
 100  CONTINUE
      GRADF(4)=-0.063D0*X(7)
      GRADF(7)=-0.063D0*X(4)
      RETURN
      END

C  COMPUTE THE I-TH EQUALITY CONSTAINT, VALUE IS HXI
      SUBROUTINE EH(I,X,HXI)
      INCLUDE 'O8FUCO.INC'
      DOUBLE PRECISION X(*),HXI
      INTEGER I
      CRES(I)=CRES(I)+1
      GOTO (100,200,300),I
  100 CONTINUE
      HXI=1.22D0*X(4)-X(1)-X(5)
      RETURN
  200 CONTINUE
      HXI=9.8D4*X(3)/(X(4)*X(9)+1.D3*X(3))-X(6)
      RETURN
  300 CONTINUE
      HXI=(X(2)+X(5))/X(1)-X(8)
      RETURN
      END
C  COMPUTE THE GRADIENT OF THE I-TH EQUALITY CONSTRAINT
      SUBROUTINE EGRADH(I,X,GRADHI)
      INCLUDE 'O8FUCO.INC'
      INTEGER I,J
      DOUBLE PRECISION X(*),GRADHI(*),T,T1
      CGRES(I)=CGRES(I)+1
      DO      100      J=1,10
      GRADHI(J)=0.D0
  100 CONTINUE
      GOTO(200,300,400),I
  200 CONTINUE
      GRADHI(1)=-1.D0
      GRADHI(4)=1.22D0
      GRADHI(5)=-1.D0
      RETURN
  300 CONTINUE
      T=9.8D4/(X(4)*X(9)+1.D3*X(3))
      T1=T/(X(4)*X(9)+1.D3*X(3))*X(3)
      GRADHI(3)=T-1.D3*T1
      GRADHI(4)=-X(9)*T1
      GRADHI(9)=-X(4)*T1
      GRADHI(6)=-1.D0
      RETURN
  400 CONTINUE
      GRADHI(1)=-(X(2)+X(5))/X(1)**2
      GRADHI(2)=1.D0/X(1)
      GRADHI(5)=GRADHI(2)
      GRADHI(8)=-1.D0
      RETURN
      END

C COMPUTE THE I-TH INEQUALITY CONSTAINT, BOUNDS INCLUDED

      SUBROUTINE EG(I,X,GXI)
      INCLUDE 'O8FUCO.INC'
      INTEGER I,K
      DOUBLE PRECISION GXI
      DOUBLE PRECISION X(NX),OG(10),UG(10),A,B,C,D,T
      SAVE A,B,C,D,UG,OG
      DATA A/.99D0/, B/.9D0/, C/2.01010101010101D-2/, D/
     1       2.11111111111111D-1/
      DATA OG/2.D3,16.D3,1.2D2,5.D3,2.D3,93.D0,95.D0,12.D0,4.D0,162.D0/
      DATA UG/5*1.D-5,85.D0,90.D0,3.D0,1.2D0,145.D0/
      IF ( GUNIT(1,I+NH) .EQ. -1 ) CRES(I+NH)=CRES(I+NH)+1
      IF(I .GT. 8)      GOTO 500
      K=(I+1)/2
      GOTO(100,200,300,400) K
  100 CONTINUE
      T=35.82D0-.222D0*X(10)-B*X(9)
      IF(K+K .EQ. I)    T=-T+X(9)*D
      GXI=T
      RETURN
  200 CONTINUE
      T=-133.D0+3.D0*X(7)-A*X(10)
      IF(K+K .EQ. I)    T=-T+C*X(10)
      GXI=T
      RETURN
  300 CONTINUE
      T=1.12D0*X(1)+.13167D0*X(1)*X(8)-.00667D0*X(1)*X(8)**2-A*X(4)
      IF(K+K .EQ. I)    T=-T+C*X( 4)
      GXI=T
      RETURN
  400 CONTINUE
      T=57.425D0+1.098D0*X(8)-.038D0*X(8)**2+.325D0*X(6)-A*X(7)
      IF(K+K .EQ. I)    T=-T+C*X( 7)
      GXI=T
      RETURN
  500 CONTINUE
      IF(I .GT. 18)   GXI=OG(I-18)-X(I-18)
      IF(I .LE. 18)   GXI=X(I-8)-UG(I-8)
      END
C COMPUTE THE GRADIENT OF THE I-TH INEQUALITY CONSTAINT
      SUBROUTINE EGRADG(I,X,GRADGI)
      INCLUDE 'O8FUCO.INC'
      INTEGER I,J,K
      DOUBLE PRECISION X(NX) ,GRADGI(NX),A,B,C,D
      SAVE A,B,C,D
      DATA A/.99D0/, B/.9D0/, C/1.01010101010101D0 /, D/
     1       1.11111111111111D0/
       DO     50       J=1,NX
       GRADGI(J)=0.D0
   50  CONTINUE
      IF(I .GT. 8)     GOTO 500
      K=(I+1)/2
      GOTO(100,200,300,400) K
  100  CONTINUE
      IF(K+K .EQ. I)      GOTO 150
      GRADGI(9)=-B
      GRADGI(10)=-.222D0
      RETURN
  150 CONTINUE
      GRADGI( 9)= D
      GRADGI(10)= .222D0
      RETURN
  200 CONTINUE
      IF(K+K .EQ. I)      GOTO 250
      GRADGI( 7)=3.D0
      GRADGI(10)=-A
      RETURN
  250 CONTINUE
      GRADGI( 7)=-3.D0
      GRADGI(10)=  C
      RETURN
  300 CONTINUE
      GRADGI( 1)=1.12D0+.13167D0*X(8)-.00667D0*X(8)**2
      GRADGI( 4)= -A
      GRADGI( 8)=.13167D0*X(1)-.01334D0*X(1)*X(8)
      IF(K+K .NE. I)      RETURN
      GRADGI( 1)=-GRADGI(1)
      GRADGI( 8)=-GRADGI(8)
      GRADGI( 4)=  C
      RETURN
  400 CONTINUE
      GRADGI( 6)=.325D0
      GRADGI( 7)= -A
      GRADGI( 8)=1.098D0-.076D0*X(8)
      IF(K+K .NE. I)      RETURN
      GRADGI( 6)=-.325D0
      GRADGI( 7)=C
      GRADGI( 8)=-GRADGI(8)
      RETURN
  500 CONTINUE
      IF(I .GT. 18)     GRADGI(I-18)=-1.D0
      IF(I .LE. 18)     GRADGI(I-8)=1.D0
      RETURN
      END
