#include "cp_types.h"
#include "cp_proto.h"

int outer_poison(struct p_data *p,struct Vertlist *facelist)
/* given a closed chain of faces, mark outer vertices as "poison" 
by seting util_flag; for use in computing face drawing order. 
facelist is unchanged. */
{
  int i,f,f1,f2,ind,count=0;
  struct Vertlist *trace;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  for (i=1;i<=p->nodecount;i++) pK_ptr[i].util_flag=0;
  if (facelist && facelist->next && facelist->next->next) 	
    {
      trace=facelist;
      while (trace->next->next!=NULL) trace=trace->next;
      f=trace->v; /* find last face */
      trace=facelist;
      while (trace->next!=NULL) /* cycle to end */
	{
	  f1=f;
	  f=trace->v;
	  f2=trace->next->v;
	  if ((ind=nghb_tri(p,f2,f))>=0)
	    {
	      pK_ptr[p->faces[f].vert[ind]].util_flag = -1;
	      count++;
	    }
	  else if (nghb_tri(p,f2,f1)>=0) /* f is blue;
					    meaning list goes "f1->f->f2".*/
	    {
	      for (i=0;i<3;i++) 
		pK_ptr[p->faces[f].vert[i]].util_flag =-1;
	      count += 2;
	    }
	  trace=trace->next;
	}
    }
  return count;
} /* outer_poison */

int set_poison(struct p_data *p,char *datastr)
/* 'Poison' verts are used to define a new
complex from a current one, as in the cookie process. This routine
merely sets util_flag=-1 to designate poison vertices. */
{
  int i,hits,count=0;
  char *endptr;
  struct Vertlist *vertlist,*trace;

  if (!(vertlist=Node_link_parse(p,datastr,&endptr,&hits,
		 &Vlist,&Elist,&Flist,&region,pathlist,pathlength)))
    return count;
  for (i=1;i<=p->nodecount;i++) p->packK_ptr[i].util_flag=0;
  trace=vertlist;
  while (trace)
    {
      p->packK_ptr[trace->v].util_flag=-1;
      trace=trace->next;
      count++;
    }
  vert_free(&vertlist);
  return count;
} /* set_poison */

int poison_patch(struct p_data *p,int seed,char *datastr)
/* mark as 'poison' (util_flag=-1) the connected component of 
p containing 'seed' but avoiding given list of verts. Return 
vert on shared bdry of this patch and its
complement, or 0 on error. */
{
  int i,j,k,hits,v;
  char *endptr;
  struct Vertlist *genlist=NULL,*trace,*gtrace;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  if (!p->status || p->locks || seed<0 || seed > p->nodecount
      || !(genlist=Node_link_parse(p,datastr,&endptr,&hits,
		   &Vlist,&Elist,&Flist,&region,pathlist,pathlength)))
    return 0;
  for (i=1;i<=p->nodecount;i++) pK_ptr[i].util_flag=0;
  trace=genlist;
  while (trace) 
    {
      pK_ptr[trace->v].util_flag=1;
      trace=trace->next;
    }
  vert_free(&genlist);
  /* seed should not be among list of verts */
  if (pK_ptr[seed].util_flag) return 0;

  genlist=gtrace=(struct Vertlist *)
    calloc((size_t)1,sizeof(struct Vertlist));
  genlist->v=seed;
  pK_ptr[seed].util_flag=-1;
  /* go through adding to end of list and knocking off from
     front until all connected verts are marked as poison */
  while (genlist)
    {
      for (j=0;j<(pK_ptr[(v=genlist->v)].num+pK_ptr[v].bdry_flag);j++)
	if (pK_ptr[(k=pK_ptr[v].flower[j])].util_flag==1)
	  {
	    pK_ptr[k].util_flag=-1;
	    gtrace=gtrace->next=(struct Vertlist *)
	      calloc((size_t)1,sizeof(struct Vertlist));
	    gtrace->v=k;
	  }
      trace=genlist;
      genlist=genlist->next;
      free(trace);
    }
  /* now find an interior of p which is not poison, but is on 
     edge of poison patch. */
  for (i=1;i<=p->nodecount;i++)
    if (!pK_ptr[i].bdry_flag && pK_ptr[i].util_flag>=0)
      for (j=0;j<pK_ptr[i].num;j++)
	if (pK_ptr[pK_ptr[i].flower[j]].util_flag==-1)
	  return i;
  return 0; /* didn't find appropriate bdry vert */
} /* poison_patch */
