#include "cp_types.h"
#include "cp_proto.h"

/* returns inversive dist */

int choose_alpha(struct p_data *p)
/* Choose new alpha if needed. */
{
  int flag=0,i;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  i=p->alpha;
  if (i>0 && i<=p->nodecount && !pK_ptr[i].bdry_flag) 
    /* alpha okay already */
    {
      if (p->alpha==p->gamma) p->gamma=pK_ptr[p->alpha].flower[0];
      return 1;
    }
  i=0;
  do
    {
      i++;
      if (pK_ptr[i].flower[0]==pK_ptr[i].flower[pK_ptr[i].num])
	flag=1;
    }
  while (i<p->nodecount && !flag);
  if (flag) p->alpha=i;
  else if (p->beta!=1) p->alpha=1;
  else p->alpha=pK_ptr[p->beta].flower[0];
  if (p->gamma==p->alpha) 
    p->gamma=pK_ptr[p->alpha].flower[0];
  return 1;
} /* choose_alpha */

int choose_beta(struct p_data *p)
/* when need to choose new beta; avoid alpha */
{
  int i;
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  i=p->beta;
  if (i>0 && i<=p->nodecount 
      && (pK_ptr[i].bdry_flag || p->num_bdry_comp==0)) return 1; /* okay */
  i=1;
  while (pK_ptr[i].bdry_flag==0 && i<p->nodecount) i++;
  if (i==p->alpha) i=pK_ptr[i].flower[0];
  p->beta=i;
  return 1;
}/*choose_beta*/

int choose_gamma(struct p_data *p)
/* avoid alpha */
{
  int i;

  i=p->gamma;
  if (i>0 && i<=p->nodecount && i!=p->alpha) return 1; /* okay */
  if (p->alpha==1) p->gamma=p->packK_ptr[1].flower[0];
  else p->gamma=1;
  return 1;
} /* choose_gamma */

int set_alpha(struct p_data *p,int i)
{
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  if (p->status && i>0 && i<=p->nodecount && !pK_ptr[i].bdry_flag)
    {
      p->alpha=i;
      if (i==p->gamma) p->gamma=pK_ptr[i].flower[0];
      facedraworder(p,0);
      return 1;
    }
  return 0;
} /* set_alpha */

int set_beta(struct p_data *p,int i)
{
  struct K_data *pK_ptr;

  pK_ptr=p->packK_ptr;
  if (p->status && i>0 && i<=p->nodecount && pK_ptr[i].bdry_flag)
    { p->beta=i; return 1; }
  return 0;
} /* set_beta */

int set_gamma(struct p_data *p,int i)
{
  if (p->status && i>0 && i<=p->nodecount && i != p->alpha)
    {p->gamma=i;return 1;}
  return 0;
} /* set_gamma */





