#include "cp_types.h"
#include "cp_proto.h"
#include "cp_post.h"

int post_cir_label(FILE *fp,struct p_data *p,int v)
{
  int front;
  double stretch;
  complex ctr;
  struct R_data *pR_ptr;
	
  if (!p->packK_ptr[v].plot_flag) return 0; 
  pR_ptr=p->packR_ptr;
  stretch=1.0+(p->screen->box.rx-p->screen->box.lx)*10/
    (p->screen->pix_box.rx-p->screen->pix_box.lx); 
  /* to shift horocycle labels a little to miss circle*/
  if (p->hes<0 && pR_ptr[v].rad<0)
    {
      ctr.re=pR_ptr[v].center.re*stretch;
      ctr.im=pR_ptr[v].center.im*stretch;
    } 
  else if (p->hes>0) 
    {
      ctr=ss_view(p->screen,pR_ptr[v].center,1,&front);
      if (!front) return 0;
      ctr=s_pt_to_visual_plane(ctr);
    }
  else ctr=pR_ptr[v].center;
  return (post_num(fp,ctr,v,p->screen->box));
} /* post_cir_label */

int post_caption(FILE *fp,char *datastr)
     /* not operational; puts commented-out string in postscript file */
{
  fprintf(fp,"\n%% ----- (%s) sh\nn\n",datastr);
  return 1;
} /* post_caption */

int post_face_label(FILE *fp,struct p_data *p,int face)
{
  int i0,i1,i2,front;
  complex ctr,p0,p1,p2;
  struct R_data *pR_ptr;

  if (!p->faces[face].plot_flag) return 0; 
  pR_ptr=p->packR_ptr;
  i0=p->faces[face].vert[0];p0=pR_ptr[i0].center;
  i1=p->faces[face].vert[1];p1=pR_ptr[i1].center;
  i2=p->faces[face].vert[2];p2=pR_ptr[i2].center;
  if (p->hes<=0)
    {
      ctr.re=(p0.re+p1.re+p2.re)*.33333;
      ctr.im=(p0.im+p1.im+p2.im)*.33333;
    }
  else if (p->hes>0)
    {
      ctr=sph_tri_center(p0,p1,p2);
      ctr=ss_view(p->screen,ctr,1,&front);
      if (!front) return 0;
      ctr=s_pt_to_visual_plane(ctr);
    }
  return (post_num(fp,ctr,face,p->screen->box));
} /* post_face_label */

int post_num(FILE *fp,complex pt,int n,Box box)
/* store postscript text */
{
  if (cir_ck(pt,okerr,box)) 
    fprintf(fp,"%f %f m (%d) sh\nn\n",
	    pt.re,pt.im,n);
  return 1;
} /* post_num */

