/* cp_geom.c = routines for geometric objects in the geometries */

#include "cp_head.h"

static int alist[200];
int dum_int;
extern complex ss_view();

int
hgeo(q,a,b,col,show) /* draws geodesic arc on screen q from a to b 
counterclockwise. Points are given as pts in plane. Returns 1 
if on screen. Use FG_COLOR if col==-1*/
struct s_data *q;
int col,show;
complex a,b;
{
	int diam;
	hyp_geodesic hg;
	complex cnr,normpt;

	h_geodesic(a,b,&hg);
	if (hg.line_flag) /* use straight line */
		return (kline(q,a,b,col,show));
	if (!geo_ck(hg,q->box)) return 0; /* geo is off screen */
	cnr.re=hg.c.re-hg.rad;cnr.im=hg.c.im+hg.rad;
	r_to_pix(cnr,&normpt,q->pix_box,q->box,Aspect);
	diam=(int) 2*hg.rad*(q->pix_box.rx)/
			(q->box.rx-q->box.lx);
	if (col>=0)
	 {
		XSetForeground(display,gc,colors[col]);
		XDrawArc(display,q->xpm,gc,(int)normpt.re,(int)normpt.im,diam,
			(int)(Aspect*diam),
			(int)(hg.arg1*degPI*(64.0)),
			(int)((hg.arg2-hg.arg1)*degPI*(64.0)));
		XSetForeground(display,gc,fgcolor);
	 }
	else XDrawArc(display,q->xpm,gc,(int)normpt.re,(int)normpt.im,diam,
		(int)(Aspect*diam),
		(int)(hg.arg1*degPI*(64.0)),
		(int)((hg.arg2-hg.arg1)*degPI*(64.0)));
	if (show) refresh_canvas(q);
	return 1;
} /* hgeo */

int
sgeo(q,a,b,col,show) /* draws spherical geodesic. Use FG_COLOR if col==-1*/
struct s_data *q;
int col,show;
complex a,b;
{
	int length=1;
	struct Pathlist *trace,*plist=NULL;
	extern XPoint *path_XPoints();
	XPoint *Xptr=NULL;

	if ((plist=s_geodesic(ss_view(q,a,1,&dum_int),
		ss_view(q,b,1,&dum_int),num_plot))==NULL) return 0;
	trace=plist;
	while ((trace->next)!=NULL)
	 {trace=trace->next;length++;}
	if (length<2) return 0;
	Xptr=path_XPoints(q,plist,&length);
	if (col>=0)
	 {
		XSetForeground(display,gc,colors[col]);
		XDrawLines(display,q->xpm,gc,Xptr,length,CoordModeOrigin);
		XSetForeground(display,gc,fgcolor);
	 }
	else XDrawLines(display,q->xpm,gc,Xptr,length,CoordModeOrigin);
	free(Xptr);path_free(&plist);
	if (show) refresh_canvas(q);
	return 1;
} /* sgeo */

int
s_draw_convex(q,list,ff,col,show) /* draws convex sph tri or circle.
?? problems managing list: should create/destroy list in approp routine,
but that seems to crash ?? */
struct s_data *q;
int ff,col,show;
struct Pathlist *list;
{
	int n=0;
	complex normpt,pt;
	struct Pathlist *trace;
	XPoint *pts;
	extern struct Pathlist *fix_convex_list();

	if (list==NULL || (list=fix_convex_list(list))==NULL) return 0;
	trace=list;
	while (trace!=NULL)
	 {
		n++;
		trace=trace->next;
	 }
	pts=(XPoint *)malloc((n+2)*sizeof(XPoint));
	trace=list;
	n=0;
	while (trace!=NULL)
	 {
		pt.re=trace->x;pt.im=trace->y;
		r_to_pix(pt,&normpt,q->pix_box,
			q->box,Aspect);
		pts[n].x=(short)normpt.re; 
		pts[n].y=(short)normpt.im;
		n++;
		trace=trace->next;
	 }
	pts[n].x=pts[0].x;
	pts[n].y=pts[0].y;
	if (ff)
	 {
		XSetForeground(display,gc_fill,colors[col]);
		XFillPolygon(display,q->xpm,gc_fill,
			pts,n+1,Nonconvex,CoordModeOrigin);
		XSetForeground(display,gc_fill,fgcolor);
	 }
	XDrawLines(display,q->xpm,gc,pts,n+1,CoordModeOrigin);
	if (show) refresh_canvas(q);
	path_free(&list);
	free(pts);
	return 1;
} /* s_draw_convex */

int
e_triangle(q,p1,p2,p3,ff,col,show)  /* draws eucl triangle on screen,
ff=fill flag, col=color index. */
struct s_data *q;
int ff,col,show;
complex p1,p2,p3;
{
	complex normpt;
	XPoint pts[4];

	r_to_pix(p1,&normpt,q->pix_box,
		q->box,Aspect);
	pts[0].x=pts[3].x=(short)normpt.re; 
	pts[0].y=pts[3].y=(short)normpt.im;
	r_to_pix(p2,&normpt,q->pix_box,
		q->box,Aspect);
	pts[1].x=(short)normpt.re; pts[1].y=(short)normpt.im;
	r_to_pix(p3,&normpt,q->pix_box,
		q->box,Aspect);
	pts[2].x=(short)normpt.re; pts[2].y=(short)normpt.im;
	if (ff) 
	 {
		XSetForeground(display,gc_fill,colors[col]);
		XFillPolygon(display,q->xpm,gc_fill,
			pts,4,Nonconvex,CoordModeOrigin);
		XSetForeground(display,gc_fill,fgcolor);
	 }
	XDrawLines(display,q->xpm,gc,pts,4,CoordModeOrigin);
	if (show) refresh_canvas(q);
} /* e_triangle */
	
int
e_polygon(p,vertlist,ff,col,show) /* draws eucl polygon through verts,
ff for filled. return 0 on error. */
struct p_data *p;
int ff,col,show;
struct Vertlist *vertlist;
{
	int numpts,N[1],i,tlist[1000],v,w;
	complex a,b,normpt;
	XPoint pts[1000];
	struct Vertlist *vtrace;
	struct R_data *pR_ptr;

	pR_ptr=p->packR_ptr;
	N[0]=0;
	if (!(vtrace=vertlist) || !(vtrace->next)) return 0;
/* build up tlist */
	while (vtrace && vtrace->next
	   && (v=vtrace->v)>0 && v<=p->nodecount
	   && (w=vtrace->next->v)>0 && w<=p->nodecount
	   && N[0] < 490 )
	 {
	   if (v!=w) /* eat repeats */
	    {
		a=pR_ptr[v].center;	
		b=pR_ptr[w].center;
		r_to_pix(a,&normpt,p->screen->pix_box,
			p->screen->box);
		alist[0]=normpt.re;alist[1]=normpt.im;
		r_to_pix(b,&normpt,p->screen->pix_box,
			p->screen->box);
		alist[2]=normpt.re;alist[3]=normpt.im;
		numpts = 2;
		for (i=0;i<2*numpts;i++) tlist[2*N[0]+i]=alist[i];
		N[0] += numpts;
	    }
	   vtrace=vtrace->next;
	 } /* end of while */
	for (i=0;i<N[0];i++)
	 {
		pts[i].x=(short)tlist[i*2];
		pts[i].y=(short)tlist[i*2+1];
	 }
	if (ff)  /* want filled */
	 {
		XSetForeground(display,gc_fill,colors[col]);
		XFillPolygon(display,p->screen->xpm,gc_fill,
			pts,N[0],Nonconvex,CoordModeOrigin);
		XSetForeground(display,gc_fill,fgcolor);
	 }
	XDrawLines(display,p->screen->xpm,gc,pts,N[0],CoordModeOrigin);
	if (show) refresh_canvas(p->screen);
	return 1;
} /* e_polygon */

int
h_triangle(q,p1,p2,p3,ff,col,show) /* draws hyperbolic triangle on screen, 
	ff is the fill flag */
struct s_data *q;
int ff,col,show;
complex p1,p2,p3;
{
	int numpts,N[1],i,tlist[600];
	complex normpt;
	hyp_geodesic hg1,hg2,hg3;
	XPoint pts[200];

	h_geodesic(p1,p2,&hg1);
	h_geodesic(p2,p3,&hg2);
	h_geodesic(p3,p1,&hg3); /* set triangle structures */

/* note: error arises when arcs go wrong way, but straight lines are
being used instead of arcs. Seem to cover edges more than once. */

	if (!geo_ck(hg1,q->box) && !geo_ck(hg2,q->box) && 
		!geo_ck(hg3,q->box)) return 1; 
	if (hg1.line_flag) /* use straight line */
	 {
		r_to_pix(p1,&normpt,q->pix_box,
			q->box,Aspect);
		alist[0]=normpt.re;alist[1]=normpt.im;
		r_to_pix(p2,&normpt,q->pix_box,
			q->box,Aspect);
		alist[2]=normpt.re;alist[3]=normpt.im;
		numpts=2;
	 }
	else numpts = polyarc(q,hg1.c,hg1.rad,hg1.arg1,hg1.arg2); 
		/* subroutine fills alist */
	if (hg1.z1.re==p1.re && hg1.z1.im==p1.im) 
		/* arc is drawn starting at p1 */
		for (i=0;i<2*numpts;i++) tlist[i]=alist[i];
	else 
		for (i=0;i<numpts;i++) 
		 {
			tlist[2*i]=alist[2*numpts-2-2*i];
			tlist[2*i+1]=alist[2*numpts-1-2*i];
		 }
		/* arc went wrong way */
	N[0]=numpts;
	if (hg2.line_flag) /* use straight line */
	 {
		r_to_pix(p2,&normpt,q->pix_box,
			q->box,Aspect);
		alist[0]=normpt.re;alist[1]=normpt.im;
		r_to_pix(p3,&normpt,q->pix_box,
			q->box,Aspect);
		alist[2]=normpt.re;alist[3]=normpt.im;
		numpts=2;
	 }
	else numpts = polyarc(q,hg2.c,hg2.rad,hg2.arg1,hg2.arg2); 
	if (hg2.z1.re==p2.re && hg2.z1.im==p2.im) 
		/* arc is drawn starting at p2 */
		for (i=0;i<2*numpts;i++) tlist[2*N[0]+i]=alist[i];
	else 
		for (i=0;i<numpts;i++) 
		 {
			tlist[2*N[0]+2*i]=alist[2*numpts-2-2*i];
			tlist[2*N[0]+2*i+1]=alist[2*numpts-1-2*i];
		 }
		/* arc went wrong way */
	N[0] += numpts;
	if (hg3.line_flag) /* use straight line */
	 {
		r_to_pix(p3,&normpt,q->pix_box,
			q->box,Aspect);
		alist[0]=normpt.re;alist[1]=normpt.im;
		r_to_pix(p1,&normpt,q->pix_box,
			q->box,Aspect);
		alist[2]=normpt.re;alist[3]=normpt.im;
		numpts=2;
	 }
	else numpts = polyarc(q,hg3.c,hg3.rad,hg3.arg1,hg3.arg2); 
	if (hg3.z1.re==p3.re && hg3.z1.im==p3.im) 
		/* arc is drawn starting at p3 */
		for (i=0;i<2*numpts;i++) tlist[2*N[0]+i]=alist[i];
	else 
		for (i=0;i<numpts;i++) 
		 {
			tlist[2*N[0]+2*i]=alist[2*numpts-2-2*i];
			tlist[2*N[0]+2*i+1]=alist[2*numpts-1-2*i];
		 }
		/* arc went wrong way */
	N[0] += numpts;
	for (i=0;i<N[0];i++)
	 {
		pts[i].x=(short)tlist[i*2];
		pts[i].y=(short)tlist[i*2+1];
	 }
	if (ff)
	 {
		XSetForeground(display,gc_fill,colors[col]);
		XFillPolygon(display,q->xpm,gc_fill,
			pts,N[0],Nonconvex,CoordModeOrigin);
		XSetForeground(display,gc_fill,fgcolor);
	 }
	XDrawLines(display,q->xpm,gc,pts,N[0],CoordModeOrigin);
	if (show) refresh_canvas(q);
	return 1;
} /* h_triangle */

int
h_polygon(p,vertlist,ff,col,show) /* draws hyp polygon through verts,
ff for filled. return 0 on error. Code has limit on length.*/
struct p_data *p;
int ff,col,show;
struct Vertlist *vertlist;
{
	int numpts,N[1],i,tlist[10000],v,w;
	complex a,b,normpt;
	hyp_geodesic hg;
	XPoint pts[10000];
	struct Vertlist *vtrace;
	struct R_data *pR_ptr;

	pR_ptr=p->packR_ptr;
	N[0]=0;
	if (!(vtrace=vertlist) || !(vtrace->next)) return 0;
/* build up tlist */
	while (vtrace && vtrace->next
	   && (v=vtrace->v)>0 && v<=p->nodecount
	   && (w=vtrace->next->v)>0 && w<=p->nodecount
	   && N[0] < 4500 )
	 {
	   if (v!=w) /* eat repeats */
	    {
		a=pR_ptr[v].center;	
		b=pR_ptr[w].center;
		h_geodesic(a,b,&hg);
		if (hg.line_flag) /* use straight line */
		 {
			r_to_pix(a,&normpt,p->screen->pix_box,
				p->screen->box);
			alist[0]=normpt.re;alist[1]=normpt.im;
			r_to_pix(b,&normpt,p->screen->pix_box,
				p->screen->box);
			alist[2]=normpt.re;alist[3]=normpt.im;
			numpts = 2;
		 }
		else numpts=polyarc(p->screen,hg.c,hg.rad,hg.arg1,hg.arg2);
			/* subroutine fills alist */
		if (hg.z1.re==a.re && hg.z1.im==a.im)
			/* arc starts at p1 */
		   for (i=0;i<2*numpts;i++) tlist[2*N[0]+i]=alist[i];
		else
		   for (i=0;i<numpts;i++)
		    {
			tlist[2*N[0]+2*i]=alist[2*numpts-2-2*i];
			tlist[2*N[0]+2*i+1]=alist[2*numpts-1-2*i];
		    }
			/* arc went opposite way */
		N[0] += numpts;
	    }
	   vtrace=vtrace->next;
	 } /* end of while */
	for (i=0;i<N[0];i++)
	 {
		pts[i].x=(short)tlist[i*2];
		pts[i].y=(short)tlist[i*2+1];
	 }
	if (ff)  /* want filled */
	 {
		XSetForeground(display,gc_fill,colors[col]);
		XFillPolygon(display,p->screen->xpm,gc_fill,
			pts,N[0],Nonconvex,CoordModeOrigin);
		XSetForeground(display,gc_fill,fgcolor);
	 }
	XDrawLines(display,p->screen->xpm,gc,pts,N[0],CoordModeOrigin);
	if (show) refresh_canvas(p->screen);
	return 1;
} /* h_polygon */

int
s_triangle(q,p1,p2,p3,ff,col,show) /* draws sph tri, ff is fill flag */
struct s_data *q;
int ff,col,show;
complex p1,p2,p3;
{
	struct Pathlist *list;
	extern struct Pathlist *sph_tri_list();

/* determine if convex from orientation */
	
	if ((list=sph_tri_list(p1,p2,p3,num_plot))==NULL) return 0;
	s_draw_convex(q,list,ff,col,show);
} /* s_triangle */

struct Pathlist *
sph_poly_list(p,v_list) /* clockw' list of geodesics in polygon. */
struct p_data *p;
struct Vertlist *v_list;
{
	int v,w,front;
	complex zv,zw;
	extern struct Pathlist *full_s_geodesic();
	struct Pathlist *firstlist,*nlist,*trace;
	struct Vertlist *vtrace;
	struct R_data *pR_ptr;

	pR_ptr=p->packR_ptr;
	firstlist=NULL;
	if (!(vtrace=v_list) || !(v_list->next)) return NULL;
	w=v_list->v;
	zw=ss_view(p->screen,pR_ptr[w].center,1,&front);
	vtrace=vtrace->next;
	while (vtrace)
	 {
		v=w;
		zv=zw;
		while (vtrace && vtrace->v == v) vtrace=vtrace->next;
			/* skip repeats */
		if (vtrace)
		 {
			w=vtrace->v;
			zw=ss_view(p->screen,pR_ptr[w].center,1,&front);
			if ((nlist=full_s_geodesic(zv,zw,num_plot))==NULL) 
		 	  {path_free(&firstlist);return NULL;}
			if (!firstlist) firstlist=trace=nlist;
			else trace->next=nlist;
			while (trace->next!=NULL) trace=trace->next;
			vtrace=vtrace->next;
		 }
	 }
	return firstlist;
} /* sph_poly_list */
	
int
s_polygon(p,vertlist,ff,col,show) /* draws hyp polygon through verts,
ff for filled. return 0 on error. Code has limit on length.*/
struct p_data *p;
int ff,col,show;
struct Vertlist *vertlist;
{
	struct Pathlist *list;
	extern struct Pathlist *sph_poly_list();

/* may give problems when not convex or goes behind sphere */

	if ((list=sph_poly_list(p,vertlist))==NULL) return 0;
	s_draw_convex(p->screen,list,ff,col,show);
} /* s_polygon */

int
polyarc(q,ctr,rad,a1,a2) /* puts points in 'alist' for arc of circle
from angle a1 counterclockwise to a2 on screen q. Uses matrix
approximation to d.e. (suggested by Ohannes):  given pt (wr,wi) on
circle, step as proportion of 2pi, then next counterclkws pt is
(zr,zi)=A*(wr,wi), matrix A. Return number of pts in list. */
struct s_data *q;
float rad,a1,a2;
complex ctr;
{
	int i,n;
	float ac,step,ss,a11,a12,a21,a22,zr,zi,wr,wi;
	complex pt,normpt;

	while ((ac=a2-a1)<0) a2 +=2.0*M_PI; /* make sure a2>a1 */
	n=ac/(2.0*M_PI)*10;
	n=n*10; /* n will be 0,10,20, etc. */
	if (n<10) n=10; /* tailor number of steps to proportion of circle */

	step=ac/n;
	ss=step*step/4;
	a11=(1-ss)/(1+ss);
	a12= (-step)/(1+ss);
	a21= (-a12);
	a22=a11; /* set up matrix A */

	zr=rad*cos(a1); zi=rad*sin(a1);
	n++;
	for (i=0;i<n;i++)
	{
		wr=zr;
		wi=zi;
		pt.re=wr+ctr.re;
		pt.im=wi+ctr.im;
		r_to_pix(pt,&normpt,q->pix_box,q->box,Aspect);
		alist[i*2]=normpt.re;
		alist[i*2+1]=normpt.im;
		zr=a11*wr+a12*wi;
		zi=a21*wr+a22*wi;
	} 
	return (n);
} /* polyarc */

void
bdry_dist(p,pt,b_dist,b_vert_dist) /* minimum eucl dist from complex 
value to polygonal bdry (b_dist) and to bdry vertices (b_vert_dist)
of pack p. */
struct p_data *p;
complex pt;
float *b_dist,*b_vert_dist;
{
	int i,j,k1,k2;
	float dist,dum,vert_dist;
	complex end1,end2,y;
	extern float seg_dist();

	for (i=1;i<=p->nodecount;i++) 
		p->packK_ptr[i].plot_flag=0;
	if (p->hes<0) /* hyp case */
	 {
		for (j=1;j<=p->num_bdry_comp;j++)
		 {
			k2=p->bdry_starts[j];
			h_to_e_data(p->packR_ptr[k2].center,
				p->packR_ptr[k2].rad,&end2,&dum);
			y=csub(end2,pt);
			*b_dist=cAbs(y); 
			*b_vert_dist=*b_dist;
			while (!p->packK_ptr[k2].plot_flag)
			 {
				end1=end2;
				k1=k2;
				k2=p->packK_ptr[k1].flower[0];
				h_to_e_data(p->packR_ptr[k2].center,
				   p->packR_ptr[k2].rad,&end2,&dum);
				dist=seg_dist(pt,end1,end2);
				*b_dist=(dist<*b_dist) ? dist : *b_dist;
				y=csub(end2,pt);
				vert_dist=cAbs(y);
				*b_vert_dist=(vert_dist<*b_vert_dist) ?
					vert_dist : *b_vert_dist;
				p->packK_ptr[k1].plot_flag=1;
			 }
		 }
		return;
	 }
	else if (p->hes==0) /* eucl case */
	 {
		for (j=1;j<=p->num_bdry_comp;j++)
		 {
			k2=p->bdry_starts[j];
			end2=p->packR_ptr[k2].center;
			y=csub(end2,pt);
			*b_dist=cAbs(y); 
			*b_vert_dist=*b_dist;
			while (!p->packK_ptr[k2].plot_flag)
			 {
				end1=end2;
				k1=k2;
				k2=p->packK_ptr[k1].flower[0];
				end2=p->packR_ptr[k2].center;
				dist=seg_dist(pt,end1,end2);
				*b_dist=(dist<*b_dist) ? dist : *b_dist;
				y=csub(end2,pt);
				vert_dist=cAbs(y);
				*b_vert_dist=(vert_dist<*b_vert_dist) ?
					vert_dist : *b_vert_dist;
				p->packK_ptr[k1].plot_flag=1;
			 }
		 }
		return;
	 }
} /* bdry_dist */

int
draw_any_face(p,face,ff,col,show) /* use approp geom */
struct p_data *p;
int face,ff,col,show;
{
	int i0,i1,i2,front;
	complex p0,p1,p2;

	if (!p->status || face<1 || face > p->facecount)
		return 0;
	i0=p->faces[face].vert[0];p0=p->packR_ptr[i0].center;
	i1=p->faces[face].vert[1];p1=p->packR_ptr[i1].center;
	i2=p->faces[face].vert[2];p2=p->packR_ptr[i2].center;
	if (p->hes<0) h_triangle(p->screen,p0,p1,p2,ff,col,show);
	else if (p->hes==0) e_triangle(p->screen,p0,p1,p2,ff,col,show);
	else if (p->hes>okerr) 
		s_triangle(p->screen,ss_view(p->screen,p0,1,&front),
			ss_view(p->screen,p1,1,&front),
			ss_view(p->screen,p2,1,&front),
			ff,col,show); 
	return 1;
} /* draw_any_face */

int
draw_any_circle(p,n,fill,col,show) /* draws circle in approp geometry */
struct p_data *p;
int n,fill,col,show;
{
	complex ctr;
	float r;

	if (n<1 || n > p->nodecount) return 0;
	ctr=p->packR_ptr[n].center;
	r=p->packR_ptr[n].rad;
	if (p->hes < 0) 
	 {
		h_to_e_data(ctr,r,&ctr,&r);
		circle(p->screen,ctr,r,fill,col,show);
	 }
	else if (p->hes > 0) 
		s_circle(p->screen,ss_view(p->screen,ctr,1,&dum_int),r,fill,col,show);
	else circle(p->screen,ctr,r,fill,col,show);
} /* draw_any_circle */
	

int
draw_edge(p,v1,v2,col,show) /* Use FG_COLOR if col==-1 */
struct p_data *p; 
int v1,v2,col,show;
{
	if (!p->status) return 0;
	if (p->hes<0) 
		hgeo(p->screen,p->packR_ptr[v1].center,
			p->packR_ptr[v2].center,col,show);
	else if (p->hes>0) 
		sgeo(p->screen,p->packR_ptr[v1].center,
			p->packR_ptr[v2].center,col,show);
	else  
		kline(p->screen,p->packR_ptr[v1].center,
			p->packR_ptr[v2].center,col,show);
	if (show) refresh_canvas(p->screen);
	return 1;
} /* draw_edge */

int
circle(q,ctr,r,ff,col,show) /* ff is fill flag, col=color */
struct s_data *q;
int ff,col,show;
complex ctr;
float r;
{
	int diam,nx,ny;
	complex normpt;

	ctr.re -= r;ctr.im +=r;
	r_to_pix(ctr,&normpt,q->pix_box,
		q->box,Aspect);
	diam=(int) 2*r*(q->pix_box.rx)/
			(q->box.rx-q->box.lx)+.5;
	if (diam > 20000  /* too big or rectangle misses pix_box */
		|| (nx=(int)normpt.re)>q->pix_box.rx
		|| nx+diam<0 
		|| ((ny=(int)normpt.im)+diam)<0  
		|| ny > q->pix_box.ry) return 0;
	if (ff) 
	 {
		XSetForeground(display,gc_fill,colors[col]);
		XFillArc(display,q->xpm,gc_fill,nx,ny,diam,diam,0,360*64);
		XSetForeground(display,gc_fill,fgcolor);
	 }
	XDrawArc(display,q->xpm,gc,nx,ny,diam,diam,0,360*64);
	if (show) refresh_canvas(q);
	return 1;
} /* circle */

int
s_circle(q,ctr,r,ff,col,show) /* ff is fill flag, col=color */
struct s_data *q;
int ff,col,show;
complex ctr;
float r;
{
	int n=0,i;
	float step,ss,a11,a12,a21,a22,zr,zi,wr,wi,arad;
	complex pt,normpt,antip;
	struct Pathlist *list,*ulist,*trace;
	XPoint *pts;
	extern struct Pathlist *fix_convex_list(),*s_circle_list();

	if (isnan((double)r)
		|| isnan((double)ctr.re) || isnan((double)ctr.im)
		|| r>=M_PI || r<=0.0)
		return 0; /* invalid data */
	if (!ff || r<=M_PI/2.0) /* convex circle */
	 {
		list=s_circle_list(ctr,r,num_plot);
		n=s_draw_convex(q,list,ff,col,show);
		return n;
	 }
/* non-convex filled circle, draw filled unit circle and filled cap;
use EvenOddRule. */
	antip.re=M_PI-ctr.re;
	antip.im=M_PI-ctr.im;
	arad=M_PI-r;
	list=fix_convex_list(s_circle_list(antip,arad,num_plot));
/* form unit circle list */
	ulist=(struct Pathlist *)calloc(1,sizeof(struct Pathlist));
	ulist->x=1.0;ulist->y=0.0;
	trace=ulist;
	step=2.0*M_PI/(float)num_plot;
	ss=step*step/4;
	a11=(1-ss)/(1+ss);a12= (-step)/(1+ss);a21= (-a12);a22=a11; 
	zr=1.0;zi=0.0;
	for (i=1;i<=num_plot;i++)
	{
		trace=trace->next=
		   (struct Pathlist *)calloc(1,sizeof(struct Pathlist));
		wr=zr;
		wi=zi;
		zr=a11*wr+a12*wi;
		zi=a21*wr+a22*wi;
		trace->x=zr;trace->y=zi;
	 }
	trace->next=list; /* link in cap, if any shows */
/* now to display combined list */
	trace=ulist;
	while (trace!=NULL)
	 {
		n++;
		trace=trace->next;
	 }
	pts=(XPoint *)malloc((n+2)*sizeof(XPoint));
	trace=ulist;
	n=0;
	while (trace!=NULL)
	 {
		pt.re=trace->x;pt.im=trace->y;
		r_to_pix(pt,&normpt,q->pix_box,
			q->box,Aspect);
		pts[n].x=(short)normpt.re; 
		pts[n].y=(short)normpt.im;
		n++;
		trace=trace->next;
	 }
	pts[n].x=pts[0].x;
	pts[n].y=pts[0].y;
	XSetForeground(display,gc_fill,colors[col]);
	XFillPolygon(display,q->xpm,gc_fill,
		pts,n+1,Nonconvex,CoordModeOrigin);
	XSetForeground(display,gc_fill,fgcolor);
/* redraw bdry of cap only */
	XDrawLines(display,q->xpm,gc,pts+num_plot+1,n-num_plot-1,CoordModeOrigin);
	if (show) refresh_canvas(q);
	free(pts);
	path_free(&ulist);
	return n;
} /* s_circle */

