/*
 * br_types.hpp  --  Part of the CinePaint plug-in "Bracketing_to_HDR"
 *
 * Copyright 2005  Hartmut Sbosny  <hartmut.sbosny@gmx.de>
 *
 * LICENSE:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/**
  br_types.hpp
    
  Einige globale Makros und einfache Typen des Bracketing_to_HDR-Projekts.
    Keine Abhaengigkeiten.
*/
#ifndef br_types_hpp
#define br_types_hpp


//#define DEBUG                    // allgemeine Debug-Makros
//#define HDR_DEBUG
//#define HDR_DEBUG_1
//#define HDR_WORKING_RANGE        // Auslassen schlechter Pixel


/*
 * Rueckgabwert der Korrelationsfunktionen bei einem Fehler:
 */
#define CORR_RES_ERR    -2.0


/*
 * Kuerzere und (Bit-praezise) Integer-Typnamen
 */
typedef int                 int32;
typedef long long           int64;

typedef unsigned char       uint8;
typedef unsigned short      uint16;
typedef unsigned int        uint32;
typedef unsigned long       ulong;
typedef unsigned long long  uint64, ullong;


/*
 * Genauigkeit, in der QR-Zerlegung durchgefuehrt wird
 */
typedef double Real;


/*
 * RGB-Struktur mit alpha-Kanal
 */
template <class T>          // Muss alpha ueberhaupt notwendig vom selben Typ
struct Rgba                 // wie die RGB's sein?
{                   
  T   r,g,b, alpha;
};


/*
 * Struktur XYindex:
 */
struct XYindex 
{
  int x,y;

  XYindex ()    {}                  // keine Nullung, Effizienz!
  XYindex (int _x, int _y) : x(_x), y(_y) {}
};


#endif    // br_types_hpp

// END OF FILE

