/*
 * installer/main.c
 *
 * Choose-OS main file.
 *
 * Copyright (c) Tuomo Valkonen 1996-1998.
 */
 
#include<stdio.h>
#include<strings.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<errno.h>
#include<malloc.h>
#include<stdarg.h>
                   
#include<chos/chos.h>
#include<chos/main.h>
#include<chos/image.h>
#include<chos/install.h>
#include<chos/map.h>
#include<chos/bin.h>

char inst_banner[]=
	"\nChoose-OS v"CHOS_VERSIONSTR" Installer. Copyright (c) Tuomo Valkonen 1996-1998.\n";
char usage_str[]=
	"\nUsage: chos [-h] [-v] [-view] [-y] [-t] [-c file] [-m file] [-b dir] [-i file]\n"
	"[See the HTML documentation for more information.]\n\n";

char def_cfg_file[]=	"/etc/chos.conf"; 

int		testing=0;
int		view=0;
int  		line_no;		
char*		cfgfname=def_cfg_file;
int  		noboot=0;
int		do_verbose=0;
int		yes_to_all=0;

#define LAST_LOOK 8
struct cfgstr_struct cfg_strings[]={
	{"delay=",	do_delay},
	{"banner=",	do_banner},
	{"infoline=",	do_infoline},
	{"color=",	do_color},
	{"selection=",	do_selection},
	{"background=",	do_background},
	{"menupos=",	do_menupos},
	{"timerpos=",	do_timerpos},
	{"default=",	do_default},

	{"install=",	do_install},
	{"emergency=",	do_emergency},
	{"bindir=",	do_chos_bindir},
	{"mapfile=",	do_chos_map},
	{"bgfile=",	do_chos_background},
	{"autoboot=",	do_autoboot},
	{"password=",	do_password},
	{"mapdrive=",	do_add_biosdrive_map},
	{NULL,NULL}
};

extern struct icfgstr_struct linux_cfgs[];
extern struct icfgstr_struct bfile_cfgs[];
#define bsect_cfgs bfile_cfgs

extern struct imagestr_struct	imgstr_linux,imgstr_biglinux,
				imgstr_bootfile,imgstr_bootsect;

struct imagestr_struct* cfg_images[]={
	&imgstr_linux,&imgstr_biglinux,
	&imgstr_bootfile,&imgstr_bootsect,NULL
};

void usage(void)
{
	fprintf(stderr,usage_str);
	exit(0);
}

int process_args(int argc,char*argv[])
{
	int	i;
	
	if(argc==1)
		return 0;
	
	for(i=1;i<argc;i++){
		if(!strcmp(argv[i],"-view")){
			testing=1;
			view=1;
			continue;
		}
		if(argv[i][0]!='-')
			return 1;
		switch(argv[i][1]){
		case	't':
			testing=1;
			break;
		case	'y':
			yes_to_all=1;
			break;
		case	'm':
			if(++i>=argc)return 1;
			do_chos_map(argv[i]);
			map_set=1;
			break;
		case	'c':
			if(++i>=argc)return 1;
			cfgfname=argv[i];
			break;
		case	'b':
			if(++i>=argc)return 1;
			do_chos_bindir(argv[i]);
			bindir_set=1;
			break;
		case	'i':
			if(++i>=argc)return 1;
			do_chos_background(argv[i]);
			background_set=1;
			break;
		case	'v':
			do_verbose=1;
			break;
		case	'h':
			usage();
		default:
			return 1;
		}
	}
	return 0;
}		

// Verify sizes of some important structures.
///////////////////////////////////////////////
static void verify_sizes()
{ 	
 	if(sizeof(MF_ImageDes)!=BID_DATA_SIZE)
 		die(-1,"sizeof(MF_ImageDes)!=BID_DATA_SIZE\n");
 	if(sizeof(MF_HeaderSector)>SECTORSIZE)
 		die(-1,"sizeof(MF_HeaderSector)>SECTORSIZE\n");
	if(sizeof(MF_ImageSector)>SECTORSIZE)
		die(-1,"sizeof(MF_ImageSector)>SECTORSIZE\n");
}


// I don't know what this does... ;)
//////////////////////////////////////
int main( int argc, char *argv[] )
{
 	FILE *cfgfile;
 	
 	fprintf(stderr,inst_banner);
 	
 	verify_sizes();

 	if(process_args(argc,argv))
 		usage();

 	fprintf(stderr,"\n");
 
 	if(*cfgfname=='-' && *(cfgfname+1)=='\0'){
		verbose("Reading configuration from stdin...\n");
 		cfgfile=stdin;
 	}else{
	 	verbose("Using %s as configuration file...\n",cfgfname);
		if( (cfgfile=fopen(cfgfname,"rb"))==NULL)
 			die(errno,cfgfname);
	}
	
	if(!((uchar*)background=(uchar*)malloc(80*25*2))){
		fprintf(stderr,"Aarrg! Outta memory.\n");
		exit(0);
	}
	
	clear_bg();			// clear background
	
	map_initialize();		// initialize map structures
	
	process_file(cfgfile);		// process the file
	
	fclose(cfgfile);
	
	if(view)
		view_it();		// view the configuration...
	else
		install_it();		// ...or install it.

	return 0;
}


inline char* strip_whitespace(char*str)
{
	while(*str==' ' || *str=='\t'){
		if(*str=='\0')
			break;
		str++;
	}
	return str;
}
	
// Processes config file line by line.
////////////////////////////////////////
void process_file( FILE *cfgf )
{
	char tmps[MAXLINELEN];	// Hopefully it is long enough...
	char*a;
	int  read=1,loop,i;
	int  in_image=0;
	int len;
	
	line_no=0;
	
	while(read!=0){
		read=read_line(cfgf,tmps);
		line_no++;
		
		if( tmps[0]=='\0' ) continue;

		if(in_image){
			if( in_image == -1) /* havent seen "{" yet */
			{
				if(*tmps=='{' && *(tmps+1)=='\0')
					in_image=1;
				else
					cfgsyntax("expected {\n");
			}
			else if(*tmps=='}' && *(tmps+1)=='\0')
			{
				in_image=0;
				end_image();
			}		
			else
				do_imagecfg(tmps);

			continue;
		}
		
		loop=0;
		while(cfg_strings[loop].str!=NULL){
	    		i=strlen(cfg_strings[loop].str);
			if(strncasecmp(cfg_strings[loop].str,tmps,i)){
				loop++;
				continue;
			}
			if(view && loop>LAST_LOOK)
				break;
			a=strip_whitespace(tmps+i);
			if(!*a && cfg_strings[loop].str[i-1]=='=')
				cfgerror("Argument expected");
		    	cfg_strings[loop].doit(a);
			break;
		}

		if(cfg_strings[loop].str!=NULL)
			continue;
			
		// Try the images...
		loop=0;
		while(cfg_images[loop]){
			i=strlen(cfg_images[loop]->str);
			if(strncasecmp(cfg_images[loop]->str,tmps,i)){
				loop++;
				continue;
			}
			a=strip_whitespace(tmps+i);

			len = strlen(a);
			if(a[len-1] == '{')
			{
				in_image=1;
				a[len-1] = '\0';
			}
			else
				in_image=-1;
			
			new_image(a,cfg_images[loop]);
			break;
		}
		if(cfg_images[loop])
			continue;
			
		cfgsyntax(NULL);
	}
}

/*
 * Read a line in a file.
 * Return 0 if EOF. Else number of bytes read.
 */
int read_line( FILE *file, char *line)
{
	int read=0;
	int a;
	int last_non_wspc=-1;
	
	while(1){
		a=fgetc(file);
		
		if(read==0 && (a==' ' || a=='\t'))
			continue;
		else if( a==EOF ){
			line[last_non_wspc+1]='\0';
			return 0;
		}else if( a=='\n' ){
			line[last_non_wspc+1]='\0';
			return read+1;
		}else if( a=='#' ){
			if(read!=0 && line[read-1]=='\\')
				read--;
			else{
				line[last_non_wspc+1]='\0';
				while(1){
					a=fgetc(file);
					if(a=='\n')return read+1;
					if(a==EOF)return 0;
				}
			}
		}
			
		line[read]=a;
		if( a!='\t' && a!=32 )last_non_wspc=read;
		read++;
		if(read==MAXLINELEN-1){
			fprintf(stderr,"A line in config file is too long. Truncated.\n");
			
			line[last_non_wspc+1]='\0';
			while(1){
				a=fgetc(file);
				if(a=='\n')return read;
				if(a==EOF)return 0;
			}
		}
	}
}			

void verbose(char *fmt,...)
{
	va_list	args;
	
	if(!do_verbose || view)
		return;
	
	va_start(args,fmt);
	vfprintf(stderr,fmt,args);
	va_end(args);
}

void warn(char *fmt,...)
{
	va_list	args;
	
	va_start(args,fmt);
	vfprintf(stderr,fmt,args);
	va_end(args);
	
	continue_yn();
}

/*
 * Print a syntax error message 'n die
 */
void cfgsyntax(char *moremsg,...)
{
	va_list	args;
	
	fprintf(stderr,"error: %s: line %d",cfgfname,line_no);
	if(moremsg){
		va_start(args,moremsg);
		fprintf(stderr,": ");
		vfprintf(stderr,moremsg,args);
		fprintf(stderr,"\n");
		va_end(args);
	}else
		fprintf(stderr,".\n");
		
	exit(0);
}


/*
 * Print an error code 'n exit.
 */
void die( int err, char *parm,...)
{
	va_list	args;
	va_start(args,parm);
	
	if(parm!=NULL && err==0 )
		fprintf(stderr,"%s:unknown error!!\n",parm);
	else if( parm!=NULL && err==-1 )
		vfprintf(stderr,parm,args);
	else if( parm!=NULL && err!=0 ){
		vfprintf(stderr,parm,args);
		fprintf(stderr,":%s\n",strerror(err));
	}else
		fprintf(stderr,"%s\n",strerror(err));
	
	va_end(args);
	
	exit(err);
	
}

/*
 * Display a "Continue [y/N]?" message 'n do what appropriate.
 */
void continue_yn(void)
{
	int		a,b;
	
	fprintf(stderr,"Continue [y/N]? ");
	
	if(yes_to_all){
		fprintf(stderr,"yes\n");
		return;
	}
	
	a=b=getchar();
	
	while(b!='\n' && b!=EOF)
		b=getchar();
		
	if( a=='y' || a=='Y' )
		return;
	
	exit(0);
}
