/*
 * loader/bsect.S
 *
 * Choose-OS bootsector.
 *
 * Copyright (c) Tuomo Valkonen 1996-1998.
 *
 */

#include <chos/chos.h>
#include <chos/mapfile.h>
#include <chos/address.h>

.text

.globl  _main

.org    0
_main:  jmp start

.org    2
chos_id:	.ascii	"CHO"		! "CHO"
chos_stage:	.byte	CHOS_BSECT	! 1= bootsector
chos_major:	.byte	CHOS_MAJOR	! major version #
chos_minor:	.byte   CHOS_MINOR	! minor version #

stage2_drive:	.byte	0		! stage 2 drive number	// long to align with gcc
map_drive:	.byte	0
emerg_drive:	.byte	0
bsect_drive:	.byte	0

stage2_sect1:	.long	1		! 1st 2nd stage sector address
stage2_sect2:	.long	2		! 2nd 2nd stage sector address
stage2_sect3:	.long	3		! 3rd 2nd stage sector address
stage2_sect4:	.long	4		! 4rd 2nd stage sector address
stage2_sect5:	.long	5

map_addr:	.long	5		! map header address
map_addr2:	.long	6		! image address
emerg_sect:	.long	1		! emergency bsect sector

// end of header

secno:		.byte	0
olddrive:	.byte	0xff

// Initialization
///////////////////
start:
#ifdef SUPPORT_REWRITE
/* stolen from a DOS MBR */
	cli			! disable ints
	xor	ax,ax		! set stack seg to 0000
	mov	ss,ax
	mov	sp,#0x7c00	! set stack ptr to 7c00 
	mov	si,sp		! SI now 0000:7c00
	push	ax
	pop	es		! ES now 0000:7c00
	push	ax
	pop	ds		! DS now 0000:7c00
	sti			! allow ints
	cld			! clear direction
	mov	di,#0x0600	! DI now 0600
	mov	cx,#0x0100	! move 256 words (512 bytes)
	repnz			! move MBR from 0000:7c00
	movsw			! to 0000:0600
#endif

	cli
	mov     ax,#BOOT_SEG	// init
        mov     ds,ax
	mov	sp,#STACK_SIZE
        mov     ax,#STACK_SEG
        mov     ss,ax
        sti

// Load 2nd stage
///////////////////
	mov	bx,#STAGE2_SEG
	mov	es,bx
	mov	bx,#STAGE2_OFF
	mov	cl,stage2_drive
	mov	secno,#STAGE2SECTS
	mov	si,#stage2_sect1
	call	load_sects

// Load map header/images right after second stage
////////////////////////////////////////////////////
	mov	cl,map_drive
	mov	secno,#2	
	mov	si,#map_addr
	call	load_sects	// bx already set when loading 2nd stage

// Verify second stage loader
///////////////////////////////
	seg	es		
	cmp	dword ptr [2+STAGE2_OFF],#0x024f4843 // 'C' 'H' 'O' 2
	jne	error
	seg	es
	cmp	byte ptr [6+STAGE2_OFF],#CHOS_MAJOR
	jne	error
	seg	es
	cmp	byte ptr [7+STAGE2_OFF],#CHOS_MINOR
	jne	error

	jmpi    #STAGE2_OFF,#STAGE2_SEG	

// Error handling
///////////////////
error:
lin_cyl_exceed:

lin_error:
#ifdef SUPPORT_EMERGENCY
	cmp	emerg_drive,#0xff
	jne	try_emerg
#else
	xor	di,di
	mov	al,secno
	add	al,#48
	seg	gs
	mov	(di),al
	
	mov     si,#text_error
        call    print
#endif
loop4ever:
	jmp     loop4ever


#if !(defined(SUPPORT_REWRITE) && defined(SUPPORT_EMERGENCY))
// Print a string
///////////////////
print:					! print null-terminated string
        mov     al,(si)			! where SI points to...
print_it:
        mov     ah,#0x0e
        xor     bh,bh
        int     #0x10
        inc     si
        mov     al,(si)
        cmp     al,#0
        jne     print_it

        ret
#endif

// Load sectors at ES:BX. 
// CL=drive, SI points to sector numbers.
///////////////////////////////////////////
load_sects:
	mov	ax,(si)
	mov	dx,(si+2)
	call	read_linear
	add	bh,#2
	add	si,#4
	dec	secno
	jnz	load_sects

	ret
	

// Emergency bootsector feature stuff
///////////////////////////////////////
#ifdef SUPPORT_EMERGENCY
#define EMERG_SEG	0x1000
try_emerg:
#ifndef SUPPORT_REWRITE
	mov	si,#text_emerg
	call	print
#endif
	// Move ourselves to 0x1000 (64k, should be safe)
	mov	ax,#EMERG_SEG
	mov	es,ax
	xor	si,si
	xor	di,di
	mov	cx,#512
	cld
	rep
	movsb
	mov	ds,ax
	jmpi	#emerg_jump,#EMERG_SEG
emerg_jump:
	mov	dl,emerg_drive
	mov	emerg_drive,#0xff
	call	reset_drive

        mov	bx,#BOOT_SEG
	mov	es,bx
	xor	bx,bx
	mov	cl,dl		// dl=emerg_drive
	mov	ax,emerg_sect
	mov	dx,emerg_sect+2
	call	read_linear
	
	jmpi	0,#BOOT_SEG
#endif

// Includes
/////////////
#include "int13.S"

// Data
/////////
#ifndef SUPPORT_EMERGENCY
text_error:	.ascii	"Disk read failure."
		.byte	13,10,0
#else
text_emerg:	.ascii	"Trying emergency..."
		.byte	13,10,0
#endif

.org PARTTABLE_OFF-2
