#!/bin/sh
set -e

configindir="."
if [ "x$1" = "x--chdir" ] ; then
	shift
	configindir="$1"
	shift
fi

aclocal
autoheader
automake -a -c
autoconf

curdir="$(pwd)"
mkdir -p -- "$configindir"
cd "$configindir" || exit 1
"$curdir"/configure --enable-maintainer-mode CFLAGS="-Wall -O2 -g -Wmissing-prototypes -Wstrict-prototypes" CPPFLAGS="-I/usr/lib/glib-2.0/include -I/usr/include/glib-2.0 -I/usr/include/pango-1.0 -I/usr/include/cairo -I/usr/include/atk-1.0 -I/usr/lib/gtk-2.0/include -I/usr/include/gtk-2.0" "$@"
