# -*- coding: utf-8 -*-

# Copyright (c) 2006 Stas Zykiewicz <stas.zytkiewicz@gmail.com>
#
#           CPMenu.py
# This program is free software; you can redistribute it and/or
# modify it under the terms of version 2 of the GNU General Public License
# as published by the Free Software Foundation.  A copy of this license should
# be included in the file GPL-2.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


CPMDEBUG = 0
import os,sys
from SpriteUtils import CPSprite, CPinit
from utils import load_image,trace_error
from pygame.constants import MOUSEBUTTONDOWN
from CPConstants import *
from version import version

class MenuItem(CPSprite):
    """ Container, becomes a object for each game (icon, position, modulename)"""
    def __init__(self,img,pos,data):
        CPSprite.__init__(self)
        self.image = img
        self.rect  = self.image.get_rect()
        self.rect.move_ip(pos)
        self.data = data
        self.connect_callback(self.callback, event_type=MOUSEBUTTONDOWN)
        if CPMDEBUG: print >> sys.stderr,"menu item object",self,self.image,self.rect,self.data
    
    def callback(self,*args):
        if CPMDEBUG: print >> sys.stderr, "callback reached",self,"returns",self.data
        return self.data
        
class CPMenu:
    """ Menu class, mimics a game module so it can be used just like any other plugin.
      From the controllers point of view it's just an other plugin.
      This class has everything needed to run the menu"""
    def __init__(self,screen,back,menudic,basedir):
        self.basedir = basedir
        self.screen  =screen
        self.backgr = back
        self.menudic = menudic
        # here we init the new SpriteUtils stuff, this must be done before using
        # these classes.
        self.actives = CPinit(self.screen,self.backgr)
        self.menuitems = []
        self.menurects = []
        self._setup()

    def _setup(self):
       ## create menu objects ###
        for key in self.menudic.keys():
            pos = key
            name = self.menudic[key][0]
            img = load_image(os.path.join(DATADIR,'icons',self.menudic[key][1]),self.menudic[key][2])
            
            obj = MenuItem(img,pos,name)
            if CPMDEBUG: print >> sys.stderr, "menu object image",img,pos,name
            self.actives.add(obj)
                        
    def start(self):
        """Blit the menu objects on the main screen"""
        try:
            self.actives.refresh()
        except Exception,info:
            trace_error()
            print self.__class__,info
    
    def __str__(self):
        return 'CPMenu'
        
    def helptitle(self):
        """ Used when the user hits the ? in the menu screen"""
        return "Childsplay %s" % version
    
    def help(self):
        text = [_("A suite of educational games for young children."),
_("It's using a plug-in system for the games, so childsplay is basically a"),
_("framework where you put in as many games as you like."), 
_("Childsplay comes with a few standard games, so you might want to check"),
_("the website (see below) for additional games."),
" ",
_("All the games have there own help page, just start a game and hit the"),
_("questionmark again"),
" ",
_("Childsplay and all the games are licensed with the GNU-GPL."),
_("All the sounds and pictures as well as the fonts used by childsplay and the games"),
_("are free in the public domain or used with permission of the owner."),
_("If you think that something is used without permission or you have a "),
_("'See-you-in-court' copyright on it, please let me know and i will remove it"),
" ",
_("For updates and info: http://childsplay.sourceforge.net"),
_("For additional game-modules : http://childsplay.sourceforge.net/plugins.html"),
_("Comments, bugs, ideas and other things of interest, send email to:"),
_("childsplay@users.sourceforge.net"),
" ",
_("Credits:"),
"Configuration file parser by Charles Cazabon.",
"Additional developers: Matias, Chris",
"Support for RTL languages, Kobi",
"Windows installer by Chris"
" ",
"Thanks:",
"Beta-testers: Wladek & Marek",
"Overall sanitization: Yvonne",
"French translation by jp.ayanides@free.fr",
"Danish translation by Gunner, gp@lyngbjerggaardskolen.dk",
"German translation by Bernd, info@herdsoft.com",
"Spanish translation by Matias, matiasg@dm.uba.ar",
"Catalonian translation by Carles, carles.ferrando@gmail.com",
"Italian translation by MScotta, mscotta@sourceforge.net",
"Slovenian translation by Robert, r@aufbix.org",
"Hebrew translation by Lior, kaplanlior@gmail.com",
"Arabic translation by Youssef chahibi@gmail.com",
"Portugese translation by Fernando fnando.vieira@gmail.com"]
        
        return text
    
    def loop(self,events):
        """ The menu's own eventloop, called by the controller mainloop
          Returns the users choice as a dic key from the menudic."""
        choice = 0
        for event in events:
            if event.type is MOUSEBUTTONDOWN:
                v = self.actives.refresh(event)
                if CPMDEBUG: print >> sys.stderr,self.__class__,"return from refresh",v
                if v:
                    choice = v[0][1]
        return choice,0
