/* Generated from posix.scm by the CHICKEN compiler
   Version 1, Build 13 - linux-unix-gnu-x86
   command line: posix.scm -quiet -debug-level 0 -optimize-level 2 -unsafe -feature unsafe -include-path . -output-file uposix.c -explicit-use
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>
#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANONYMOUS
# define MAP_ANONYMOUS    0
#endif

extern char **environ;

static char *C_exec_args[ ARG_MAX ];
static struct utsname C_utsname;
static struct flock C_flock;
static DIR *temphandle;
static struct passwd *C_user;
static int C_pipefds[ 2 ];
static time_t C_secs;
static struct tm C_tm;
static fd_set C_fd_sets[ 2 ];
static struct timeval C_timeval;
static char C_hostbuf[ 256 ];
static struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)		C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)   	(closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)		C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)	(strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name),	C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_uname             C_fix(uname(&C_utsname))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_fileno(p)         C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_alarm             alarm
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_getenventry(i)    environ[ i ]
#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y);
C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);				       
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_exec_arg(int i, char *a, int len);
void C_fcall C_set_exec_arg(int i, char *a, int len) {
  char *ptr = (char *)C_malloc(len + 1);
  C_memcpy(ptr, a, len);
  ptr[ len ] = '\0';
  C_exec_args[ i ] = ptr;
}

static void C_fcall C_free_exec_args();
void C_fcall C_free_exec_args() {
  char **a = C_exec_args;
  while((*a) != NULL) C_free(*(a++));
}

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__)
static int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigprocmask(d)    C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open((char *)C_data_pointer(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)    FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd) FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd) FD_ISSET(fd, &C_fd_sets[ i ])
#define C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_select_t(m, t)    (C_timeval.tv_sec = C_unfix(t), C_timeval.tv_usec = 0, C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if !defined(C_GNU_ENV)
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), asctime(&C_tm) )
#else
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), asctime(&C_tm) )
#endif

C_externimport void C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_externimport void C_script_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_word lf[324];


/* from select */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub587(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub587(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_return:
return C_r;
#undef return
}

/* from sleep in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static C_word C_fcall stub556(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub556(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_r=C_fix((C_word)sleep(t0));
return C_r;}

/* from parent-process-id in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static C_word C_fcall stub553(C_word C_buf) C_regparm;
static C_word C_fcall stub553(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static C_word C_fcall stub551(C_word C_buf) C_regparm;
static C_word C_fcall stub551(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeargs */
static C_word C_fcall stub515(C_word C_buf) C_regparm;
static C_word C_fcall stub515(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k1177 */
static C_word C_fcall stub508(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
static C_word C_fcall stub508(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
void * t1=C_data_pointer_or_null(C_a1);
int t2=C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from f3315 in k3309 in k3291 in process-fork in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static C_word C_fcall stub497(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub497(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub492(C_word C_buf) C_regparm;
static C_word C_fcall stub492(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub452(C_word C_buf) C_regparm;
static C_word C_fcall stub452(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);
            else return(C_hostbuf);
C_return:
return C_r;
#undef return
}

/* from ttyname */
static C_word C_fcall stub445(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub445(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from set-alarm! in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static C_word C_fcall stub431(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub431(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from ex0 */
static C_word C_fcall stub425(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub425(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from asctime */
static C_word C_fcall stub414(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub414(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from ctime */
static C_word C_fcall stub405(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub405(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k1048 */
static C_word C_fcall stub390(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub390(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=C_c_pointer_or_null(C_a0);
int t1=C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k1184 */
static C_word C_fcall stub364(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
static C_word C_fcall stub364(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=C_c_pointer_or_null(C_a0);
int t1=C_num_to_int(C_a1);
int t2=C_unfix(C_a2);
int t3=C_unfix(C_a3);
int t4=C_unfix(C_a4);
int t5=C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from get */
static C_word C_fcall stub342(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub342(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from current-effective-group-id in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static C_word C_fcall stub234(C_word C_buf) C_regparm;
static C_word C_fcall stub234(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from current-effective-user-id in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static C_word C_fcall stub232(C_word C_buf) C_regparm;
static C_word C_fcall stub232(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from current-group-id in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static C_word C_fcall stub230(C_word C_buf) C_regparm;
static C_word C_fcall stub230(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from current-user-id in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static C_word C_fcall stub228(C_word C_buf) C_regparm;
static C_word C_fcall stub228(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from fd_test */
static C_word C_fcall stub49(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub49(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
int t1=C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from fd_set */
static C_word C_fcall stub43(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
static C_word C_fcall stub43(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
int t1=C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from fd_zero */
static C_word C_fcall stub38(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub38(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from make-nonblocking in k1404 in k1401 in k1398 in k1395 in k1392 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub1(C_word C_buf,C_word C_a0) C_regparm;
static C_word C_fcall stub1(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_return:
return C_r;
#undef return
}

C_externexport void C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
static void f1394(C_word c,C_word t0,C_word t1) C_noret;
static void f1397(C_word c,C_word t0,C_word t1) C_noret;
static void f1400(C_word c,C_word t0,C_word t1) C_noret;
static void f1403(C_word c,C_word t0,C_word t1) C_noret;
static void f1406(C_word c,C_word t0,C_word t1) C_noret;
static void f2283(C_word c,C_word t0,C_word t1) C_noret;
static void f3871(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2335(C_word c,C_word t0,C_word t1) C_noret;
static void f2547(C_word c,C_word t0,C_word t1) C_noret;
static void f3807(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f3807r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1159(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f3557(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3569(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f3581(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f3771(C_word c,C_word t0,C_word t1) C_noret;
static void f3775(C_word c,C_word t0,C_word t1) C_noret;
static void f3778(C_word c,C_word t0,C_word t1) C_noret;
static void f3802(C_word c,C_word t0,C_word t1) C_noret;
static void f3781(C_word c,C_word t0,C_word t1) C_noret;
static void f3793(C_word c,C_word t0,C_word t1) C_noret;
static void f3784(C_word c,C_word t0,C_word t1) C_noret;
static void f3585(C_word c,C_word t0,C_word t1) C_noret;
static void f3588(C_word c,C_word t0,C_word t1) C_noret;
static void f3591(C_word c,C_word t0,C_word t1) C_noret;
static void f3604(C_word c,C_word t0,C_word t1) C_noret;
static void f3758(C_word c,C_word t0,C_word t1) C_noret;
static void f3762(C_word c,C_word t0,C_word t1) C_noret;
static void f3742(C_word c,C_word t0,C_word t1) C_noret;
static void f3723(C_word c,C_word t0,C_word t1) C_noret;
static void f3727(C_word c,C_word t0,C_word t1) C_noret;
static void f3651(C_word c,C_word t0,C_word t1) C_noret;
static void f3710(C_word c,C_word t0,C_word t1) C_noret;
static void f3714(C_word c,C_word t0,C_word t1) C_noret;
static void f3657(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3665(C_word c,C_word t0,C_word t1) C_noret;
static void f3700(C_word c,C_word t0,C_word t1) C_noret;
static void f3687(C_word c,C_word t0,C_word t1) C_noret;
static void f3681(C_word c,C_word t0,C_word t1) C_noret;
static void f3655(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f3606(C_word t0,C_word t1) C_c_regparm C_noret;
static void f3619(C_word c,C_word t0,C_word t1) C_noret;
static void f3644(C_word c,C_word t0,C_word t1) C_noret;
static void f3635(C_word c,C_word t0,C_word t1) C_noret;
static void f3638(C_word c,C_word t0,C_word t1) C_noret;
static void f3616(C_word c,C_word t0,C_word t1) C_noret;
static void f3575(C_word c,C_word t0,C_word t1) C_noret;
static void f3563(C_word c,C_word t0,C_word t1) C_noret;
static void f3513(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3513r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3520(C_word c,C_word t0,C_word t1) C_noret;
static void f3535(C_word c,C_word t0,C_word t1) C_noret;
static void f3489(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3489r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3496(C_word c,C_word t0,C_word t1) C_noret;
static void f3486(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3483(C_word c,C_word t0,C_word t1) C_noret;
static void f3480(C_word c,C_word t0,C_word t1) C_noret;
static void f3404(C_word c,C_word t0,C_word t1,...) C_noret;
static void f3404r(C_word t0,C_word t1,C_word t3) C_noret;
static void f3432(C_word c,C_word t0,C_word t1) C_noret;
static void f3327(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f3327r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f3334(C_word c,C_word t0,C_word t1) C_noret;
static void f3341(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f3355(C_word c,C_word t0,C_word t1) C_noret;
static void f3358(C_word c,C_word t0,C_word t1) C_noret;
static void f3286(C_word c,C_word t0,C_word t1,...) C_noret;
static void f3286r(C_word t0,C_word t1,C_word t3) C_noret;
static void f3293(C_word c,C_word t0,C_word t1) C_noret;
static void f3311(C_word c,C_word t0,C_word t1) C_noret;
static void f3315(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3182(C_word c,C_word t0,C_word t1,...) C_noret;
static void f3182r(C_word t0,C_word t1,C_word t3) C_noret;
static void f3187(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3208(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f3279(C_word c,C_word t0,C_word t1) C_noret;
static void f3212(C_word c,C_word t0,C_word t1) C_noret;
static void f3219(C_word c,C_word t0,C_word t1) C_noret;
static void f3220(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3237(C_word c,C_word t0,C_word t1) C_noret;
static void f3247(C_word c,C_word t0,C_word t1) C_noret;
static void f3251(C_word c,C_word t0,C_word t1) C_noret;
static void f3202(C_word c,C_word t0,C_word t1) C_noret;
static void f3167(C_word c,C_word t0,C_word t1) C_noret;
static void f3171(C_word c,C_word t0,C_word t1) C_noret;
static void f3177(C_word c,C_word t0,C_word t1) C_noret;
static void f3174(C_word c,C_word t0,C_word t1) C_noret;
static void f3141(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3161(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f3151(C_word t0,C_word t1) C_c_regparm C_noret;
static void f3145(C_word c,C_word t0,C_word t1) C_noret;
static void f3125(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3129(C_word c,C_word t0,C_word t1) C_noret;
static void f3068(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f3068r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f3075(C_word c,C_word t0,C_word t1) C_noret;
static void f3095(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f3088(C_word t0,C_word t1) C_c_regparm C_noret;
static void f3065(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3046(C_word c,C_word t0,C_word t1,...) C_noret;
static void f3046r(C_word t0,C_word t1,C_word t3) C_noret;
static void f3050(C_word c,C_word t0,C_word t1) C_noret;
static void f3018(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3025(C_word c,C_word t0,C_word t1) C_noret;
static void f3028(C_word c,C_word t0,C_word t1) C_noret;
static void f3031(C_word c,C_word t0,C_word t1) C_noret;
static void f3006(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f3010(C_word c,C_word t0,C_word t1) C_noret;
static void f3013(C_word c,C_word t0,C_word t1) C_noret;
static void f3000(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2994(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2988(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2953(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2953r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2966(C_word c,C_word t0,C_word t1) C_noret;
static void f2901(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
static void f2901r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
static void f2905(C_word c,C_word t0,C_word t1) C_noret;
static void f2911(C_word c,C_word t0,C_word t1) C_noret;
static void f2933(C_word c,C_word t0,C_word t1) C_noret;
static void f2926(C_word c,C_word t0,C_word t1) C_noret;
static void f2917(C_word c,C_word t0,C_word t1) C_noret;
static void f2827(C_word c,C_word t0,C_word t1) C_noret;
static void f2832(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2836(C_word c,C_word t0,C_word t1) C_noret;
static void f2843(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2869(C_word c,C_word t0,C_word t1) C_noret;
static void f2873(C_word c,C_word t0,C_word t1) C_noret;
static void f2861(C_word c,C_word t0,C_word t1) C_noret;
static void f2820(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2825(C_word c,C_word t0,C_word t1) C_noret;
static void f2809(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2814(C_word c,C_word t0,C_word t1) C_noret;
static void f2818(C_word c,C_word t0,C_word t1) C_noret;
static void f2787(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2791(C_word c,C_word t0,C_word t1) C_noret;
static void f2794(C_word c,C_word t0,C_word t1) C_noret;
static void f2751(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2751r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f2755(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2772(C_word c,C_word t0,C_word t1) C_noret;
static void f2764(C_word c,C_word t0,C_word t1) C_noret;
static void f2723(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2741(C_word c,C_word t0,C_word t1) C_noret;
static void f2701(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2701r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2705(C_word c,C_word t0,C_word t1) C_noret;
static void f2686(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2686r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2690(C_word c,C_word t0,C_word t1) C_noret;
static void f2651(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2675(C_word c,C_word t0,C_word t1) C_noret;
static void f2668(C_word c,C_word t0,C_word t1) C_noret;
static void f2661(C_word c,C_word t0,C_word t1) C_noret;
static void f2627(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2627r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void C_fcall f2631(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2640(C_word c,C_word t0,C_word t1) C_noret;
static void f2634(C_word c,C_word t0,C_word t1) C_noret;
static void f2595(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2625(C_word c,C_word t0,C_word t1) C_noret;
static void f2611(C_word c,C_word t0,C_word t1) C_noret;
static void f2605(C_word c,C_word t0,C_word t1) C_noret;
static void f2584(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2584r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2593(C_word c,C_word t0,C_word t1) C_noret;
static void f2573(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2573r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2582(C_word c,C_word t0,C_word t1) C_noret;
static void f2548(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2553(C_word c,C_word t0,C_word t1) C_noret;
static void f2565(C_word c,C_word t0,C_word t1) C_noret;
static void f2556(C_word c,C_word t0,C_word t1) C_noret;
static void f2521(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2539(C_word c,C_word t0,C_word t1) C_noret;
static void f2543(C_word c,C_word t0,C_word t1) C_noret;
static void f2531(C_word c,C_word t0,C_word t1) C_noret;
static void f2515(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2509(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2503(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2488(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2498(C_word c,C_word t0,C_word t1) C_noret;
static void f2485(C_word c,C_word t0,C_word t1) C_noret;
static void f2482(C_word c,C_word t0,C_word t1) C_noret;
static void f2479(C_word c,C_word t0,C_word t1) C_noret;
static void f2476(C_word c,C_word t0,C_word t1) C_noret;
static void f2456(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f2474(C_word c,C_word t0,C_word t1) C_noret;
static void f2466(C_word c,C_word t0,C_word t1) C_noret;
static void f2436(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2454(C_word c,C_word t0,C_word t1) C_noret;
static void f2446(C_word c,C_word t0,C_word t1) C_noret;
static void f2375(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2412(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f2379(C_word t0,C_word t1) C_c_regparm C_noret;
static void f2389(C_word c,C_word t0,C_word t1) C_noret;
static void f2393(C_word c,C_word t0,C_word t1) C_noret;
static void f2397(C_word c,C_word t0,C_word t1) C_noret;
static void f2401(C_word c,C_word t0,C_word t1) C_noret;
static void f2405(C_word c,C_word t0,C_word t1) C_noret;
static void f2337(C_word c,C_word t0,C_word t1) C_noret;
static void f2370(C_word c,C_word t0,C_word t1) C_noret;
static void f2341(C_word c,C_word t0,C_word t1) C_noret;
static void f2348(C_word c,C_word t0,C_word t1) C_noret;
static void f2352(C_word c,C_word t0,C_word t1) C_noret;
static void f2356(C_word c,C_word t0,C_word t1) C_noret;
static void f2360(C_word c,C_word t0,C_word t1) C_noret;
static void f2364(C_word c,C_word t0,C_word t1) C_noret;
static void f2313(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2331(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2317(C_word c,C_word t0,C_word t1) C_noret;
static void f2326(C_word c,C_word t0,C_word t1) C_noret;
static void f2295(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2305(C_word c,C_word t0,C_word t1) C_noret;
static void f2285(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f2239(C_word c,C_word t0,C_word t1) C_noret;
static void f2252(C_word c,C_word t0,C_word t1) C_noret;
static void f2243(C_word c,C_word t0,C_word t1) C_noret;
static void f2219(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f2219r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f2223(C_word c,C_word t0,C_word t1) C_noret;
static void f2229(C_word c,C_word t0,C_word t1,...) C_noret;
static void f2229r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2233(C_word c,C_word t0,C_word t1) C_noret;
static void f2199(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f2199r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f2203(C_word c,C_word t0,C_word t1) C_noret;
static void f2209(C_word c,C_word t0,C_word t1,...) C_noret;
static void f2209r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2213(C_word c,C_word t0,C_word t1) C_noret;
static void f2175(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f2175r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f2179(C_word c,C_word t0,C_word t1) C_noret;
static void f2190(C_word c,C_word t0,C_word t1,...) C_noret;
static void f2190r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2194(C_word c,C_word t0,C_word t1) C_noret;
static void f2184(C_word c,C_word t0,C_word t1) C_noret;
static void f2151(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f2151r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f2155(C_word c,C_word t0,C_word t1) C_noret;
static void f2166(C_word c,C_word t0,C_word t1,...) C_noret;
static void f2166r(C_word t0,C_word t1,C_word t3) C_noret;
static void f2170(C_word c,C_word t0,C_word t1) C_noret;
static void f2160(C_word c,C_word t0,C_word t1) C_noret;
static void f2135(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2139(C_word c,C_word t0,C_word t1) C_noret;
static void f2102(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2102r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2130(C_word c,C_word t0,C_word t1) C_noret;
static void f2120(C_word c,C_word t0,C_word t1) C_noret;
static void f2113(C_word c,C_word t0,C_word t1) C_noret;
static void f2069(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
static void f2069r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
static void f2097(C_word c,C_word t0,C_word t1) C_noret;
static void f2087(C_word c,C_word t0,C_word t1) C_noret;
static void f2080(C_word c,C_word t0,C_word t1) C_noret;
static void f2051(C_word c,C_word t0,C_word t1) C_noret;
static void f2055(C_word c,C_word t0,C_word t1) C_noret;
static void f2058(C_word c,C_word t0,C_word t1) C_noret;
static void f2035(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f2039(C_word c,C_word t0,C_word t1) C_noret;
static void f1985(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1989(C_word c,C_word t0,C_word t1) C_noret;
static void f1992(C_word c,C_word t0,C_word t1) C_noret;
static void f1995(C_word c,C_word t0,C_word t1) C_noret;
static void f1999(C_word c,C_word t0,C_word t1) C_noret;
static void f2015(C_word c,C_word t0,C_word t1) C_noret;
static void f2025(C_word c,C_word t0,C_word t1) C_noret;
static void f2032(C_word c,C_word t0,C_word t1) C_noret;
static void f2008(C_word c,C_word t0,C_word t1) C_noret;
static void f1965(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1983(C_word c,C_word t0,C_word t1) C_noret;
static void f1975(C_word c,C_word t0,C_word t1) C_noret;
static void f1945(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1963(C_word c,C_word t0,C_word t1) C_noret;
static void f1955(C_word c,C_word t0,C_word t1) C_noret;
static void f1925(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1943(C_word c,C_word t0,C_word t1) C_noret;
static void f1935(C_word c,C_word t0,C_word t1) C_noret;
static void f1866(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1866r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1873(C_word c,C_word t0,C_word t1) C_noret;
static void f1888(C_word c,C_word t0,C_word t1) C_noret;
static void f1898(C_word c,C_word t0,C_word t1) C_noret;
static void f1879(C_word c,C_word t0,C_word t1) C_noret;
static void f1882(C_word c,C_word t0,C_word t1) C_noret;
static void f1822(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1841(C_word c,C_word t0,C_word t1) C_noret;
static void f1851(C_word c,C_word t0,C_word t1) C_noret;
static void f1826(C_word c,C_word t0,C_word t1) C_noret;
static void f1835(C_word c,C_word t0,C_word t1) C_noret;
static void f1829(C_word c,C_word t0,C_word t1) C_noret;
static void f1816(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1820(C_word c,C_word t0,C_word t1) C_noret;
static void f1810(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1814(C_word c,C_word t0,C_word t1) C_noret;
static void f1804(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1808(C_word c,C_word t0,C_word t1) C_noret;
static void f1798(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1802(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1764(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1793(C_word c,C_word t0,C_word t1) C_noret;
static void f1768(C_word c,C_word t0,C_word t1) C_noret;
static void f1777(C_word c,C_word t0,C_word t1) C_noret;
static void f1584(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1584r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1748(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1600(C_word c,C_word t0,C_word t1) C_noret;
static void f1728(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1606(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1609(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1694(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1692(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1651(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1669(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1667(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1655(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1618(C_word c,C_word t0,C_word t1) C_noret;
static void f1548(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1548r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1552(C_word c,C_word t0,C_word t1) C_noret;
static void f1564(C_word c,C_word t0,C_word t1) C_noret;
static void f1558(C_word c,C_word t0,C_word t1) C_noret;
static void f1509(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1509r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1513(C_word c,C_word t0,C_word t1) C_noret;
static void f1516(C_word c,C_word t0,C_word t1) C_noret;
static void f1528(C_word c,C_word t0,C_word t1) C_noret;
static void f1519(C_word c,C_word t0,C_word t1) C_noret;
static void f1494(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1504(C_word c,C_word t0,C_word t1) C_noret;
static void f1466(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
static void f1466r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
static void f1474(C_word c,C_word t0,C_word t1) C_noret;
static void f1483(C_word c,C_word t0,C_word t1) C_noret;
static void f1477(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1411(C_word t0) C_c_regparm C_noret;
static void f1417(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void f1426(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f1408(C_word t0) C_c_regparm;
static void C_fcall f1355(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f1363(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f1346(C_word t0,C_word t1) C_c_regparm C_noret;
static C_word C_fcall f1334(C_word t0) C_c_regparm;
static void C_fcall f1197(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9) C_c_regparm C_noret;
static void f1320(C_word c,C_word t0,C_word t1,...) C_noret;
static void f1328(C_word c,C_word t0,C_word t1,...) C_noret;
static void C_fcall f1201(C_word t0,C_word t1) C_c_regparm C_noret;
static void f1308(C_word c,C_word t0,C_word t1) C_noret;
static void f1211(C_word c,C_word t0,C_word t1) C_noret;
static void f1212(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
static void f1231(C_word c,C_word t0,C_word t1) C_noret;
static void f1293(C_word c,C_word t0,C_word t1) C_noret;
static void f1300(C_word c,C_word t0,C_word t1) C_noret;
static void f1287(C_word c,C_word t0,C_word t1) C_noret;
static void f1246(C_word c,C_word t0,C_word t1) C_noret;
static void f1277(C_word c,C_word t0,C_word t1) C_noret;
static void f1263(C_word c,C_word t0,C_word t1) C_noret;
static void f1275(C_word c,C_word t0,C_word t1) C_noret;
static void f1271(C_word c,C_word t0,C_word t1) C_noret;
static void f1258(C_word c,C_word t0,C_word t1) C_noret;
static void f1256(C_word c,C_word t0,C_word t1) C_noret;
static void f1312(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
static void C_fcall f1191(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_c_regparm C_noret;
static C_word C_fcall f1174(C_word t0,C_word t1,C_word t2) C_c_regparm;
static C_word C_fcall f1165(C_word t0,C_word t1) C_c_regparm;
static void C_fcall f1088(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void C_fcall f1110(C_word t0,C_word t1) C_c_regparm C_noret;
static void C_fcall f1067(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f1079(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
static void f1073(C_word c,C_word t0,C_word t1) C_noret;
static C_word C_fcall f1058(C_word t0,C_word t1) C_c_regparm;
static C_word C_fcall f1055(C_word t0) C_c_regparm;
static void C_fcall f1036(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_c_regparm C_noret;
static void C_fcall f1015(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f1019(C_word c,C_word t0,C_word t1) C_noret;
static void f1031(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f998(C_word t0,C_word t1,C_word t2) C_c_regparm C_noret;
static void f1013(C_word c,C_word t0,C_word t1) C_noret;
static void f1005(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f974(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f978(C_word c,C_word t0,C_word t1) C_noret;
static void f990(C_word c,C_word t0,C_word t1) C_noret;
static void C_fcall f950(C_word t0,C_word t1,C_word t2,C_word t3) C_c_regparm C_noret;
static void f954(C_word c,C_word t0,C_word t1) C_noret;

static void C_fcall trf3606(void *dummy) C_regparm C_noret;
static void C_fcall trf3606(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f3606(t0,t1);}

static void C_fcall trf3151(void *dummy) C_regparm C_noret;
static void C_fcall trf3151(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f3151(t0,t1);}

static void C_fcall trf3088(void *dummy) C_regparm C_noret;
static void C_fcall trf3088(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f3088(t0,t1);}

static void C_fcall trf2755(void *dummy) C_regparm C_noret;
static void C_fcall trf2755(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2755(t0,t1);}

static void C_fcall trf2631(void *dummy) C_regparm C_noret;
static void C_fcall trf2631(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2631(t0,t1);}

static void C_fcall trf2379(void *dummy) C_regparm C_noret;
static void C_fcall trf2379(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f2379(t0,t1);}

static void C_fcall trf1764(void *dummy) C_regparm C_noret;
static void C_fcall trf1764(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1764(t0,t1);}

static void C_fcall trf1609(void *dummy) C_regparm C_noret;
static void C_fcall trf1609(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1609(t0,t1);}

static void C_fcall trf1651(void *dummy) C_regparm C_noret;
static void C_fcall trf1651(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1651(t0,t1);}

static void C_fcall trf1655(void *dummy) C_regparm C_noret;
static void C_fcall trf1655(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1655(t0,t1);}

static void C_fcall trf1411(void *dummy) C_regparm C_noret;
static void C_fcall trf1411(void *dummy){
C_word t0=C_pick(0);
C_adjust_stack(-1);
f1411(t0);}

static void C_fcall trf1355(void *dummy) C_regparm C_noret;
static void C_fcall trf1355(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f1355(t0,t1,t2);}

static void C_fcall trf1346(void *dummy) C_regparm C_noret;
static void C_fcall trf1346(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1346(t0,t1);}

static void C_fcall trf1197(void *dummy) C_regparm C_noret;
static void C_fcall trf1197(void *dummy){
C_word t9=C_pick(0);
C_word t8=C_pick(1);
C_word t7=C_pick(2);
C_word t6=C_pick(3);
C_word t5=C_pick(4);
C_word t4=C_pick(5);
C_word t3=C_pick(6);
C_word t2=C_pick(7);
C_word t1=C_pick(8);
C_word t0=C_pick(9);
C_adjust_stack(-10);
f1197(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}

static void C_fcall trf1201(void *dummy) C_regparm C_noret;
static void C_fcall trf1201(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1201(t0,t1);}

static void C_fcall trf1191(void *dummy) C_regparm C_noret;
static void C_fcall trf1191(void *dummy){
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
f1191(t0,t1,t2,t3,t4,t5,t6,t7,t8);}

static void C_fcall trf1088(void *dummy) C_regparm C_noret;
static void C_fcall trf1088(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f1088(t0,t1,t2);}

static void C_fcall trf1110(void *dummy) C_regparm C_noret;
static void C_fcall trf1110(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f1110(t0,t1);}

static void C_fcall trf1067(void *dummy) C_regparm C_noret;
static void C_fcall trf1067(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f1067(t0,t1,t2);}

static void C_fcall trf1036(void *dummy) C_regparm C_noret;
static void C_fcall trf1036(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f1036(t0,t1,t2,t3,t4,t5,t6,t7);}

static void C_fcall trf1015(void *dummy) C_regparm C_noret;
static void C_fcall trf1015(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f1015(t0,t1,t2,t3);}

static void C_fcall trf998(void *dummy) C_regparm C_noret;
static void C_fcall trf998(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f998(t0,t1,t2);}

static void C_fcall trf974(void *dummy) C_regparm C_noret;
static void C_fcall trf974(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f974(t0,t1,t2,t3);}

static void C_fcall trf950(void *dummy) C_regparm C_noret;
static void C_fcall trf950(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f950(t0,t1,t2,t3);}

static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static int toplevel_initialized=0;
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(35);
if(!C_demand(35)){
C_save(t1);
C_reclaim(toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3916)){
C_save(t1);
C_rereclaim(-3916*sizeof(C_word));
t1=C_restore;}
a=C_alloc(35);
C_initialize_lf(lf,324);
lf[1]=C_h_intern(&lf[1],9,"\003syserror");
lf[2]=C_h_intern(&lf[2],16,"\003sysupdate-errno");
lf[4]=C_h_intern(&lf[4],15,"\003syssignal-hook");
lf[5]=C_h_intern(&lf[5],11,"\000file-error");
lf[6]=C_string(C_heaptop,17,"can not open pipe");
lf[7]=C_h_intern(&lf[7],13,"\003sysmake-port");
lf[8]=C_h_intern(&lf[8],21,"\003sysstream-port-class");
lf[9]=C_string(C_heaptop,6,"(pipe)");
lf[10]=C_h_intern(&lf[10],6,"stream");
lf[12]=C_h_intern(&lf[12],17,"\003sysmake-c-string");
lf[14]=C_string(C_heaptop,17,"can not open file");
lf[15]=C_string(C_heaptop,8,"(fdport)");
lf[21]=C_h_intern(&lf[21],16,"\003syssignal-error");
lf[22]=C_h_intern(&lf[22],7,"process");
lf[23]=C_string(C_heaptop,25,"process exited abnormally");
lf[25]=C_h_intern(&lf[25],4,"lock");
lf[30]=C_string(C_heaptop,1,".");
lf[31]=C_string(C_heaptop,2,"..");
lf[32]=C_string(C_heaptop,1,"*");
lf[33]=C_h_intern(&lf[33],16,"\003sysdynamic-wind");
lf[34]=C_h_intern(&lf[34],13,"pathname-file");
lf[35]=C_string(C_heaptop,1,"*");
lf[37]=C_h_intern(&lf[37],5,"\000text");
lf[39]=C_string(C_heaptop,35,"illegal input/output mode specifier");
lf[41]=C_h_intern(&lf[41],7,"\000append");
lf[42]=C_string(C_heaptop,27,"invalid mode for input file");
lf[43]=C_string(C_heaptop,1,"a");
lf[44]=C_string(C_heaptop,21,"invalid mode argument");
lf[45]=C_string(C_heaptop,1,"r");
lf[46]=C_string(C_heaptop,1,"w");
lf[47]=C_string(C_heaptop,27,"too many optional arguments");
lf[50]=C_h_intern(&lf[50],18,"\003syscurrent-thread");
lf[51]=C_h_intern(&lf[51],12,"\003sysschedule");
lf[52]=C_h_intern(&lf[52],8,"pipe/buf");
lf[53]=C_h_intern(&lf[53],11,"open/rdonly");
lf[54]=C_h_intern(&lf[54],11,"open/wronly");
lf[55]=C_h_intern(&lf[55],9,"open/rdwr");
lf[56]=C_h_intern(&lf[56],9,"open/read");
lf[57]=C_h_intern(&lf[57],10,"open/write");
lf[58]=C_h_intern(&lf[58],10,"open/creat");
lf[59]=C_h_intern(&lf[59],11,"open/append");
lf[60]=C_h_intern(&lf[60],9,"open/excl");
lf[61]=C_h_intern(&lf[61],11,"open/noctty");
lf[62]=C_h_intern(&lf[62],13,"open/nonblock");
lf[63]=C_h_intern(&lf[63],10,"open/trunc");
lf[64]=C_h_intern(&lf[64],9,"open/sync");
lf[65]=C_h_intern(&lf[65],10,"open/fsync");
lf[66]=C_h_intern(&lf[66],11,"open/binary");
lf[67]=C_h_intern(&lf[67],9,"open/text");
lf[68]=C_h_intern(&lf[68],10,"perm/irusr");
lf[69]=C_h_intern(&lf[69],10,"perm/iwusr");
lf[70]=C_h_intern(&lf[70],10,"perm/ixusr");
lf[71]=C_h_intern(&lf[71],10,"perm/irgrp");
lf[72]=C_h_intern(&lf[72],10,"perm/iwgrp");
lf[73]=C_h_intern(&lf[73],10,"perm/ixgrp");
lf[74]=C_h_intern(&lf[74],10,"perm/iroth");
lf[75]=C_h_intern(&lf[75],10,"perm/iwoth");
lf[76]=C_h_intern(&lf[76],10,"perm/ixoth");
lf[77]=C_h_intern(&lf[77],10,"perm/irwxu");
lf[78]=C_h_intern(&lf[78],10,"perm/irwxg");
lf[79]=C_h_intern(&lf[79],10,"perm/irwxo");
lf[80]=C_h_intern(&lf[80],10,"perm/isvtx");
lf[81]=C_h_intern(&lf[81],10,"perm/isuid");
lf[82]=C_h_intern(&lf[82],10,"perm/isgid");
lf[83]=C_h_intern(&lf[83],9,"file-open");
lf[84]=C_string(C_heaptop,17,"can not open file");
lf[85]=C_h_intern(&lf[85],10,"file-close");
lf[86]=C_string(C_heaptop,18,"can not close file");
lf[87]=C_h_intern(&lf[87],11,"make-string");
lf[88]=C_h_intern(&lf[88],9,"file-read");
lf[89]=C_string(C_heaptop,22,"can not read from file");
lf[90]=C_h_intern(&lf[90],11,"\000type-error");
lf[91]=C_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[92]=C_h_intern(&lf[92],10,"file-write");
lf[93]=C_string(C_heaptop,21,"can not write to file");
lf[94]=C_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[95]=C_h_intern(&lf[95],11,"file-select");
lf[96]=C_string(C_heaptop,6,"failed");
lf[97]=C_h_intern(&lf[97],12,"\003sysfor-each");
lf[98]=C_h_intern(&lf[98],8,"seek/set");
lf[99]=C_h_intern(&lf[99],8,"seek/end");
lf[100]=C_h_intern(&lf[100],8,"seek/cur");
lf[102]=C_string(C_heaptop,19,"can not access file");
lf[103]=C_string(C_heaptop,42,"bad argument type - not a fixnum or string");
lf[104]=C_h_intern(&lf[104],9,"file-size");
lf[105]=C_h_intern(&lf[105],22,"file-modification-time");
lf[106]=C_h_intern(&lf[106],10,"file-owner");
lf[107]=C_h_intern(&lf[107],16,"file-permissions");
lf[108]=C_h_intern(&lf[108],13,"file-position");
lf[109]=C_string(C_heaptop,38,"can not retrieve file position of port");
lf[110]=C_h_intern(&lf[110],21,"\003sysport-file-resolve");
lf[111]=C_string(C_heaptop,12,"invalid file");
lf[112]=C_h_intern(&lf[112],5,"port?");
lf[113]=C_h_intern(&lf[113],18,"set-file-position!");
lf[114]=C_string(C_heaptop,25,"can not set file position");
lf[115]=C_string(C_heaptop,12,"invalid file");
lf[116]=C_string(C_heaptop,30,"invalid negative port position");
lf[117]=C_h_intern(&lf[117],16,"create-directory");
lf[118]=C_string(C_heaptop,24,"can not create directory");
lf[119]=C_h_intern(&lf[119],16,"change-directory");
lf[120]=C_string(C_heaptop,32,"can not change current directory");
lf[121]=C_h_intern(&lf[121],16,"delete-directory");
lf[122]=C_string(C_heaptop,24,"can not delete directory");
lf[123]=C_h_intern(&lf[123],13,"string-append");
lf[124]=C_h_intern(&lf[124],6,"string");
lf[125]=C_h_intern(&lf[125],9,"substring");
lf[126]=C_h_intern(&lf[126],9,"directory");
lf[127]=C_string(C_heaptop,22,"can not open directory");
lf[128]=C_h_intern(&lf[128],16,"\003sysmake-pointer");
lf[129]=C_h_intern(&lf[129],10,"directory?");
lf[130]=C_h_intern(&lf[130],13,"\003sysfile-info");
lf[131]=C_h_intern(&lf[131],17,"current-directory");
lf[132]=C_string(C_heaptop,34,"can not retrieve current directory");
lf[133]=C_h_intern(&lf[133],15,"open-input-pipe");
lf[134]=C_h_intern(&lf[134],7,"\000binary");
lf[135]=C_h_intern(&lf[135],16,"open-output-pipe");
lf[136]=C_h_intern(&lf[136],16,"close-input-pipe");
lf[137]=C_string(C_heaptop,24,"error while closing pipe");
lf[138]=C_h_intern(&lf[138],17,"close-output-pipe");
lf[139]=C_h_intern(&lf[139],20,"call-with-input-pipe");
lf[140]=C_h_intern(&lf[140],6,"values");
lf[141]=C_h_intern(&lf[141],21,"call-with-output-pipe");
lf[142]=C_h_intern(&lf[142],20,"with-input-from-pipe");
lf[143]=C_h_intern(&lf[143],18,"\003sysstandard-input");
lf[144]=C_h_intern(&lf[144],19,"with-output-to-pipe");
lf[145]=C_h_intern(&lf[145],19,"\003sysstandard-output");
lf[146]=C_h_intern(&lf[146],11,"create-pipe");
lf[147]=C_string(C_heaptop,19,"can not create pipe");
lf[148]=C_h_intern(&lf[148],11,"signal/term");
lf[149]=C_h_intern(&lf[149],11,"signal/kill");
lf[150]=C_h_intern(&lf[150],10,"signal/int");
lf[151]=C_h_intern(&lf[151],10,"signal/hup");
lf[152]=C_h_intern(&lf[152],10,"signal/fpe");
lf[153]=C_h_intern(&lf[153],10,"signal/ill");
lf[154]=C_h_intern(&lf[154],11,"signal/segv");
lf[155]=C_h_intern(&lf[155],11,"signal/abrt");
lf[156]=C_h_intern(&lf[156],11,"signal/trap");
lf[157]=C_h_intern(&lf[157],11,"signal/quit");
lf[158]=C_h_intern(&lf[158],11,"signal/alrm");
lf[159]=C_h_intern(&lf[159],13,"signal/vtalrm");
lf[160]=C_h_intern(&lf[160],11,"signal/prof");
lf[161]=C_h_intern(&lf[161],9,"signal/io");
lf[162]=C_h_intern(&lf[162],10,"signal/urg");
lf[163]=C_h_intern(&lf[163],11,"signal/chld");
lf[164]=C_h_intern(&lf[164],11,"signal/cont");
lf[165]=C_h_intern(&lf[165],11,"signal/stop");
lf[166]=C_h_intern(&lf[166],11,"signal/tstp");
lf[167]=C_h_intern(&lf[167],11,"signal/pipe");
lf[168]=C_h_intern(&lf[168],11,"signal/xcpu");
lf[169]=C_h_intern(&lf[169],11,"signal/xfsz");
lf[170]=C_h_intern(&lf[170],11,"signal/usr1");
lf[171]=C_h_intern(&lf[171],11,"signal/usr2");
lf[172]=C_h_intern(&lf[172],12,"signal/winch");
lf[173]=C_h_intern(&lf[173],18,"\003sysinterrupt-hook");
lf[174]=C_h_intern(&lf[174],19,"set-signal-handler!");
lf[175]=C_h_intern(&lf[175],18,"\003syscontext-switch");
lf[176]=C_h_intern(&lf[176],16,"set-signal-mask!");
lf[177]=C_string(C_heaptop,23,"can not set signal mask");
lf[178]=C_h_intern(&lf[178],18,"system-information");
lf[179]=C_h_intern(&lf[179],25,"\003syspeek-nonnull-c-string");
lf[180]=C_string(C_heaptop,35,"can not retrieve system information");
lf[181]=C_h_intern(&lf[181],16,"user-information");
lf[182]=C_h_intern(&lf[182],17,"\003syspeek-c-string");
lf[183]=C_h_intern(&lf[183],10,"errno/perm");
lf[184]=C_h_intern(&lf[184],11,"errno/noent");
lf[185]=C_h_intern(&lf[185],10,"errno/srch");
lf[186]=C_h_intern(&lf[186],10,"errno/intr");
lf[187]=C_h_intern(&lf[187],8,"errno/io");
lf[188]=C_h_intern(&lf[188],12,"errno/noexec");
lf[189]=C_h_intern(&lf[189],10,"errno/badf");
lf[190]=C_h_intern(&lf[190],11,"errno/child");
lf[191]=C_h_intern(&lf[191],11,"errno/nomem");
lf[192]=C_h_intern(&lf[192],11,"errno/acces");
lf[193]=C_h_intern(&lf[193],11,"errno/fault");
lf[194]=C_h_intern(&lf[194],10,"errno/busy");
lf[195]=C_h_intern(&lf[195],12,"errno/notdir");
lf[196]=C_h_intern(&lf[196],11,"errno/isdir");
lf[197]=C_h_intern(&lf[197],11,"errno/inval");
lf[198]=C_h_intern(&lf[198],11,"errno/mfile");
lf[199]=C_h_intern(&lf[199],11,"errno/nospc");
lf[200]=C_h_intern(&lf[200],11,"errno/spipe");
lf[201]=C_h_intern(&lf[201],10,"errno/pipe");
lf[202]=C_h_intern(&lf[202],11,"errno/again");
lf[203]=C_h_intern(&lf[203],10,"errno/rofs");
lf[204]=C_h_intern(&lf[204],16,"errno/wouldblock");
lf[205]=C_h_intern(&lf[205],16,"change-file-mode");
lf[206]=C_string(C_heaptop,24,"can not change file mode");
lf[207]=C_h_intern(&lf[207],17,"change-file-owner");
lf[208]=C_string(C_heaptop,25,"can not change file owner");
lf[209]=C_h_intern(&lf[209],15,"current-user-id");
lf[210]=C_h_intern(&lf[210],16,"current-group-id");
lf[211]=C_h_intern(&lf[211],25,"current-effective-user-id");
lf[212]=C_h_intern(&lf[212],26,"current-effective-group-id");
lf[213]=C_h_intern(&lf[213],12,"set-user-id!");
lf[214]=C_string(C_heaptop,19,"can not set user id");
lf[215]=C_h_intern(&lf[215],17,"file-read-access?");
lf[216]=C_h_intern(&lf[216],18,"file-write-access?");
lf[217]=C_h_intern(&lf[217],20,"file-execute-access?");
lf[218]=C_h_intern(&lf[218],20,"create-symbolic-link");
lf[219]=C_h_intern(&lf[219],18,"create-symbol-link");
lf[220]=C_string(C_heaptop,28,"can not create symbolic link");
lf[221]=C_h_intern(&lf[221],18,"read-symbolic-link");
lf[222]=C_string(C_heaptop,26,"can not read symbolic link");
lf[223]=C_h_intern(&lf[223],12,"fileno/stdin");
lf[224]=C_h_intern(&lf[224],13,"fileno/stdout");
lf[225]=C_h_intern(&lf[225],13,"fileno/stderr");
lf[226]=C_h_intern(&lf[226],16,"open-input-file*");
lf[227]=C_h_intern(&lf[227],17,"open-output-file*");
lf[228]=C_h_intern(&lf[228],12,"port->fileno");
lf[229]=C_string(C_heaptop,25,"port has no attached file");
lf[230]=C_string(C_heaptop,38,"can not access file-descriptor of port");
lf[231]=C_h_intern(&lf[231],25,"\003syspeek-unsigned-integer");
lf[232]=C_h_intern(&lf[232],16,"duplicate-fileno");
lf[233]=C_string(C_heaptop,33,"can not duplicate file descriptor");
lf[234]=C_h_intern(&lf[234],13,"file-truncate");
lf[235]=C_string(C_heaptop,21,"can not truncate file");
lf[236]=C_string(C_heaptop,12,"invalid file");
lf[237]=C_h_intern(&lf[237],9,"file-lock");
lf[238]=C_string(C_heaptop,17,"can not lock file");
lf[239]=C_h_intern(&lf[239],14,"file-test-lock");
lf[240]=C_string(C_heaptop,19,"can not unlock file");
lf[241]=C_h_intern(&lf[241],11,"file-unlock");
lf[242]=C_string(C_heaptop,19,"can not unlock file");
lf[243]=C_h_intern(&lf[243],11,"create-fifo");
lf[244]=C_string(C_heaptop,19,"can not create FIFO");
lf[245]=C_h_intern(&lf[245],5,"fifo?");
lf[246]=C_string(C_heaptop,19,"file does not exist");
lf[247]=C_h_intern(&lf[247],6,"setenv");
lf[248]=C_h_intern(&lf[248],8,"unsetenv");
lf[249]=C_h_intern(&lf[249],19,"current-environment");
lf[250]=C_h_intern(&lf[250],9,"prot/read");
lf[251]=C_h_intern(&lf[251],10,"prot/write");
lf[252]=C_h_intern(&lf[252],9,"prot/exec");
lf[253]=C_h_intern(&lf[253],9,"prot/none");
lf[254]=C_h_intern(&lf[254],9,"map/fixed");
lf[255]=C_h_intern(&lf[255],10,"map/shared");
lf[256]=C_h_intern(&lf[256],11,"map/private");
lf[257]=C_h_intern(&lf[257],13,"map/anonymous");
lf[258]=C_h_intern(&lf[258],8,"map/file");
lf[259]=C_h_intern(&lf[259],18,"map-file-to-memory");
lf[260]=C_h_intern(&lf[260],4,"mmap");
lf[261]=C_string(C_heaptop,26,"can not map file to memory");
lf[262]=C_h_intern(&lf[262],20,"\003syspointer->address");
lf[263]=C_string(C_heaptop,41,"bad argument type - not a foreign pointer");
lf[264]=C_h_intern(&lf[264],16,"\003sysnull-pointer");
lf[265]=C_h_intern(&lf[265],22,"unmap-file-from-memory");
lf[266]=C_string(C_heaptop,30,"can not unmap file from memory");
lf[267]=C_h_intern(&lf[267],26,"memory-mapped-file-pointer");
lf[268]=C_h_intern(&lf[268],19,"seconds->local-time");
lf[269]=C_h_intern(&lf[269],18,"\003sysdecode-seconds");
lf[270]=C_h_intern(&lf[270],17,"seconds->utc-time");
lf[271]=C_h_intern(&lf[271],15,"seconds->string");
lf[272]=C_string(C_heaptop,33,"can not convert seconds to string");
lf[273]=C_h_intern(&lf[273],12,"time->string");
lf[274]=C_string(C_heaptop,29,"can not time vector to string");
lf[275]=C_string(C_heaptop,21,"time vector too short");
lf[276]=C_h_intern(&lf[276],5,"_exit");
lf[277]=C_h_intern(&lf[277],23,"\003syscleanup-before-exit");
lf[278]=C_h_intern(&lf[278],10,"set-alarm!");
lf[279]=C_h_intern(&lf[279],19,"set-buffering-mode!");
lf[280]=C_string(C_heaptop,26,"can not set buffering mode");
lf[281]=C_h_intern(&lf[281],5,"\000full");
lf[282]=C_h_intern(&lf[282],5,"\000line");
lf[283]=C_h_intern(&lf[283],5,"\000none");
lf[284]=C_string(C_heaptop,22,"invalid buffering-mode");
lf[285]=C_h_intern(&lf[285],14,"terminal-port?");
lf[286]=C_h_intern(&lf[286],13,"terminal-name");
lf[287]=C_string(C_heaptop,35,"port is not connected to a terminal");
lf[288]=C_h_intern(&lf[288],13,"get-host-name");
lf[289]=C_string(C_heaptop,26,"can not retrieve host-name");
lf[290]=C_h_intern(&lf[290],15,"pattern->regexp");
lf[291]=C_h_intern(&lf[291],13,"make-pathname");
lf[292]=C_h_intern(&lf[292],18,"decompose-pathname");
lf[293]=C_h_intern(&lf[293],4,"glob");
lf[294]=C_h_intern(&lf[294],12,"string-match");
lf[295]=C_string(C_heaptop,1,".");
lf[296]=C_string(C_heaptop,1,"*");
lf[297]=C_h_intern(&lf[297],12,"process-fork");
lf[298]=C_string(C_heaptop,28,"can not create child process");
lf[299]=C_h_intern(&lf[299],24,"pathname-strip-directory");
lf[300]=C_h_intern(&lf[300],15,"process-execute");
lf[301]=C_string(C_heaptop,23,"can not execute process");
lf[302]=C_h_intern(&lf[302],12,"process-wait");
lf[303]=C_string(C_heaptop,32,"waiting for child process failed");
lf[304]=C_h_intern(&lf[304],18,"current-process-id");
lf[305]=C_h_intern(&lf[305],17,"parent-process-id");
lf[306]=C_h_intern(&lf[306],5,"sleep");
lf[307]=C_h_intern(&lf[307],14,"process-signal");
lf[308]=C_string(C_heaptop,32,"could not send signal to process");
lf[309]=C_h_intern(&lf[309],6,"getenv");
lf[310]=C_h_intern(&lf[310],11,"process-run");
lf[311]=C_string(C_heaptop,7,"/bin/sh");
lf[312]=C_string(C_heaptop,2,"-c");
lf[313]=C_string(C_heaptop,5,"SHELL");
lf[314]=C_h_intern(&lf[314],15,"make-input-port");
lf[315]=C_h_intern(&lf[315],16,"make-output-port");
lf[316]=C_h_intern(&lf[316],25,"\003systhread-block-for-i/o!");
lf[317]=C_string(C_heaptop,22,"can not read from pipe");
lf[318]=C_string(C_heaptop,21,"can not write to pipe");
lf[319]=C_h_intern(&lf[319],10,"find-files");
lf[320]=C_h_intern(&lf[320],23,"\003sysuser-interrupt-hook");
lf[321]=C_h_intern(&lf[321],11,"make-vector");
lf[322]=C_h_intern(&lf[322],17,"register-feature!");
lf[323]=C_h_intern(&lf[323],5,"posix");
C_register_lf(lf,324);
t2=C_mutate(&lf[0],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f950,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate(&lf[3],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f974,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate(&lf[11],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f998,tmp=(C_word)a,a+=2,tmp));
t5=C_mutate(&lf[13],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1015,tmp=(C_word)a,a+=2,tmp));
t6=C_mutate(&lf[16],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1036,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate(&lf[18],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1055,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate(&lf[19],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1058,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate(&lf[20],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1067,tmp=(C_word)a,a+=2,tmp));
t10=C_mutate(&lf[24],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1088,tmp=(C_word)a,a+=2,tmp));
t11=C_mutate(&lf[27],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1165,tmp=(C_word)a,a+=2,tmp));
t12=C_mutate(&lf[28],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1174,tmp=(C_word)a,a+=2,tmp));
t13=C_mutate(&lf[17],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1191,tmp=(C_word)a,a+=2,tmp));
t14=C_mutate(&lf[29],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1197,tmp=(C_word)a,a+=2,tmp));
t15=C_mutate(&lf[36],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1334,tmp=(C_word)a,a+=2,tmp));
t16=C_mutate(&lf[38],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1346,tmp=(C_word)a,a+=2,tmp));
t17=C_mutate(&lf[40],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1355,tmp=(C_word)a,a+=2,tmp));
t18=C_mutate(&lf[26],lf[47]);
t19=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1394,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t19);}

/* k1392 */
static void f1394(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1394,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1397,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1395 in k1392 */
static void f1397(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1397,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1400,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1398 in k1395 in k1392 */
static void f1400(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1400,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1403,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_script_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1401 in k1398 in k1395 in k1392 */
static void f1403(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1403,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1406,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[322]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[323]);}

/* k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1406(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word ab[74],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1406,2,t0,t1);}
t2=C_mutate(&lf[48],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1408,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate(&lf[49],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1411,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[52]+1,C_fix((C_word)PIPE_BUF));
t5=C_mutate((C_word*)lf[53]+1,C_fix((C_word)O_RDONLY));
t6=C_mutate((C_word*)lf[54]+1,C_fix((C_word)O_WRONLY));
t7=C_mutate((C_word*)lf[55]+1,C_fix((C_word)O_RDWR));
t8=C_mutate((C_word*)lf[56]+1,C_fix((C_word)O_RDWR));
t9=C_mutate((C_word*)lf[57]+1,C_fix((C_word)O_WRONLY));
t10=C_mutate((C_word*)lf[58]+1,C_fix((C_word)O_CREAT));
t11=C_mutate((C_word*)lf[59]+1,C_fix((C_word)O_APPEND));
t12=C_mutate((C_word*)lf[60]+1,C_fix((C_word)O_EXCL));
t13=C_mutate((C_word*)lf[61]+1,C_fix((C_word)O_NOCTTY));
t14=C_mutate((C_word*)lf[62]+1,C_fix((C_word)O_NONBLOCK));
t15=C_mutate((C_word*)lf[63]+1,C_fix((C_word)O_TRUNC));
t16=C_mutate((C_word*)lf[64]+1,C_fix((C_word)O_FSYNC));
t17=C_mutate((C_word*)lf[65]+1,C_fix((C_word)O_FSYNC));
t18=C_mutate((C_word*)lf[66]+1,C_fix((C_word)O_BINARY));
t19=C_mutate((C_word*)lf[67]+1,C_fix((C_word)O_TEXT));
t20=C_mutate((C_word*)lf[68]+1,C_fix((C_word)S_IRUSR));
t21=C_mutate((C_word*)lf[69]+1,C_fix((C_word)S_IWUSR));
t22=C_mutate((C_word*)lf[70]+1,C_fix((C_word)S_IXUSR));
t23=C_mutate((C_word*)lf[71]+1,C_fix((C_word)S_IRGRP));
t24=C_mutate((C_word*)lf[72]+1,C_fix((C_word)S_IWGRP));
t25=C_mutate((C_word*)lf[73]+1,C_fix((C_word)S_IXGRP));
t26=C_mutate((C_word*)lf[74]+1,C_fix((C_word)S_IROTH));
t27=C_mutate((C_word*)lf[75]+1,C_fix((C_word)S_IWOTH));
t28=C_mutate((C_word*)lf[76]+1,C_fix((C_word)S_IXOTH));
t29=C_mutate((C_word*)lf[77]+1,C_fix((C_word)S_IRWXU));
t30=C_mutate((C_word*)lf[78]+1,C_fix((C_word)S_IRWXG));
t31=C_mutate((C_word*)lf[79]+1,C_fix((C_word)S_IRWXO));
t32=C_mutate((C_word*)lf[80]+1,C_fix((C_word)S_ISVTX));
t33=C_mutate((C_word*)lf[81]+1,C_fix((C_word)S_ISUID));
t34=C_mutate((C_word*)lf[82]+1,C_fix((C_word)S_ISGID));
t35=(C_word)C_u_fixnum_or(C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t36=(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXU),t35);
t37=C_mutate((C_word*)lf[83]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1466,a[2]=t36,tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[85]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1494,tmp=(C_word)a,a+=2,tmp));
t39=*((C_word*)lf[87]+1);
t40=C_mutate((C_word*)lf[88]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1509,a[2]=t39,tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[92]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1548,tmp=(C_word)a,a+=2,tmp));
t42=C_mutate((C_word*)lf[95]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1584,tmp=(C_word)a,a+=2,tmp));
t43=C_mutate((C_word*)lf[98]+1,C_fix((C_word)SEEK_SET));
t44=C_mutate((C_word*)lf[99]+1,C_fix((C_word)SEEK_END));
t45=C_mutate((C_word*)lf[100]+1,C_fix((C_word)SEEK_CUR));
t46=C_mutate(&lf[101],(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1764,tmp=(C_word)a,a+=2,tmp));
t47=C_mutate((C_word*)lf[104]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1798,tmp=(C_word)a,a+=2,tmp));
t48=C_mutate((C_word*)lf[105]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1804,tmp=(C_word)a,a+=2,tmp));
t49=C_mutate((C_word*)lf[106]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1810,tmp=(C_word)a,a+=2,tmp));
t50=C_mutate((C_word*)lf[107]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1816,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[108]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1822,tmp=(C_word)a,a+=2,tmp));
t52=C_mutate((C_word*)lf[113]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1866,tmp=(C_word)a,a+=2,tmp));
t53=C_mutate((C_word*)lf[117]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1925,tmp=(C_word)a,a+=2,tmp));
t54=C_mutate((C_word*)lf[119]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1945,tmp=(C_word)a,a+=2,tmp));
t55=C_mutate((C_word*)lf[121]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1965,tmp=(C_word)a,a+=2,tmp));
t56=*((C_word*)lf[123]+1);
t57=*((C_word*)lf[87]+1);
t58=*((C_word*)lf[124]+1);
t59=*((C_word*)lf[125]+1);
t60=C_mutate((C_word*)lf[126]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1985,a[2]=t57,a[3]=t59,tmp=(C_word)a,a+=4,tmp));
t61=C_mutate((C_word*)lf[129]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2035,tmp=(C_word)a,a+=2,tmp));
t62=*((C_word*)lf[87]+1);
t63=*((C_word*)lf[125]+1);
t64=C_mutate((C_word*)lf[131]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2051,a[2]=t62,a[3]=t63,tmp=(C_word)a,a+=4,tmp));
t65=C_mutate((C_word*)lf[133]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2069,tmp=(C_word)a,a+=2,tmp));
t66=C_mutate((C_word*)lf[135]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2102,tmp=(C_word)a,a+=2,tmp));
t67=C_mutate((C_word*)lf[136]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2135,tmp=(C_word)a,a+=2,tmp));
t68=C_mutate((C_word*)lf[138]+1,*((C_word*)lf[136]+1));
t69=*((C_word*)lf[133]+1);
t70=*((C_word*)lf[135]+1);
t71=*((C_word*)lf[136]+1);
t72=*((C_word*)lf[138]+1);
t73=C_mutate((C_word*)lf[139]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2151,a[2]=t69,a[3]=t71,tmp=(C_word)a,a+=4,tmp));
t74=C_mutate((C_word*)lf[141]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2175,a[2]=t70,a[3]=t72,tmp=(C_word)a,a+=4,tmp));
t75=C_mutate((C_word*)lf[142]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2199,a[2]=t69,a[3]=t71,tmp=(C_word)a,a+=4,tmp));
t76=C_mutate((C_word*)lf[144]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2219,a[2]=t70,a[3]=t72,tmp=(C_word)a,a+=4,tmp));
t77=C_mutate((C_word*)lf[146]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2239,tmp=(C_word)a,a+=2,tmp));
t78=C_mutate((C_word*)lf[148]+1,C_fix((C_word)SIGTERM));
t79=C_mutate((C_word*)lf[149]+1,C_fix((C_word)SIGKILL));
t80=C_mutate((C_word*)lf[150]+1,C_fix((C_word)SIGINT));
t81=C_mutate((C_word*)lf[151]+1,C_fix((C_word)SIGHUP));
t82=C_mutate((C_word*)lf[152]+1,C_fix((C_word)SIGFPE));
t83=C_mutate((C_word*)lf[153]+1,C_fix((C_word)SIGILL));
t84=C_mutate((C_word*)lf[154]+1,C_fix((C_word)SIGSEGV));
t85=C_mutate((C_word*)lf[155]+1,C_fix((C_word)SIGABRT));
t86=C_mutate((C_word*)lf[156]+1,C_fix((C_word)SIGTRAP));
t87=C_mutate((C_word*)lf[157]+1,C_fix((C_word)SIGQUIT));
t88=C_mutate((C_word*)lf[158]+1,C_fix((C_word)SIGALRM));
t89=C_mutate((C_word*)lf[159]+1,C_fix((C_word)SIGVTALRM));
t90=C_mutate((C_word*)lf[160]+1,C_fix((C_word)SIGPROF));
t91=C_mutate((C_word*)lf[161]+1,C_fix((C_word)SIGIO));
t92=C_mutate((C_word*)lf[162]+1,C_fix((C_word)SIGURG));
t93=C_mutate((C_word*)lf[163]+1,C_fix((C_word)SIGCHLD));
t94=C_mutate((C_word*)lf[164]+1,C_fix((C_word)SIGCONT));
t95=C_mutate((C_word*)lf[165]+1,C_fix((C_word)SIGSTOP));
t96=C_mutate((C_word*)lf[166]+1,C_fix((C_word)SIGTSTP));
t97=C_mutate((C_word*)lf[167]+1,C_fix((C_word)SIGPIPE));
t98=C_mutate((C_word*)lf[168]+1,C_fix((C_word)SIGXCPU));
t99=C_mutate((C_word*)lf[169]+1,C_fix((C_word)SIGXFSZ));
t100=C_mutate((C_word*)lf[170]+1,C_fix((C_word)SIGUSR1));
t101=C_mutate((C_word*)lf[171]+1,C_fix((C_word)SIGUSR2));
t102=C_mutate((C_word*)lf[172]+1,C_fix((C_word)SIGWINCH));
t103=*((C_word*)lf[173]+1);
t104=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2283,a[2]=((C_word*)t0)[2],a[3]=t103,tmp=(C_word)a,a+=4,tmp);
t105=*((C_word*)lf[321]+1);
((C_proc4)(void*)(*((C_word*)t105+1)))(4,t105,t104,C_fix(256),C_SCHEME_FALSE);}

/* k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2283(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2283,2,t0,t1);}
t2=C_mutate((C_word*)lf[174]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2285,a[2]=t1,tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[173]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2295,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[176]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2313,tmp=(C_word)a,a+=2,tmp));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2335,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3871,tmp=(C_word)a,a+=2,tmp);
t7=*((C_word*)lf[174]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,*((C_word*)lf[150]+1),t6);}

/* a3870 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3871(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3871,3,t0,t1,t2);}
t3=*((C_word*)lf[320]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2335(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2335,2,t0,t1);}
t2=C_mutate((C_word*)lf[178]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2337,tmp=(C_word)a,a+=2,tmp));
t3=C_mutate((C_word*)lf[181]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2375,tmp=(C_word)a,a+=2,tmp));
t4=C_mutate((C_word*)lf[183]+1,C_fix((C_word)EPERM));
t5=C_mutate((C_word*)lf[184]+1,C_fix((C_word)ENOENT));
t6=C_mutate((C_word*)lf[185]+1,C_fix((C_word)ESRCH));
t7=C_mutate((C_word*)lf[186]+1,C_fix((C_word)EINTR));
t8=C_mutate((C_word*)lf[187]+1,C_fix((C_word)EIO));
t9=C_mutate((C_word*)lf[188]+1,C_fix((C_word)ENOEXEC));
t10=C_mutate((C_word*)lf[189]+1,C_fix((C_word)EBADF));
t11=C_mutate((C_word*)lf[190]+1,C_fix((C_word)ECHILD));
t12=C_mutate((C_word*)lf[191]+1,C_fix((C_word)ENOMEM));
t13=C_mutate((C_word*)lf[192]+1,C_fix((C_word)EACCES));
t14=C_mutate((C_word*)lf[193]+1,C_fix((C_word)EFAULT));
t15=C_mutate((C_word*)lf[194]+1,C_fix((C_word)EBUSY));
t16=C_mutate((C_word*)lf[195]+1,C_fix((C_word)ENOTDIR));
t17=C_mutate((C_word*)lf[196]+1,C_fix((C_word)EISDIR));
t18=C_mutate((C_word*)lf[197]+1,C_fix((C_word)EINVAL));
t19=C_mutate((C_word*)lf[198]+1,C_fix((C_word)EMFILE));
t20=C_mutate((C_word*)lf[199]+1,C_fix((C_word)ENOSPC));
t21=C_mutate((C_word*)lf[200]+1,C_fix((C_word)ESPIPE));
t22=C_mutate((C_word*)lf[201]+1,C_fix((C_word)EPIPE));
t23=C_mutate((C_word*)lf[202]+1,C_fix((C_word)EAGAIN));
t24=C_mutate((C_word*)lf[203]+1,C_fix((C_word)EROFS));
t25=C_mutate((C_word*)lf[204]+1,C_fix((C_word)EWOULDBLOCK));
t26=C_mutate((C_word*)lf[205]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2436,tmp=(C_word)a,a+=2,tmp));
t27=C_mutate((C_word*)lf[207]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2456,tmp=(C_word)a,a+=2,tmp));
t28=C_mutate((C_word*)lf[209]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2476,tmp=(C_word)a,a+=2,tmp));
t29=C_mutate((C_word*)lf[210]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2479,tmp=(C_word)a,a+=2,tmp));
t30=C_mutate((C_word*)lf[211]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2482,tmp=(C_word)a,a+=2,tmp));
t31=C_mutate((C_word*)lf[212]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2485,tmp=(C_word)a,a+=2,tmp));
t32=C_mutate((C_word*)lf[213]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2488,tmp=(C_word)a,a+=2,tmp));
t33=C_mutate((C_word*)lf[215]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2503,tmp=(C_word)a,a+=2,tmp));
t34=C_mutate((C_word*)lf[216]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2509,tmp=(C_word)a,a+=2,tmp));
t35=C_mutate((C_word*)lf[217]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2515,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[218]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2521,tmp=(C_word)a,a+=2,tmp));
t37=*((C_word*)lf[125]+1);
t38=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2547,a[2]=((C_word*)t0)[2],a[3]=t37,tmp=(C_word)a,a+=4,tmp);
t39=(C_word)C_u_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
t40=*((C_word*)lf[87]+1);
((C_proc3)(void*)(*((C_word*)t40+1)))(3,t40,t38,t39);}

/* k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2547(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word ab[100],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2547,2,t0,t1);}
t2=C_mutate((C_word*)lf[221]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2548,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[223]+1,C_fix((C_word)STDIN_FILENO));
t4=C_mutate((C_word*)lf[224]+1,C_fix((C_word)STDOUT_FILENO));
t5=C_mutate((C_word*)lf[225]+1,C_fix((C_word)STDERR_FILENO));
t6=C_mutate((C_word*)lf[226]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2573,tmp=(C_word)a,a+=2,tmp));
t7=C_mutate((C_word*)lf[227]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2584,tmp=(C_word)a,a+=2,tmp));
t8=C_mutate((C_word*)lf[228]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2595,tmp=(C_word)a,a+=2,tmp));
t9=C_mutate((C_word*)lf[232]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2627,tmp=(C_word)a,a+=2,tmp));
t10=C_mutate((C_word*)lf[234]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2651,tmp=(C_word)a,a+=2,tmp));
t11=C_mutate((C_word*)lf[237]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2686,tmp=(C_word)a,a+=2,tmp));
t12=C_mutate((C_word*)lf[239]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2701,tmp=(C_word)a,a+=2,tmp));
t13=C_mutate((C_word*)lf[241]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2723,tmp=(C_word)a,a+=2,tmp));
t14=C_mutate((C_word*)lf[243]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2751,tmp=(C_word)a,a+=2,tmp));
t15=C_mutate((C_word*)lf[245]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2787,tmp=(C_word)a,a+=2,tmp));
t16=C_mutate((C_word*)lf[247]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2809,tmp=(C_word)a,a+=2,tmp));
t17=C_mutate((C_word*)lf[248]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2820,tmp=(C_word)a,a+=2,tmp));
t18=*((C_word*)lf[125]+1);
t19=C_mutate((C_word*)lf[249]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2827,a[2]=t18,tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[250]+1,C_fix((C_word)PROT_READ));
t21=C_mutate((C_word*)lf[251]+1,C_fix((C_word)PROT_WRITE));
t22=C_mutate((C_word*)lf[252]+1,C_fix((C_word)PROT_EXEC));
t23=C_mutate((C_word*)lf[253]+1,C_fix((C_word)PROT_NONE));
t24=C_mutate((C_word*)lf[254]+1,C_fix((C_word)MAP_FIXED));
t25=C_mutate((C_word*)lf[255]+1,C_fix((C_word)MAP_SHARED));
t26=C_mutate((C_word*)lf[256]+1,C_fix((C_word)MAP_PRIVATE));
t27=C_mutate((C_word*)lf[257]+1,C_fix((C_word)MAP_ANONYMOUS));
t28=C_mutate((C_word*)lf[258]+1,C_fix((C_word)MAP_FILE));
t29=C_mutate((C_word*)lf[259]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2901,tmp=(C_word)a,a+=2,tmp));
t30=C_mutate((C_word*)lf[265]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2953,tmp=(C_word)a,a+=2,tmp));
t31=C_mutate((C_word*)lf[267]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2988,tmp=(C_word)a,a+=2,tmp));
t32=C_mutate((C_word*)lf[268]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2994,tmp=(C_word)a,a+=2,tmp));
t33=C_mutate((C_word*)lf[270]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3000,tmp=(C_word)a,a+=2,tmp));
t34=C_mutate((C_word*)lf[271]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3006,tmp=(C_word)a,a+=2,tmp));
t35=C_mutate((C_word*)lf[273]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3018,tmp=(C_word)a,a+=2,tmp));
t36=C_mutate((C_word*)lf[276]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3046,tmp=(C_word)a,a+=2,tmp));
t37=C_mutate((C_word*)lf[278]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3065,tmp=(C_word)a,a+=2,tmp));
t38=C_mutate((C_word*)lf[279]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3068,tmp=(C_word)a,a+=2,tmp));
t39=C_mutate((C_word*)lf[285]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3125,tmp=(C_word)a,a+=2,tmp));
t40=C_mutate((C_word*)lf[286]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3141,tmp=(C_word)a,a+=2,tmp));
t41=C_mutate((C_word*)lf[288]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3167,tmp=(C_word)a,a+=2,tmp));
t42=*((C_word*)lf[290]+1);
t43=*((C_word*)lf[126]+1);
t44=*((C_word*)lf[291]+1);
t45=*((C_word*)lf[292]+1);
t46=C_mutate((C_word*)lf[293]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3182,a[2]=t42,a[3]=t43,a[4]=t44,a[5]=t45,tmp=(C_word)a,a+=6,tmp));
t47=C_mutate((C_word*)lf[297]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3286,tmp=(C_word)a,a+=2,tmp));
t48=*((C_word*)lf[299]+1);
t49=C_mutate((C_word*)lf[300]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3327,a[2]=t48,tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[302]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3404,tmp=(C_word)a,a+=2,tmp));
t51=C_mutate((C_word*)lf[304]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3480,tmp=(C_word)a,a+=2,tmp));
t52=C_mutate((C_word*)lf[305]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3483,tmp=(C_word)a,a+=2,tmp));
t53=C_mutate((C_word*)lf[306]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3486,tmp=(C_word)a,a+=2,tmp));
t54=C_mutate((C_word*)lf[307]+1,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3489,tmp=(C_word)a,a+=2,tmp));
t55=*((C_word*)lf[297]+1);
t56=*((C_word*)lf[300]+1);
t57=*((C_word*)lf[309]+1);
t58=C_mutate((C_word*)lf[310]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3513,a[2]=t55,a[3]=t57,a[4]=t56,tmp=(C_word)a,a+=5,tmp));
t59=*((C_word*)lf[146]+1);
t60=*((C_word*)lf[297]+1);
t61=*((C_word*)lf[232]+1);
t62=*((C_word*)lf[85]+1);
t63=*((C_word*)lf[310]+1);
t64=*((C_word*)lf[87]+1);
t65=*((C_word*)lf[88]+1);
t66=*((C_word*)lf[314]+1);
t67=*((C_word*)lf[315]+1);
t68=*((C_word*)lf[92]+1);
t69=*((C_word*)lf[302]+1);
t70=C_mutate((C_word*)lf[22]+1,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f3557,a[2]=t60,a[3]=t61,a[4]=t63,a[5]=t64,a[6]=t66,a[7]=t67,a[8]=t62,a[9]=t69,a[10]=t59,tmp=(C_word)a,a+=11,tmp));
t71=*((C_word*)lf[293]+1);
t72=*((C_word*)lf[294]+1);
t73=*((C_word*)lf[291]+1);
t74=*((C_word*)lf[129]+1);
t75=C_mutate((C_word*)lf[319]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3807,a[2]=t72,a[3]=t74,a[4]=t71,a[5]=t73,tmp=(C_word)a,a+=6,tmp));
t76=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t76+1)))(2,t76,t75);}

/* find-files in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3807(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+2)){
C_save_and_reclaim(tr4r,f3807r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f3807r(t0,t1,t2,t3,t4);}}

static void f3807r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(2);
if(C_truep((C_word)C_i_nullp(t4))){
t5=t1;
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1159,tmp=(C_word)a,a+=2,tmp);
f1036(t5,t6,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t7,((C_word*)t0)[2],t8);}
else{
t5=(C_word)C_u_i_car(t4);
t6=(C_word)C_slot(t4,C_fix(1));
if(C_truep((C_word)C_i_nullp(t6))){
f1036(t1,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t3,((C_word*)t0)[2],t5);}
else{
t7=(C_word)C_u_i_car(t6);
t8=(C_word)C_slot(t6,C_fix(1));
if(C_truep((C_word)C_i_nullp(t8))){
f1191(t1,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t3,((C_word*)t0)[2],t5,t7);}
else{
t9=(C_word)C_u_i_car(t8);
t10=(C_word)C_slot(t8,C_fix(1));
if(C_truep((C_word)C_i_nullp(t10))){
f1197(t1,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t3,((C_word*)t0)[2],t5,t7,t9);}
else{
t11=*((C_word*)lf[1]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[26],t10);}}}}}

/* a1158 in find-files in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1159(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr4,f1159,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3557(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3557,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3563,a[2]=((C_word*)t0)[10],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f3569,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=t2,a[11]=((C_word*)t0)[10],tmp=(C_word)a,a+=12,tmp);
C_u_call_with_values(4,0,t1,t3,t4);}

/* a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3569(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr4,f3569,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3575,a[2]=((C_word*)t0)[11],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f3581,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word*)t0)[10],a[12]=t3,tmp=(C_word)a,a+=13,tmp);
C_u_call_with_values(4,0,t1,t4,t5);}

/* a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3581(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[23],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr4,f3581,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f3585,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t1,a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=t2,tmp=(C_word)a,a+=13,tmp);
t5=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f3771,a[2]=((C_word*)t0)[12],a[3]=t2,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[9],a[7]=t3,a[8]=((C_word*)t0)[11],a[9]=((C_word*)t0)[4],tmp=(C_word)a,a+=10,tmp);
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t4,t5);}

/* a3770 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3771(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3771,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f3775,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t1,a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
t3=((C_word*)t0)[6];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3773 in a3770 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3775(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3775,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f3778,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
t3=((C_word*)t0)[5];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3776 in k3773 in a3770 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3778,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3781,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[223]+1),((C_word*)t0)[2]);
if(C_truep(t3)){
t4=t2;
f3781(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3802,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[2],*((C_word*)lf[223]+1));}}

/* k3800 in k3776 in k3773 in a3770 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3802(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k3779 in k3776 in k3773 in a3770 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3781(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3781,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3784,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_eqp(*((C_word*)lf[224]+1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=t2;
f3784(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3793,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[4],*((C_word*)lf[224]+1));}}

/* k3791 in k3779 in k3776 in k3773 in a3770 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3793(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k3782 in k3779 in k3776 in k3773 in a3770 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3784(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3585(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3585,2,t0,t1);}
t2=C_SCHEME_FALSE;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f3588,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t3,a[9]=t5,a[10]=t1,a[11]=((C_word*)t0)[9],a[12]=((C_word*)t0)[10],a[13]=((C_word*)t0)[11],a[14]=((C_word*)t0)[12],tmp=(C_word)a,a+=15,tmp);
t7=((C_word*)t0)[7];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,((C_word*)t0)[2]);}

/* k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3588(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3588,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f3591,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=((C_word*)t0)[14],tmp=(C_word)a,a+=14,tmp);
t3=((C_word*)t0)[6];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3591(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3591,2,t0,t1);}
t2=f1408(((C_word*)t0)[13]);
t3=f1408(((C_word*)t0)[12]);
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f3604,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[12],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
t5=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,C_fix(256));}

/* k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3604(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[41],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3604,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3606,a[2]=((C_word*)t0)[11],a[3]=t1,a[4]=((C_word*)t0)[12],a[5]=t3,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t7=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f3651,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],tmp=(C_word)a,a+=11,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3723,a[2]=t6,a[3]=t1,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3742,a[2]=((C_word*)t0)[12],a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3758,a[2]=((C_word*)t0)[12],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t11=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}

/* a3757 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3758(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3758,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3762,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3760 in a3757 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3762(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
f1067(((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a3741 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3742(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3742,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t3=((C_word*)t0)[2];
t4=(C_word)stub587(C_SCHEME_UNDEFINED,t3);
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_eqp(C_fix(1),t4));}}

/* a3722 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3723(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3723,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3727,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t3=((C_word*)t0)[2];
f3606(t3,t2);}

/* k3725 in a3722 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3727(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_truep((C_word)C_i_greater_or_equalp(((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]))){
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fudge(C_fix(1)));}
else{
t2=((C_word*)((C_word*)t0)[5])[1];
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[5])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[5])+1,t3);
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_subchar(((C_word*)t0)[2],t2));}}

/* k3649 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3651(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[17],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3651,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3655,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3657,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3710,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,t3,t4);}

/* a3709 in k3649 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3710(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3710,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3714,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t3=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k3712 in a3709 in k3649 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3714(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_SCHEME_TRUE);
if(C_truep(((C_word*)((C_word*)t0)[5])[1])){
f1067(((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* a3656 in k3649 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3657(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3657,3,t0,t1,t2);}
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(C_word)C_block_size(((C_word*)t3)[1]);
t5=t4;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_SCHEME_FALSE;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3665,a[2]=((C_word*)t0)[2],a[3]=t8,a[4]=t6,a[5]=t3,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t10=C_set_block_item(t8,0,t9);
t11=((C_word*)t8)[1];
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,t1);}

/* loop641 in a3656 in k3649 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3665(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3665,2,t0,t1);}
t2=(C_word)C_write(((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1]);
t3=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3681,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
f1411(t5);}
else{
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3687,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t6=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,((C_word*)((C_word*)t0)[4])[1]))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3700,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=*((C_word*)lf[125]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)((C_word*)t0)[5])[1],t2,((C_word*)((C_word*)t0)[4])[1]);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}}

/* k3698 in loop641 in a3656 in k3649 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3700(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(C_word)C_block_size(((C_word*)((C_word*)t0)[5])[1]);
t4=C_mutate(((C_word *)((C_word*)t0)[4])+1,t3);
t5=((C_word*)((C_word*)t0)[3])[1];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[2]);}

/* k3685 in loop641 in a3656 in k3649 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3687(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[5],lf[318],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k3679 in loop641 in a3656 in k3649 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3681(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[3])[1];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k3653 in k3649 in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3655(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* fetch in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void C_fcall f3606(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf3606,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[6])[1],((C_word*)((C_word*)t0)[5])[1]))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3616,a[2]=t1,a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_FALSE;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3619,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t6=C_set_block_item(t4,0,t5);
t7=((C_word*)t4)[1];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t2);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop622 in fetch in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3619(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3619,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],C_fix(256));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3635,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t6=*((C_word*)lf[316]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,*((C_word*)lf[50]+1),((C_word*)t0)[5],C_SCHEME_TRUE);}
else{
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3644,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t6=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t2);}}

/* k3642 in loop622 in fetch in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3644(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[5],lf[22],lf[317],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k3633 in loop622 in fetch in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3635(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3635,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3638,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
f1411(t2);}

/* k3636 in k3633 in loop622 in fetch in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3638(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[3])[1];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k3614 in fetch in k3602 in k3589 in k3586 in k3583 in a3580 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3616(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a3574 in a3568 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3575(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3575,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* a3562 in process in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3563(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3563,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}

/* process-run in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3513(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim(tr3rv,f3513r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f3513r(t0,t1,t2,t3);}}

static void f3513r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3520,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t7=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k3518 in process-run in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3520(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3520,2,t0,t1);}
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[6])){
t3=((C_word*)t0)[5];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[6]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3535,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,lf[313]);}}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k3533 in k3518 in process-run in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3535(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3535,2,t0,t1);}
t2=(C_truep(t1)?t1:lf[311]);
t3=(C_word)C_a_i_list(&a,2,lf[312],((C_word*)t0)[4]);
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,((C_word*)t0)[2],t2,t3);}

/* process-signal in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3489(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim(tr3rv,f3489r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f3489r(t0,t1,t2,t3);}}

static void f3489r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_kill(t2,t5);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3496,a[2]=t5,a[3]=t2,a[4]=t1,a[5]=t6,tmp=(C_word)a,a+=6,tmp);
t8=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}

/* k3494 in process-signal in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3496(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[5],C_fix(-1));
if(C_truep(t2)){
t3=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[4],lf[307],lf[308],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* sleep in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3486(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3486,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub556(C_SCHEME_UNDEFINED,t2));}

/* parent-process-id in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3483(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3483,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub553(C_SCHEME_UNDEFINED));}

/* current-process-id in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3480(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3480,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub551(C_SCHEME_UNDEFINED));}

/* process-wait in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3404(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim(tr2r,f3404r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f3404r(t0,t1,t2);}}

static void f3404r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(6);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_u_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t2,C_fix(1)));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_u_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t6,C_fix(1)));
if(C_truep((C_word)C_i_nullp(t10))){
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_truep(t8)?C_fix((C_word)WNOHANG):C_fix(0));
t13=(C_word)C_waitpid(t11,t12);
t14=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t15=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3432,a[2]=t14,a[3]=t11,a[4]=t1,a[5]=t13,tmp=(C_word)a,a+=6,tmp);
t16=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t16+1)))(2,t16,t15);}
else{
t11=*((C_word*)lf[1]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[26],t10);}}

/* k3430 in process-wait in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3432(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[5],C_fix(-1));
if(C_truep(t2)){
t3=*((C_word*)lf[1]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[4],lf[302],lf[303],((C_word*)t0)[3]);}
else{
t3=(C_truep(((C_word*)t0)[2])?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
C_values(5,0,((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[2],t3);}}

/* process-execute in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3327(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim(tr3rv,f3327r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f3327r(t0,t1,t2,t3);}}

static void f3327r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):C_SCHEME_END_OF_LIST);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3334,a[2]=t5,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k3332 in process-execute in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3334(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3334,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f1174(C_fix(0),t1,t2);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3341,a[2]=t5,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t7=C_set_block_item(t5,0,t6);
t8=((C_word*)t5)[1];
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do521522 in k3332 in process-execute in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3341(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr4,f3341,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f1174(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3355,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t6=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,((C_word*)t0)[3]);}
else{
t4=(C_word)C_u_i_car(t2);
t5=(C_word)C_block_size(t4);
t6=f1174(t3,t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_u_fixnum_plus(t3,C_fix(1));
t9=((C_word*)((C_word*)t0)[2])[1];
((C_proc4)(void*)(*((C_word*)t9+1)))(4,t9,t1,t7,t8);}}

/* k3353 in do521522 in k3332 in process-execute in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3355(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3355,2,t0,t1);}
t2=(C_word)C_execvp(t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3358,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3356 in k3353 in do521522 in k3332 in process-execute in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3358(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_eqp(((C_word*)t0)[4],C_fix(-1));
if(C_truep(t2)){
t3=(C_word)stub515(C_SCHEME_UNDEFINED);
t4=*((C_word*)lf[1]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,((C_word*)t0)[3],lf[300],lf[301],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* process-fork in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3286(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim(tr2rv,f3286r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f3286r(t0,t1,t2);}}

static void f3286r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t3=(C_word)stub492(C_SCHEME_UNDEFINED);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3293,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}

/* k3291 in process-fork in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3293(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3293,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
t3=*((C_word*)lf[1]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,((C_word*)t0)[3],lf[297],lf[298]);}
else{
t3=(C_word)C_notvemptyp(((C_word*)t0)[2]);
t4=(C_truep(t3)?(C_word)C_eqp(((C_word*)t0)[4],C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3311,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
t6=(C_word)C_slot(((C_word*)t0)[2],C_fix(0));
t7=t6;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t5);}
else{
t5=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,((C_word*)t0)[4]);}}}

/* k3309 in k3291 in process-fork in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3311(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3311,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f3315,tmp=(C_word)a,a+=2,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f3315 in k3309 in k3291 in process-fork in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3315(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3315,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub497(C_SCHEME_UNDEFINED,t2));}

/* glob in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3182(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim(tr2r,f3182r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f3182r(t0,t1,t2);}}

static void f3182r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(9);
t3=C_SCHEME_FALSE;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3187,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t6=C_set_block_item(t4,0,t5);
t7=((C_word*)t4)[1];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t1,t2);}

/* conc463 in glob in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3187(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3187,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_u_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3202,a[2]=t3,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3208,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,tmp=(C_word)a,a+=7,tmp);
C_u_call_with_values(4,0,t1,t4,t5);}}

/* a3207 in conc463 in glob in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3208(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr5,f3208,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3212,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3279,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[296]);
t8=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t8+1)))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k3277 in a3207 in conc463 in glob in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3279(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3210 in a3207 in conc463 in glob in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3212(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3212,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3219,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(C_truep(((C_word*)t0)[4])?((C_word*)t0)[4]:lf[295]);
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* k3217 in k3210 in a3207 in conc463 in glob in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3219(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3219,2,t0,t1);}
t2=C_SCHEME_FALSE;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f3220,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t5=C_set_block_item(t3,0,t4);
t6=((C_word*)t3)[1];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,((C_word*)t0)[2],t1);}

/* loop480 in k3217 in k3210 in a3207 in conc463 in glob in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3220(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3220,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_slot(((C_word*)t0)[7],C_fix(1));
t4=((C_word*)((C_word*)t0)[6])[1];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f3237,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_u_i_car(t2);
t5=*((C_word*)lf[294]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k3235 in loop480 in k3217 in k3210 in a3207 in conc463 in glob in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3237(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3237,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3247,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_u_i_car(t1);
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=((C_word*)((C_word*)t0)[4])[1];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,((C_word*)t0)[6],t2);}}

/* k3245 in k3235 in loop480 in k3217 in k3210 in a3207 in conc463 in glob in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3247,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3251,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(1));
t4=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}

/* k3249 in k3245 in k3235 in loop480 in k3217 in k3210 in a3207 in conc463 in glob in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3251(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3251,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a3201 in conc463 in glob in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3202(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3202,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3167(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3167,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3171,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t4=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub452(t3),C_fix(0));}

/* k3169 in get-host-name in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3171(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3171,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3174,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f3174(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3177,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k3175 in k3169 in get-host-name in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3177(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[1]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[288],lf[289]);}

/* k3172 in k3169 in get-host-name in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3174(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-name in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3141(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3141,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3145,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3151,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_slot(t2,C_fix(7));
t6=(C_word)C_eqp(lf[10],t5);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3161,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t8=*((C_word*)lf[110]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=t4;
f3151(t7,C_SCHEME_FALSE);}}

/* k3159 in terminal-name in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f3151(t2,(C_word)C_tty_portp(t1));}

/* k3149 in terminal-name in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void C_fcall f3151(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[3];
f3145(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=*((C_word*)lf[1]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[286],lf[287],((C_word*)t0)[2]);}}

/* k3143 in terminal-name in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3145(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3145,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub445(t4,t3),C_fix(0));}

/* terminal-port? in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3125(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3125,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3129,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[231]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,C_fix(0));}

/* k3127 in terminal-port? in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3129(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(t1,C_fix(0));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3068(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim(tr4rv,f3068r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f3068r(t0,t1,t2,t3,t4);}}

static void f3068r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(5);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)BUFSIZ));
t7=t3;
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3075,a[2]=t6,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t9=(C_word)C_eqp(t7,lf[281]);
if(C_truep(t9)){
t10=t8;
f3075(2,t10,C_fix((C_word)_IOFBF));}
else{
t10=(C_word)C_eqp(t7,lf[282]);
if(C_truep(t10)){
t11=t8;
f3075(2,t11,C_fix((C_word)_IOLBF));}
else{
t11=(C_word)C_eqp(t7,lf[283]);
if(C_truep(t11)){
t12=t8;
f3075(2,t12,C_fix((C_word)_IONBF));}
else{
t12=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t12+1)))(6,t12,t8,lf[279],lf[284],t3,t2);}}}}

/* k3073 in set-buffering-mode! in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3075(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3075,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f3088,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[10],t3);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f3095,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t6=*((C_word*)lf[110]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,((C_word*)t0)[3]);}
else{
t5=t2;
f3088(t5,C_fix(-1));}}

/* k3093 in k3073 in set-buffering-mode! in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3095(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
f3088(t2,(C_word)C_setvbuf(t1,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* k3086 in k3073 in set-buffering-mode! in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void C_fcall f3088(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=*((C_word*)lf[1]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[5],lf[279],lf[280],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3065(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3065,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)stub431(C_SCHEME_UNDEFINED,t2));}

/* _exit in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3046(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim(tr2rv,f3046r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f3046r(t0,t1,t2);}}

static void f3046r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3050,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[277]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3048 in _exit in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3050(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_notvemptyp(((C_word*)t0)[3]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[3],C_fix(0)):C_fix(0));
t4=((C_word*)t0)[2];
t5=t4;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)stub425(C_SCHEME_UNDEFINED,t3));}

/* time->string in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3018(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3018,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[273]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3025,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
t6=*((C_word*)lf[1]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[273],lf[275],t2);}
else{
t6=t4;
f3025(2,t6,C_SCHEME_UNDEFINED);}}

/* k3023 in time->string in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3025(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3025,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3028,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub414(t4,t3),C_fix(0));}

/* k3026 in k3023 in time->string in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3028(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3028,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3031,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f3031(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=*((C_word*)lf[1]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[273],lf[274],((C_word*)t0)[2]);}}

/* k3029 in k3026 in k3023 in time->string in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3031(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->string in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3006(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3006,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3010,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub405(t5,t4),C_fix(0));}

/* k3008 in seconds->string in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f3010,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f3013,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f3013(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=*((C_word*)lf[1]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[271],lf[272],((C_word*)t0)[2]);}}

/* k3011 in k3008 in seconds->string in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3013(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->utc-time in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f3000(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f3000,3,t0,t1,t2);}
t3=*((C_word*)lf[269]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2994(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2994,3,t0,t1,t2);}
t3=*((C_word*)lf[269]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,t2,C_SCHEME_FALSE);}

/* memory-mapped-file-pointer in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2988(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2988,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2953(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim(tr3rv,f2953r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f2953r(t0,t1,t2,t3);}}

static void f2953r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(5);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_slot(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t6=(C_word)C_slot(t2,C_fix(1));
t7=(C_truep(t6)?(C_word)C_i_foreign_pointer_argumentp(t6):C_SCHEME_FALSE);
t8=(C_word)stub390(C_SCHEME_UNDEFINED,t7,t5);
t9=(C_word)C_eqp(C_fix(0),t8);
if(C_truep(t9)){
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,C_SCHEME_UNDEFINED);}
else{
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2966,a[2]=t5,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t11=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,t10);}}

/* k2964 in unmap-file-from-memory in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2966(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[5],lf[265],lf[266],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* map-file-to-memory in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2901(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim(tr7rv,f2901r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f2901r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void f2901r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f2905,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f2905(2,t10,t2);}
else{
t10=*((C_word*)lf[264]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t8);}}

/* k2903 in map-file-to-memory in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2905(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2905,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f2911,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f2911(2,t6,C_SCHEME_UNDEFINED);}
else{
t6=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[90],lf[259],lf[263],t1);}}

/* k2909 in k2903 in map-file-to-memory in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2911(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2911,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)stub364(t7,t8,t3,t4,t5,t6,((C_word*)t0)[3]);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2917,a[2]=((C_word*)t0)[7],a[3]=t9,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f2933,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t10,tmp=(C_word)a,a+=9,tmp);
t12=*((C_word*)lf[262]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t9);}

/* k2931 in k2909 in k2903 in map-file-to-memory in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2933(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2933,2,t0,t1);}
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f2926,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[8];
f2917(2,t3,C_SCHEME_UNDEFINED);}}

/* k2924 in k2931 in k2909 in k2903 in map-file-to-memory in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2926(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc11)(void*)(*((C_word*)t2+1)))(11,t2,((C_word*)t0)[8],lf[5],lf[259],lf[261],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k2915 in k2909 in k2903 in map-file-to-memory in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2917(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2917,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[260],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* current-environment in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2827(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2827,2,t0,t1);}
t2=C_SCHEME_FALSE;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2832,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_set_block_item(t3,0,t4);
t6=((C_word*)t3)[1];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t1,C_fix(0));}

/* loop346 in current-environment in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2832(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2832,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2836,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,(C_word)stub342(t5,t4),C_fix(0));}

/* k2834 in loop346 in current-environment in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2836(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2836,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_FALSE;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2843,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t5=C_set_block_item(t3,0,t4);
t6=((C_word*)t3)[1];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan351 in k2834 in loop346 in current-environment in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2843(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2843,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[6],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f2869,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
t5=((C_word*)t0)[3];
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[6],C_fix(0),t2);}
else{
t4=(C_word)C_u_fixnum_plus(t2,C_fix(1));
t5=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t1,t4);}}

/* k2867 in scan351 in k2834 in loop346 in current-environment in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2869(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2869,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2873,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_u_fixnum_plus(((C_word*)t0)[4],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[3]);
t5=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[3],t3,t4);}

/* k2871 in k2867 in scan351 in k2834 in loop346 in current-environment in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2873(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2873,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2861,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_u_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t5=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t3,t4);}

/* k2859 in k2871 in k2867 in scan351 in k2834 in loop346 in current-environment in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2861(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2861,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2820(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2820,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2825,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k2823 in unsetenv in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2825(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2809(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr4,f2809,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2814,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2812 in setenv in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2814(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2814,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2818,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k2816 in k2812 in setenv in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2818(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2787(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2787,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2791,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[130]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k2789 in fifo? in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2791(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2791,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2794,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2792 in k2789 in fifo? in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2794(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(((C_word*)t0)[4])){
t2=(C_word)C_slot(((C_word*)t0)[4],C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[5],lf[245],lf[246],((C_word*)t0)[2]);}}

/* create-fifo in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2751(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim(tr3rv,f2751r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f2751r(t0,t1,t2,t3);}}

static void f2751r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2755,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t5=t4;
f2755(t5,(C_word)C_slot(t3,C_fix(0)));}
else{
t5=(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t6=t4;
f2755(t6,(C_word)C_u_fixnum_or(C_fix((C_word)S_IRWXU),t5));}}

/* k2753 in create-fifo in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void C_fcall f2755(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf2755,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2772,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k2770 in k2753 in create-fifo in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2772(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2772,2,t0,t1);}
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2764,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2762 in k2770 in k2753 in create-fifo in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2764(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[5],lf[243],lf[244],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-unlock in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2723(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2723,3,t0,t1,t2);}
t3=(C_word)C_slot(t2,C_fix(2));
t4=(C_word)C_slot(t2,C_fix(3));
t5=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t3,t4);
t6=(C_word)C_slot(t2,C_fix(1));
t7=(C_word)C_flock_lock(t6);
if(C_truep((C_word)C_fixnum_lessp(t7,C_fix(0)))){
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2741,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t9=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}
else{
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,C_SCHEME_UNDEFINED);}}

/* k2739 in file-unlock in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2741(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[5],lf[241],lf[242],((C_word*)t0)[2]);}

/* file-test-lock in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2701(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim(tr3r,f2701r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2701r(t0,t1,t2,t3);}}

static void f2701r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2705,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
f1088(t4,t2,t3);}

/* k2703 in file-test-lock in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2705(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[3]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
f950(((C_word*)t0)[2],lf[239],lf[240],t1);}}

/* file-lock in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2686(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim(tr3r,f2686r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2686r(t0,t1,t2,t3);}}

static void f2686r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2690,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
f1088(t4,t2,t3);}

/* k2688 in file-lock in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2690(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[3]),C_fix(0)))){
f950(((C_word*)t0)[2],lf[237],lf[238],t1);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-truncate in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2651(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr4,f2651,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2668,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2675,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t5=t4;
f2668(2,t5,(C_word)C_ftruncate(t2,t3));}
else{
t5=*((C_word*)lf[1]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,lf[234],lf[236],t2);}}}

/* k2673 in file-truncate in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2675(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f2668(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k2666 in file-truncate in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2668,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2661,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k2659 in k2666 in file-truncate in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2661(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[5],lf[234],lf[235],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* duplicate-fileno in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2627(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim(tr3rv,f2627r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f2627r(t0,t1,t2,t3);}}

static void f2627r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2631,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t5=t4;
f2631(t5,(C_word)C_dup(t2));}
else{
t5=(C_word)C_slot(t3,C_fix(0));
t6=t4;
f2631(t6,(C_word)C_dup2(t2,t5));}}

/* k2629 in duplicate-fileno in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void C_fcall f2631(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf2631,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2634,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2640,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f2634(2,t3,C_SCHEME_UNDEFINED);}}

/* k2638 in k2629 in duplicate-fileno in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2640(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[5],lf[232],lf[233],((C_word*)t0)[2]);}

/* k2632 in k2629 in duplicate-fileno in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2595(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2595,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2625,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[231]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,C_fix(0));}

/* k2623 in port->fileno in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2625(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2625,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[90],lf[228],lf[229],((C_word*)t0)[2]);}
else{
t2=(C_word)C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2605,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2611,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f2605(2,t4,C_SCHEME_UNDEFINED);}}}

/* k2609 in k2623 in port->fileno in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2611(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[5],lf[228],lf[230],((C_word*)t0)[2]);}

/* k2603 in k2623 in port->fileno in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2605(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2584(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim(tr3r,f2584r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2584r(t0,t1,t2,t3);}}

static void f2584r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2593,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
f1355(t4,C_SCHEME_FALSE,t3);}

/* k2591 in open-output-file* in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2593(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2593,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[3],t1);
f1015(((C_word*)t0)[2],((C_word*)t0)[3],C_SCHEME_FALSE,t2);}

/* open-input-file* in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2573(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim(tr3r,f2573r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2573r(t0,t1,t2,t3);}}

static void f2573r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2582,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
f1355(t4,C_SCHEME_TRUE,t3);}

/* k2580 in open-input-file* in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2582(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2582,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[3],t1);
f1015(((C_word*)t0)[2],((C_word*)t0)[3],C_SCHEME_TRUE,t2);}

/* read-symbolic-link in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2548(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2548,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2553,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k2551 in read-symbolic-link in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2553(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2553,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2556,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2565,a[2]=((C_word*)t0)[2],a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f2556(2,t4,C_SCHEME_UNDEFINED);}}

/* k2563 in k2551 in read-symbolic-link in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2565(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[5],lf[221],lf[222],((C_word*)t0)[2]);}

/* k2554 in k2551 in read-symbolic-link in k2545 in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2556(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[5];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* create-symbolic-link in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2521(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr4,f2521,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2539,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2537 in create-symbolic-link in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2539(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2539,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2543,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k2541 in k2537 in create-symbolic-link in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2543(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2543,2,t0,t1);}
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2531,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2529 in k2541 in k2537 in create-symbolic-link in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2531(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[5],lf[219],lf[220],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-execute-access? in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2515(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2515,3,t0,t1,t2);}
f998(t1,t2,C_fix((C_word)X_OK));}

/* file-write-access? in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2509(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2509,3,t0,t1,t2);}
f998(t1,t2,C_fix((C_word)W_OK));}

/* file-read-access? in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2503(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2503,3,t0,t1,t2);}
f998(t1,t2,C_fix((C_word)R_OK));}

/* set-user-id! in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2488(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2488,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2498,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2496 in set-user-id! in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2498(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[1]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[213],lf[214],((C_word*)t0)[2]);}

/* current-effective-group-id in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2485(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2485,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub234(C_SCHEME_UNDEFINED));}

/* current-effective-user-id in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2482(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2482,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub232(C_SCHEME_UNDEFINED));}

/* current-group-id in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2479(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2479,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub230(C_SCHEME_UNDEFINED));}

/* current-user-id in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2476(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2476,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub228(C_SCHEME_UNDEFINED));}

/* change-file-owner in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2456(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr5,f2456,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2474,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2472 in change-file-owner in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2474,2,t0,t1);}
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2466,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2464 in k2472 in change-file-owner in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2466(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[5],lf[207],lf[208],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* change-file-mode in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2436(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr4,f2436,4,t0,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2454,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k2452 in change-file-mode in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2454(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2454,2,t0,t1);}
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2446,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k2444 in k2452 in change-file-mode in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2446(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[5],lf[205],lf[206],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* user-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2375(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2375,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2379,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f2379(t4,(C_word)C_getpwuid(t2));}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2412,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}}

/* k2410 in user-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2412(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f2379(t2,(C_word)C_getpwnam(t1));}

/* k2377 in user-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void C_fcall f2379(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf2379,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2389,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2387 in k2377 in user-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2389(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2389,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2393,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k2391 in k2387 in k2377 in user-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2393(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2393,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2397,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k2395 in k2391 in k2387 in k2377 in user-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2397(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2397,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2401,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k2399 in k2395 in k2391 in k2387 in k2377 in user-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2401(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2401,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2405,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[182]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k2403 in k2399 in k2395 in k2391 in k2387 in k2377 in user-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2405(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(9,0,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* system-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2337(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2337,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2341,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2370,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f2341(2,t3,C_SCHEME_UNDEFINED);}}

/* k2368 in system-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2370(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[1]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[178],lf[180]);}

/* k2339 in system-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2341(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2341,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2348,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k2346 in k2339 in system-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2348(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2348,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2352,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k2350 in k2346 in k2339 in system-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2352(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2352,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2356,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k2354 in k2350 in k2346 in k2339 in system-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2356(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2356,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2360,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k2358 in k2354 in k2350 in k2346 in k2339 in system-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2360(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2360,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2364,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[179]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k2362 in k2358 in k2354 in k2350 in k2346 in k2339 in system-information in k2333 in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2364(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(7,0,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* set-signal-mask! in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2313(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2313,3,t0,t1,t2);}
t3=(C_word)C_sigemptyset(C_fix(0));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2317,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f2331,tmp=(C_word)a,a+=2,tmp);
t6=*((C_word*)lf[97]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t4,t5,t2);}

/* a2330 in set-signal-mask! in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2331(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2331,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_sigaddset(t2));}

/* k2315 in set-signal-mask! in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2317(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2317,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask(C_fix(0)),C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2326,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k2324 in k2315 in set-signal-mask! in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2326(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[1]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[176],lf[177]);}

/* ##sys#interrupt-hook in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2295(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr4,f2295,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2305,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t6=t4;
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}
else{
t5=((C_word*)t0)[2];
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t1,t2,t3);}}

/* k2303 in ##sys#interrupt-hook in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2305(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[175]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k2281 in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2285(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr4,f2285,4,t0,t1,t2,t3);}
t4=(C_truep(t3)?t2:C_SCHEME_FALSE);
t5=(C_word)C_establish_signal_handler(t2,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)C_i_setslot(((C_word*)t0)[2],t2,t3));}

/* create-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2239(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2239,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2243,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2252,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f2243(2,t3,C_SCHEME_UNDEFINED);}}

/* k2250 in create-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2252(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[5],lf[146],lf[147]);}

/* k2241 in create-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2243(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2219(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim(tr4r,f2219r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f2219r(t0,t1,t2,t3,t4);}}

static void f2219r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[145]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2223,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2221 in with-output-to-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2223(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2223,2,t0,t1);}
t2=C_mutate((C_word*)lf[145]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2229,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2228 in k2221 in with-output-to-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2229(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim(tr2r,f2229r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f2229r(t0,t1,t2);}}

static void f2229r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2233,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2231 in a2228 in k2221 in with-output-to-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2233(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[145]+1,((C_word*)t0)[4]);
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[140]+1),((C_word*)t0)[2]);}

/* with-input-from-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2199(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim(tr4r,f2199r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f2199r(t0,t1,t2,t3,t4);}}

static void f2199r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[143]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2203,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2201 in with-input-from-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2203(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2203,2,t0,t1);}
t2=C_mutate((C_word*)lf[143]+1,t1);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2209,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
C_u_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2208 in k2201 in with-input-from-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2209(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim(tr2r,f2209r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f2209r(t0,t1,t2);}}

static void f2209r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2213,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2211 in a2208 in k2201 in with-input-from-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2213(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[143]+1,((C_word*)t0)[4]);
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[140]+1),((C_word*)t0)[2]);}

/* call-with-output-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2175(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim(tr4r,f2175r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f2175r(t0,t1,t2,t3,t4);}}

static void f2175r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2179,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2177 in call-with-output-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2179(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2179,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2184,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2190,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2189 in k2177 in call-with-output-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2190(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim(tr2r,f2190r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f2190r(t0,t1,t2);}}

static void f2190r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2194,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2192 in a2189 in k2177 in call-with-output-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2194(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[140]+1),((C_word*)t0)[2]);}

/* a2183 in k2177 in call-with-output-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2184(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2184,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2151(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim(tr4r,f2151r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f2151r(t0,t1,t2,t3,t4);}}

static void f2151r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2155,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2153 in call-with-input-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2155(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2155,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2160,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2166,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
C_u_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2165 in k2153 in call-with-input-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2166(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim(tr2r,f2166r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f2166r(t0,t1,t2);}}

static void f2166r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2170,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k2168 in a2165 in k2153 in call-with-input-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2170(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(4,0,((C_word*)t0)[3],*((C_word*)lf[140]+1),((C_word*)t0)[2]);}

/* a2159 in k2153 in call-with-input-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2160(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2160,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2135(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2135,3,t0,t1,t2);}
t3=(C_word)close_pipe(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f2139,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}

/* k2137 in close-input-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2139(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t2)){
t3=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,((C_word*)t0)[3],lf[5],lf[136],lf[137],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* open-output-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2102(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim(tr3r,f2102r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2102r(t0,t1,t2,t3);}}

static void f2102r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(10);
t4=f1334(t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2113,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_eqp(t4,lf[37]);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2120,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t8=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(C_word)C_eqp(t4,lf[134]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2130,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t9=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
f1346(t5,t4);}}}

/* k2128 in open-output-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2130(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2130,2,t0,t1);}
t2=((C_word*)t0)[2];
f2113(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k2118 in open-output-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2120(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2120,2,t0,t1);}
t2=((C_word*)t0)[2];
f2113(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k2111 in open-output-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2113(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f974(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2069(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim(tr3r,f2069r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f2069r(t0,t1,t2,t3);}}

static void f2069r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(10);
t4=f1334(t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2080,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_eqp(t4,lf[37]);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2087,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t8=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
t7=(C_word)C_eqp(t4,lf[134]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2097,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t9=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
f1346(t5,t4);}}}

/* k2095 in open-input-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2097(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2097,2,t0,t1);}
t2=((C_word*)t0)[2];
f2080(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k2085 in open-input-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2087(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2087,2,t0,t1);}
t2=((C_word*)t0)[2];
f2080(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k2078 in open-input-pipe in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
f974(((C_word*)t0)[3],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* current-directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2051(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2051,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2055,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,C_fix(256));}

/* k2053 in current-directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2055(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2055,2,t0,t1);}
t2=(C_word)C_curdir(t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f2058,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k2056 in k2053 in current-directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2058(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(((C_word*)t0)[5])){
t2=((C_word*)t0)[4];
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0),((C_word*)t0)[5]);}
else{
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[5],lf[131],lf[132]);}}

/* directory? in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2035(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f2035,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f2039,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=*((C_word*)lf[130]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k2037 in directory? in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2039(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1985(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1985,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1989,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,C_fix(256));}

/* k1987 in directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1989(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1989,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1992,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=*((C_word*)lf[128]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1990 in k1987 in directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1992(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1992,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1995,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t3=*((C_word*)lf[128]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k1993 in k1990 in k1987 in directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1995(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1995,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f1999,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[4]);}

/* k1997 in k1993 in k1990 in k1987 in directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1999(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1999,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2008,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=C_SCHEME_FALSE;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f2015,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
t6=C_set_block_item(t4,0,t5);
t7=((C_word*)t4)[1];
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,((C_word*)t0)[6]);}}

/* loop116 in k1997 in k1993 in k1990 in k1987 in directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2015(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2015,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2025,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=((C_word*)t0)[2];
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k2023 in loop116 in k1997 in k1993 in k1990 in k1987 in directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2025(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2025,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f2032,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)((C_word*)t0)[2])[1];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2030 in k2023 in loop116 in k1997 in k1993 in k1990 in k1987 in directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2032(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f2032,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k2006 in k1997 in k1993 in k1990 in k1987 in directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f2008(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[5],lf[126],lf[127],((C_word*)t0)[2]);}

/* delete-directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1965(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1965,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1983,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k1981 in delete-directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1983(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1983,2,t0,t1);}
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1975,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1973 in k1981 in delete-directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1975(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[5],lf[121],lf[122],((C_word*)t0)[2]);}

/* change-directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1945(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1945,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1963,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k1961 in change-directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1963(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1963,2,t0,t1);}
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1955,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1953 in k1961 in change-directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1955(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[5],lf[119],lf[120],((C_word*)t0)[2]);}

/* create-directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1925(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1925,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1943,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,t2);}

/* k1941 in create-directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1943(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1943,2,t0,t1);}
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1935,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}}

/* k1933 in k1941 in create-directory in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1935(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[5],lf[117],lf[118],((C_word*)t0)[2]);}

/* set-file-position! in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1866(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim(tr4rv,f1866r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1866r(t0,t1,t2,t3,t4);}}

static void f1866r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1873,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t8=*((C_word*)lf[1]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t7,lf[113],lf[116],t3,t2);}
else{
t8=t7;
f1873(2,t8,C_SCHEME_UNDEFINED);}}

/* k1871 in set-file-position! in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1873(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1873,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1879,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1888,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=*((C_word*)lf[112]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k1886 in k1871 in set-file-position! in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1888(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1888,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[10]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1898,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t5=*((C_word*)lf[110]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[5]);}
else{
t4=((C_word*)t0)[4];
f1879(2,t4,C_SCHEME_FALSE);}}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f1879(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[90],lf[113],lf[115],((C_word*)t0)[5]);}}}

/* k1896 in k1886 in k1871 in set-file-position! in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1898(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[4];
f1879(2,t2,(C_word)C_fseek(t1,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* k1877 in k1871 in set-file-position! in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1879(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1879,2,t0,t1);}
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1882,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}}

/* k1880 in k1877 in k1871 in set-file-position! in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1882(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[5],lf[113],lf[114],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-position in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1822(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1822,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1826,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1841,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[112]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1839 in file-position in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1841(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1841,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[10]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1851,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[110]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[3]);}
else{
t4=((C_word*)t0)[2];
f1826(2,t4,C_fix(-1));}}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f1826(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[90],lf[108],lf[111],((C_word*)t0)[3]);}}}

/* k1849 in k1839 in file-position in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1851(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f1826(2,t2,(C_word)C_ftell(t1));}

/* k1824 in file-position in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1826(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1826,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1829,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1835,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f1829(2,t3,C_SCHEME_UNDEFINED);}}

/* k1833 in k1824 in file-position in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1835(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[5],lf[108],lf[109],((C_word*)t0)[2]);}

/* k1827 in k1824 in file-position in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1829(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-permissions in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1816(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1816,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1820,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
f1764(t3,t2);}

/* k1818 in file-permissions in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1820(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix((C_word)C_statbuf.st_mode));}

/* file-owner in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1810(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1810,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1814,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
f1764(t3,t2);}

/* k1812 in file-owner in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1814(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix((C_word)C_statbuf.st_uid));}

/* file-modification-time in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1804(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1804,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1808,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
f1764(t3,t2);}

/* k1806 in file-modification-time in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1808(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix((C_word)C_statbuf.st_mtime));}

/* file-size in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1798(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1798,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1802,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
f1764(t3,t2);}

/* k1800 in file-size in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1802(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix((C_word)C_statbuf.st_size));}

/* ##sys#stat in k1404 in k1401 in k1398 in k1395 in k1392 */
static void C_fcall f1764(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1764,NULL,2,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1768,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f1768(2,t4,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1793,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}
else{
t4=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t3,lf[90],lf[103],t2);}}}

/* k1791 in ##sys#stat in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1793(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f1768(2,t2,(C_word)C_stat(t1));}

/* k1766 in ##sys#stat in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1768(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1768,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1777,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* k1775 in k1766 in ##sys#stat in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1777(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[5],lf[102],((C_word*)t0)[2]);}

/* file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1584(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim(tr4rv,f1584r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1584r(t0,t1,t2,t3,t4);}}

static void f1584r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(12);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_slot(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f1055(C_fix(0));
t10=f1055(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1600,a[2]=t6,a[3]=t8,a[4]=t2,a[5]=t1,a[6]=t3,tmp=(C_word)a,a+=7,tmp);
if(C_truep(t11)){
t13=t12;
f1600(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
t14=t12;
f1600(2,t14,f1058(C_fix(0),t2));}
else{
t13=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1748,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
t14=*((C_word*)lf[97]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t12,t13,t2);}}}

/* a1747 in file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1748(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1748,3,t0,t1,t2);}
t3=C_mutate(((C_word *)((C_word*)t0)[2])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[2])[1],t2));
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,f1058(C_fix(0),t2));}

/* k1598 in file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1600(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1600,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[6]);
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1606,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(t2)){
t4=t3;
f1606(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[6]))){
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)t0)[6]);
t5=t3;
f1606(2,t5,f1058(C_fix(1),((C_word*)t0)[6]));}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1728,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=*((C_word*)lf[97]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,t4,((C_word*)t0)[6]);}}}

/* a1727 in k1598 in file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1728(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1728,3,t0,t1,t2);}
t3=C_mutate(((C_word *)((C_word*)t0)[2])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[2])[1],t2));
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,f1058(C_fix(1),t2));}

/* k1604 in k1598 in file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1606(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1606,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1609,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f1609(t4,(C_word)C_select_t(t3,((C_word*)t0)[3]));}
else{
t3=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f1609(t4,(C_word)C_select(t3));}}

/* k1607 in k1604 in k1598 in file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void C_fcall f1609(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word ab[18],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1609,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1618,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[3]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[2]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
C_values(4,0,((C_word*)t0)[4],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1651,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t4=t3;
f1651(t4,f1165(C_fix(0),((C_word*)t0)[3]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1692,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1694,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
t8=*((C_word*)lf[97]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[3]);}}
else{
t4=t3;
f1651(t4,C_SCHEME_FALSE);}}}}

/* a1693 in k1607 in k1604 in k1598 in file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1694(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1694,3,t0,t1,t2);}
t3=f1165(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1690 in k1607 in k1604 in k1598 in file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1692(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f1651(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1649 in k1607 in k1604 in k1598 in file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void C_fcall f1651(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1651,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1655,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[2])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[2]))){
t3=t2;
f1655(t3,f1165(C_fix(1),((C_word*)t0)[2]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1667,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1669,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t7=*((C_word*)lf[97]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[2]);}}
else{
t3=t2;
f1655(t3,C_SCHEME_FALSE);}}

/* a1668 in k1649 in k1607 in k1604 in k1598 in file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1669(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1669,3,t0,t1,t2);}
t3=f1165(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1665 in k1649 in k1607 in k1604 in k1598 in file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1667(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f1655(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1653 in k1649 in k1607 in k1604 in k1598 in file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void C_fcall f1655(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k1616 in k1607 in k1604 in k1598 in file-select in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1618(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[5],lf[95],lf[96],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* file-write in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1548(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim(tr4rv,f1548r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1548r(t0,t1,t2,t3,t4);}}

static void f1548r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1552,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t5;
f1552(2,t7,C_SCHEME_UNDEFINED);}
else{
t7=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t5,lf[90],lf[92],lf[94],t3);}}

/* k1550 in file-write in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1552(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1552,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_slot(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1558,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_eqp(C_fix(-1),t4);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1564,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t8=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
t7=t5;
f1558(2,t7,C_SCHEME_UNDEFINED);}}

/* k1562 in k1550 in file-write in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1564(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[5],lf[92],lf[93],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1556 in k1550 in file-write in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1558(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1509(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim(tr4rv,f1509r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1509r(t0,t1,t2,t3,t4);}}

static void f1509r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1513,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t6=t5;
f1513(2,t6,(C_word)C_slot(t4,C_fix(0)));}
else{
t6=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t3);}}

/* k1511 in file-read in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1513(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1513,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1516,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f1516(2,t4,C_SCHEME_UNDEFINED);}
else{
t4=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[90],lf[88],lf[91],t1);}}

/* k1514 in k1511 in file-read in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1516(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1516,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1519,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1528,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[5],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f1519(2,t5,C_SCHEME_UNDEFINED);}}

/* k1526 in k1514 in k1511 in file-read in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1528(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t2+1)))(7,t2,((C_word*)t0)[4],lf[5],lf[88],lf[89],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1517 in k1514 in k1511 in file-read in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1519(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1519,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1494(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1494,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1504,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k1502 in file-close in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1504(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[3],lf[5],lf[85],lf[86],((C_word*)t0)[2]);}

/* file-open in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1466(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim(tr4rv,f1466r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f1466r(t0,t1,t2,t3,t4);}}

static void f1466r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_slot(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1474,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t8=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k1472 in file-open in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1474(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1474,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1477,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1483,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t3;
f1477(2,t5,C_SCHEME_UNDEFINED);}}

/* k1481 in k1472 in file-open in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1483(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[4]+1);
((C_proc8)(void*)(*((C_word*)t2+1)))(8,t2,((C_word*)t0)[5],lf[5],lf[83],lf[84],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k1475 in k1472 in file-open in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1477(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* yield in k1404 in k1401 in k1398 in k1395 in k1392 */
static void C_fcall f1411(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1411,NULL,1,t1);}
t2=(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1417,tmp=(C_word)a,a+=2,tmp);
C_call_cc(3,0,t1,t2);}

/* a1416 in yield in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1417(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1417,3,t0,t1,t2);}
t3=*((C_word*)lf[50]+1);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1426,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t5=(C_word)C_i_setslot(t3,C_fix(1),t4);
t6=*((C_word*)lf[51]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t1);}

/* a1425 in a1416 in yield in k1404 in k1401 in k1398 in k1395 in k1392 */
static void f1426(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1426,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,C_SCHEME_UNDEFINED);}

/* make-nonblocking in k1404 in k1401 in k1398 in k1395 in k1392 */
static C_word C_fcall f1408(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub1(C_SCHEME_UNDEFINED,t1));}

/* mode */
static void C_fcall f1355(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1355,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1363,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_u_i_car(t3);
t6=(C_word)C_eqp(t5,lf[41]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
t8=*((C_word*)lf[1]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[42],t5);}
else{
t8=t4;
f1363(2,t8,lf[43]);}}
else{
t7=*((C_word*)lf[1]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[44],t5);}}
else{
t5=t4;
f1363(2,t5,(C_truep(t2)?lf[45]:lf[46]));}}

/* k1361 in mode */
static void f1363(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* badmode */
static void C_fcall f1346(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1346,NULL,2,t1,t2);}
t3=*((C_word*)lf[1]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[39],t2);}

/* mode */
static C_word C_fcall f1334(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[37]));}

/* body666 */
static void C_fcall f1197(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9,C_word t10){
C_word tmp;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1197,NULL,10,t1,t2,t3,t4,t5,t6,t7,t8,t9,t10);}
t11=C_fix(0);
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f1201,a[2]=t2,a[3]=t9,a[4]=t1,a[5]=t5,a[6]=t8,a[7]=t3,a[8]=t4,a[9]=t12,a[10]=t7,a[11]=t6,tmp=(C_word)a,a+=12,tmp);
t14=t10;
if(C_truep(t14)){
t15=(C_word)C_fixnump(t10);
t16=t13;
f1201(t16,(C_truep(t15)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1328,a[2]=t10,a[3]=t12,tmp=(C_word)a,a+=4,tmp):t10));}
else{
t15=t13;
f1201(t15,(*a=C_CLOSURE_TYPE|1,a[1]=(C_word)f1320,tmp=(C_word)a,a+=2,tmp));}}

/* f1320 in body666 */
static void f1320(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1320,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f1328 in body666 */
static void f1328(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1328,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k1199 in body666 */
static void C_fcall f1201(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1201,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1312,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f1211,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1308,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
t6=((C_word*)t0)[7];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],lf[35]);}

/* k1306 in k1199 in body666 */
static void f1308(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1209 in k1199 in body666 */
static void f1211(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1211,2,t0,t1);}
t2=C_SCHEME_FALSE;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f1212,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,tmp=(C_word)a,a+=10,tmp);
t5=C_set_block_item(t3,0,t4);
t6=((C_word*)t3)[1];
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop682 in k1209 in k1199 in body666 */
static void f1212(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr4,f1212,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f1231,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
t7=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t4);}}

/* k1229 in loop682 in k1209 in k1199 in body666 */
static void f1231(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1231,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f1287,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
t3=*((C_word*)lf[34]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f1293,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}}

/* k1291 in k1229 in loop682 in k1209 in k1199 in body666 */
static void f1293(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1293,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1300,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
t3=((C_word*)t0)[4];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)((C_word*)t0)[7])[1];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k1298 in k1291 in k1229 in loop682 in k1209 in k1199 in body666 */
static void f1300(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[4])[1];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k1285 in k1229 in loop682 in k1209 in k1199 in body666 */
static void f1287(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1287,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[30]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[31]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
t2=((C_word*)((C_word*)t0)[10])[1];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f1246,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
t3=((C_word*)t0)[2];
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[3]);}}

/* k1244 in k1285 in k1229 in loop682 in k1209 in k1199 in body666 */
static void f1246(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1246,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_u_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1256,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1258,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f1263,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],tmp=(C_word)a,a+=7,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1277,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
t11=*((C_word*)lf[33]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
t2=((C_word*)((C_word*)t0)[8])[1];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a1276 in k1244 in k1285 in k1229 in loop682 in k1209 in k1199 in body666 */
static void f1277(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1277,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* a1262 in k1244 in k1285 in k1229 in loop682 in k1209 in k1199 in body666 */
static void f1263(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1263,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f1271,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1275,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,((C_word*)t0)[2],lf[32]);}

/* k1273 in a1262 in k1244 in k1285 in k1229 in loop682 in k1209 in k1199 in body666 */
static void f1275(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1269 in a1262 in k1244 in k1285 in k1229 in loop682 in k1209 in k1199 in body666 */
static void f1271(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[4])[1];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a1257 in k1244 in k1285 in k1229 in loop682 in k1209 in k1199 in body666 */
static void f1258(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1258,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k1254 in k1244 in k1285 in k1229 in loop682 in k1209 in k1199 in body666 */
static void f1256(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)((C_word*)t0)[4])[1];
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f1312 in k1199 in body666 */
static void f1312(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr3,f1312,3,t0,t1,t2);}
t3=((C_word*)t0)[3];
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,((C_word*)t0)[2],t2);}

/* def-limit670 */
static void C_fcall f1191(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9){
C_word tmp;
C_word t10;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1191,NULL,9,t1,t2,t3,t4,t5,t6,t7,t8,t9);}
f1197(t1,t2,t3,t4,t5,t6,t7,t8,t9,C_SCHEME_FALSE);}

/* setarg */
static C_word C_fcall f1174(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
t4=(C_truep(t2)?t2:C_SCHEME_FALSE);
return((C_word)stub508(C_SCHEME_UNDEFINED,t1,t4,t3));}

/* fd_test */
static C_word C_fcall f1165(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub49(C_SCHEME_UNDEFINED,t1,t2));}

/* setup */
static void C_fcall f1088(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1088,NULL,3,t1,t2,t3);}
t4=(C_word)C_i_nullp(t3);
t5=(C_truep(t4)?C_fix(0):(C_word)C_u_i_car(t3));
t6=(C_word)C_i_nullp(t3);
t7=(C_truep(t6)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t3,C_fix(1)));
t8=(C_word)C_i_nullp(t7);
t9=(C_truep(t8)?C_SCHEME_TRUE:(C_word)C_u_i_car(t7));
t10=t9;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(C_word)C_i_nullp(t7);
t13=(C_truep(t12)?C_SCHEME_END_OF_LIST:(C_word)C_slot(t7,C_fix(1)));
if(C_truep((C_word)C_i_nullp(t13))){
t14=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1110,a[2]=t1,a[3]=t11,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t15=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)t11)[1]);
if(C_truep(t15)){
t16=C_set_block_item(t11,0,C_fix(0));
t17=t14;
f1110(t17,t16);}
else{
t16=t14;
f1110(t16,C_SCHEME_UNDEFINED);}}
else{
t14=*((C_word*)lf[1]+1);
((C_proc4)(void*)(*((C_word*)t14+1)))(4,t14,t1,lf[26],t13);}}

/* k1108 in setup */
static void C_fcall f1110(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1110,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_WRLCK):C_fix((C_word)F_RDLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[25],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* wait */
static void C_fcall f1067(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1067,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1073,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f1079,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
C_u_call_with_values(4,0,t1,t4,t5);}

/* a1078 in wait */
static void f1079(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr5,f1079,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=*((C_word*)lf[21]+1);
((C_proc6)(void*)(*((C_word*)t5+1)))(6,t5,t1,lf[22],lf[23],((C_word*)t0)[2],t4);}}

/* a1072 in wait */
static void f1073(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1073,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,t1,((C_word*)t0)[2]);}

/* fd_set */
static C_word C_fcall f1058(C_word t1,C_word t2){
C_word tmp;
C_word t3;
return((C_word)stub43(C_SCHEME_UNDEFINED,t1,t2));}

/* fd_zero */
static C_word C_fcall f1055(C_word t1){
C_word tmp;
C_word t2;
return((C_word)stub38(C_SCHEME_UNDEFINED,t1));}

/* def-id669 */
static void C_fcall f1036(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1036,NULL,8,t1,t2,t3,t4,t5,t6,t7,t8);}
f1191(t1,t2,t3,t4,t5,t6,t7,t8,C_SCHEME_END_OF_LIST);}

/* check */
static void C_fcall f1015(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf1015,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f1019,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k1017 in check */
static void f1019(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1019,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[5],lf[14],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1031,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[7]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[8]+1),lf[15],lf[10]);}}

/* k1029 in k1017 in check */
static void f1031(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* check */
static void C_fcall f998(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf998,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1013,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=*((C_word*)lf[12]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1011 in check */
static void f1013(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f1013,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f1005,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f1005(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k1003 in k1011 in check */
static void f1005(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* check */
static void C_fcall f974(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf974,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f978,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k976 in check */
static void f978(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(tr2,f978,2,t0,t1);}
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t2=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[4],lf[5],lf[6],((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f990,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=*((C_word*)lf[7]+1);
((C_proc6)(void*)(*((C_word*)t3+1)))(6,t3,t2,((C_word*)t0)[2],*((C_word*)lf[8]+1),lf[9],lf[10]);}}

/* k988 in k976 in check */
static void f990(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* err */
static void C_fcall f950(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim(trf950,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f954,a[2]=t2,a[3]=t4,a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t6=*((C_word*)lf[2]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}

/* k952 in err */
static void f954(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_word)C_slot(((C_word*)t0)[5],C_fix(2));
t4=(C_word)C_slot(((C_word*)t0)[5],C_fix(3));
t5=*((C_word*)lf[1]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t2,t3,t4);}
/* end of file */
