;;;; report.scm - Print some status information
;
; Copyright (c) 2000-2002, Felix L. Winkelmann
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following
; conditions are met:
;
;   Redistributions of source code must retain the above copyright notice, this list of conditions and the following
;     disclaimer. 
;   Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following
;     disclaimer in the documentation and/or other materials provided with the distribution. 
;   Neither the name of the author nor the names of its contributors may be used to endorse or promote
;     products derived from this software without specific prior written permission. 
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS
; OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
; AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR
; CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
; CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
; THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
; OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
; POSSIBILITY OF SUCH DAMAGE.
;
; Send bugs, suggestions and ideas to: 
;
; felix@call-with-current-continuation.org
;
; Felix L. Winkelmann
; Steinweg 1A
; 37130 Gleichen, OT Weissenborn
; Germany


(declare (uses extras))


(define (report . port)
  (with-output-to-port (if (pair? port) (car port) (current-output-port))
    (lambda ()
      (let ([sinfo (##sys#symbol-table-info)]
	    [minfo (##sys#memory-info)] )
	(define (shorten n) (/ (truncate (* n 100)) 100))
	(let-values ([(sysname nodename release version machine) (system-information)])
	  (printf "Features:~%  ~S~%~%~
                   Host system information:~%  ~A ~A ~A ~A ~A~%~%~
                   Machine type:\t~A~%~
                   Software type:\t~A~%~
                   Platform:\t~A~%~%~
                   Current working dir:\t~A~%~
                   Include path:~%  ~A~%~
                   Symbol-table load:\t~S~%  ~
                     Avg bucket length:\t~S~%  ~
                     Total symbols:\t~S~%~%~
                   Memory:\t~S heap, ~S stack~%~
                   Bytes free in heap:\t~S~%~%~
                   Threads:~%"
		  (sort (features) (lambda (x y) (string<? (symbol->string x) (symbol->string y))))
		  sysname nodename release version machine
		  (machine-type)
		  (software-type)
		  (case (##sys#fudge 3)
		    [(#\V) "Windows/Visual C++"]
		    [(#\G) "Windows/Cygwin"]
		    [(#\g) "Generic GCC"]
		    [(#\D) "DOS/DJGPP"]
		    [(#\M) "Mac/CodeWarrior"]
		    [(#\W) "Windows/Watcom C"]
		    [else "<unknown>"] )
		  (current-directory)
		  ##sys#include-pathnames
		  (shorten (vector-ref sinfo 0))
		  (shorten (vector-ref sinfo 1))
		  (vector-ref sinfo 2)
		  (vector-ref minfo 0) (vector-ref minfo 1)
		  (gc) )
	  (critical-section
	   (for-each 
	    (lambda (t) (printf "  ~S: ~S~%" (##sys#slot t 6) (##sys#slot t 3)))
	    (##sys#all-threads) ) )
	  (newline)
	  (when (##sys#fudge 14) (display "interrupts are enabled\n"))
	  (when (##sys#fudge 15) (display "symbol gc is enabled\n")) 
	  (void) ) ) ) ) )


(cond-expand [(not use-modules)])

(define-module report
  (unqualified)
  (export report) )
