/***************************************************************************
                          interface_widget_visual2.cpp  -  description
                             -------------------
    begin                : Mon May 7 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_widget_visual2.h"

#include "interface_widget_visual1.h"

#define VU_BARS_LENGTH 25
#define VOLUME_MAX 160

int Info_View_Pattern::color_values[] = {
    10, 20, 30,
    100, 200, 100,
    250, 250, 150,
    50, 60, 70,
    70, 80, 90,
    10, 50, 10,
    15, 80, 15,
    250, 250, 250,
    150, 150, 150,
    210, 210, 210,
    250, 180, 130,
    70, 110, 70,

};

void Info_View_Pattern::allocate_colormap () {

	int i;

	for (i=0;i<Max_Colors*3;i+=3) {

		colors[i/3].red = color_values[i] * 0xFFFF / 0xFF;
		colors[i/3].green = color_values[i+1] * 0xFFFF / 0xFF;
		colors[i/3].blue = color_values[i+2] * 0xFFFF / 0xFF;
	        get_colormap().alloc(colors[i/3]);
	}

}

gint Info_View_Pattern::do_expose_event(GdkEventExpose* p0) {

	if (editor==NULL) {

		return 0;
	}

	queue_draw();

	return 0;

}

void Info_View_Pattern::realize_impl() {

	int i;

	Gdk_WindowAttr attributes;
        int attributes_mask;

	set_flags(GTK_REALIZED|GTK_CAN_FOCUS|GTK_HAS_GRAB);

	attributes->x=gtkobj()->allocation.x;
	attributes->y=gtkobj()->allocation.y;
	attributes->width = width();
	attributes->height = height();
	attributes->wclass = GDK_INPUT_OUTPUT;
	attributes->window_type = GDK_WINDOW_CHILD;
	attributes->event_mask = get_events () | GDK_EXPOSURE_MASK;
	attributes->visual = get_visual ();
	attributes->colormap = get_colormap ();	

	attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;

	window.create(get_parent_window(), attributes, attributes_mask);
	gtkobj()->window=window;

	expose_event.connect(slot(this,&Info_View_Pattern::do_expose_event));

	allocate_colormap();

       	for (i=0;i<Max_Colors;i++) {

		GC[i].create(get_window());
		GC[i].set_foreground(colors[i]);
	}

	GC[Col_BackGround].set_exposures(1);
	window.set_user_data(gtkobj());
	window.set_background(colors[Col_BackGround]);

}

void Info_View_Pattern::print_single_row(int rowofs) {

	int current_pattern;
	int current_row;
	int diff,i,j;
	char tmpnum[4]={' ','0','0',0};


	diff=rowofs-(get_visible_rows()/2);

	if (rowofs==0) {
	
		int tmpcol;

	        window.draw_rectangle(GC[Col_Row_Hilite_Major],true,0,rowofs*get_row_height(),width(),get_row_height());
		for (j=window_offset;j<PATTERN_WIDTH;j++) {

			i=j-window_offset;
			tmpnum[1]='0'+(j+1)/10;
			tmpnum[2]='0'+(j+1)%10;

			if (j==editor->get_visual_channel()) {

				tmpcol=editor->is_channel_muted(j)?Col_ForeGround:Col_ForeGround_Selected;
			} else {

				tmpcol=editor->is_channel_muted(j)?Col_BackGround:Col_SepChannels;
        		}

			window.draw_string(font,GC[tmpcol],(get_font_width()*4)+(get_font_width()*3)*i,rowofs*get_row_height()+get_font_height(),tmpnum);

		}

		return;
	} else {

	        window.draw_rectangle(GC[Col_BackGround],true,0,rowofs*get_row_height(),width(),get_row_height());

		if (diff==0) {

			window.draw_rectangle(GC[Col_ForeGround_Selected],false,0,rowofs*get_row_height(),width(),get_row_height()-1);
		}

	}

        current_row=player->get_current_row();
	current_pattern=player->get_current_pattern();
	current_row=current_row+diff;

	
        if (!player->is_playing()) return;


	if (current_row<0) {

	        if (player->get_play_mode()==Player_Data::PLAY_PATTERN) return;

         	if ((player->get_current_order()>0) && (song->get_order(player->get_current_order()-1)<MAX_PATTERNS)) {

			current_pattern=song->get_order(player->get_current_order()-1);
			current_row=song->get_pattern(current_pattern)->get_length()+current_row;
			if (current_row<0) return; // yay, you have a big monitor, dude!

		} else {

			return;
		}
	} else if (current_row>=song->get_pattern(current_pattern)->get_length()) {

		return; // you certainly have a big monitor
	}

	for (j=window_offset;j<PATTERN_WIDTH;j++) {

		i=j-window_offset;
		string tmpstr;
	        Note note=song->get_pattern(current_pattern)->get_note(j,current_row);
		int color=Col_ForeGround;

		window.draw_rectangle(GC[Col_SepChannels],true,(get_font_width()*4)+(get_font_width()*3)*i,rowofs*get_row_height(),1,get_row_height());

		if (note.note!=EMPTY_FIELD) {

			tmpstr=editor->get_pattern_note_string(note);

		} else if (note.command!=EMPTY_FIELD) {


			tmpstr=editor->get_pattern_command_string(note);
			color=Col_Mask;
		} else if (note.volume!=EMPTY_FIELD) {

			tmpstr=editor->get_pattern_volume_string(note);

		} else if (note.instrument!=EMPTY_FIELD) {

			tmpstr=editor->get_pattern_instrument_string(note);
			color=Col_Mask;

		} else {

			//tmpstr="...";
			continue;
		}

		window.draw_string(font,GC[color],(get_font_width()*4)+(get_font_width()*3)*i,rowofs*get_row_height()+get_font_height(),tmpstr);
        }
}



void Info_View_Pattern::print_rows() {

	int i;
        int draw_from=1;
	int visible_columns=(width()-(4*get_font_width()))/(3*get_font_width());
	int draw_to=get_visible_rows();
	int diff=0;
	
        if (!is_drawable()) return;

	if (editor->get_visual_channel()<window_offset) window_offset=editor->get_visual_channel();
	if (editor->get_visual_channel()>(window_offset+visible_columns)-1) window_offset=(editor->get_visual_channel()-visible_columns)+1;

	print_single_row(0);

	if (old_pattern==player->get_current_pattern()) {

		diff=player->get_current_row()-old_pos;

	        if ((diff==0) && draw_part) return; //why bothering!
        	
	}

	window.draw_rectangle(GC[Col_BackGround],false,0,(get_visible_rows()/2)*get_row_height(),width(),get_row_height()-1);

	if (!player->is_playing()) {

		old_pattern=-1;
		diff=0;
	} else if (diff>0) {

		int start_point=get_row_height()+(diff*get_row_height());

                if (start_point<height()) {
		
	         	window.copy_area(GC[Col_BackGround],0,get_row_height(),window,0,start_point,width(),height()-start_point);
			draw_from=get_visible_rows()-diff;
		}

	}

	window.draw_rectangle(GC[Col_ForeGround_Selected],false,0,(get_visible_rows()/2)*get_row_height(),width(),get_row_height()-1);
	for (i=draw_from;i<draw_to;i++) {

		print_single_row(i);
		if (i==(get_visible_rows()/2)) {

			window.draw_rectangle(GC[Col_ForeGround_Selected],false,0,i*get_row_height(),width(),get_row_height()-1);
		}

	}


	old_pattern=player->get_current_pattern();
        old_pos=player->get_current_row();
        draw_part=false;
}


void Info_View_Pattern::draw_impl(GdkRectangle* p0){


      	if (editor==NULL) return;
	
	print_rows();

}

void Info_View_Pattern::link_to_editor(Editor *p_editor) {

	editor=p_editor;
	font.load("-adobe-courier-bold-r-normal--*-120-*-*-*-*-*-*");

}

int Info_View_Pattern::get_font_width() {

	return font.string_width("X");

}

int Info_View_Pattern::get_font_height() {

	return font.ascent()+font.descent();

}

int Info_View_Pattern::get_row_height() {

	return get_font_height()+1;

}


int Info_View_Pattern::get_visible_rows() {

	return height()/get_row_height();

}


void Info_View_Pattern::link_to_player(Player_Data *p_player) {
	
        player=p_player;
}
void Info_View_Pattern::link_to_song(Song *p_song) {

	song=p_song;
}

Info_View_Pattern::Info_View_Pattern(){

        old_pattern=1;
	window_offset=0;
	player=NULL;
	editor=NULL;
	draw_part=false;
}
Info_View_Pattern::~Info_View_Pattern(){
}
