/***************************************************************************
                          interface_update_misc.cpp  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"
#include "X11/Xlib.h"
#include "gdk/gdkx.h"

bool Interface::xlib_key_is_pressed(int key) {

	char key_array[32];
	int code;

	code=XKeysymToKeycode(GDK_DISPLAY(),key);
	XQueryKeymap(GDK_DISPLAY(),(char*)key_array);
        return (key_array[code / 8] & (1 << (code % 8)))!=0;
}

void Interface::update_info_widgets() {
        widgets_update_freq=spinbutton__config_interface_repaint->get_value_as_int();

	if ((update_freq_counter++) % widgets_update_freq) return;

	update_main_editing_entries();


	sample_view_samples_current.redraw_update();
	envelope_instruments_volume.redraw_update();
	envelope_instruments_pan.redraw_update();
	envelope_instruments_frequency.redraw_update();

	if (player->is_playing()) {

		tracker.update_info_areas(player->get_current_row(),player->get_current_pattern());
	} else {

		tracker.update_info_areas(0,-1);
	}
        update_message();

	if (song_follow_mode) {

		if (player->get_current_pattern()!=editor.get_current_pattern()) {

			 editor.set_current_pattern(player->get_current_pattern());
		}

		editor.set_cursor_y(player->get_current_row());
		tracker.queue_draw();    	
	}

	view_data.queue_draw();
	view_pattern.draw_part=true;
	view_pattern.draw_impl(NULL);

	update_counter++;
}

void Interface::update_message() {

	char aux_msg_buffer[200];
	int aux_playing_channels;

	aux_playing_channels=player->get_voices_used();
	
	aux_msg_buffer[0]='.';
	aux_msg_buffer[1]=0;

	if (message_time_left_counter) {

		message_time_left_counter--;
		sprintf(aux_msg_buffer,"%s",message_bar.c_str());

	} else if (player->is_playing()) {

		if (player->get_play_mode()==Player_Data::PLAY_SONG) {

			sprintf(aux_msg_buffer,"Playing, Order: %i/%i, Pattern %i, Row %i/%i, %i Channels.",player->get_current_order(),song->get_used_orders_amount(),player->get_current_pattern(),player->get_current_row(),song->get_pattern(player->get_current_pattern())->get_length(),aux_playing_channels);
		} else {

			sprintf(aux_msg_buffer,"Playing, Pattern %i, Row %i/%i, %i Channels.",player->get_current_pattern(),player->get_current_row(),song->get_pattern(player->get_current_pattern())->get_length(),aux_playing_channels);
		}

	} else if (aux_playing_channels>0) {

		sprintf(aux_msg_buffer,"Playing, %i Channels.",aux_playing_channels);

	}



	entry_main_upper.set_text(aux_msg_buffer);

}
void Interface::update_redrawable_widgets() {

	sample_view_samples_current.set_redraw_all();
	envelope_instruments_volume.set_redraw_all();
	envelope_instruments_pan.set_redraw_all();
	envelope_instruments_frequency.set_redraw_all();

	sample_view_samples_current.queue_draw();
	envelope_instruments_volume.queue_draw();
	envelope_instruments_pan.queue_draw();
	envelope_instruments_frequency.queue_draw();

}
void Interface::set_message(string p_msg,int p_time) {

	message_time_left_counter=p_time;
	message_bar=p_msg;
}

void Interface::update_all_widgets() {


	update_main_all_entries();

	update_clist_samples_list();

	update_selected_sample_info();

	update_clist_instrments_names();

	update_selected_instrument_info();

	update_volume_pan_list();

	update_variables();

	update_redrawable_widgets();

        update_config_widgets();
}

gint Interface::delete_event_impl(GdkEventAny* p_event) {


	Dialog_OkCancel *confirm_quit;
	confirm_quit=new Dialog_OkCancel("You are about to quit!\nAre you sure?",*kit);

	if (confirm_quit->get_action()==Dialog_OkCancel::OK) {

	 	quit_request=true;		
	}

	delete confirm_quit;

	return 1;
}