/***************************************************************************
                          mixer.h  -  description
                             -------------------
    begin                : Tue Apr 17 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIXER_H
#define MIXER_H

#include "typedefs.h"
#include "sample_data.h"

/**Abstract base class representing a mixer
  *@author Juan Linietsky
  */



/******************************
 mixer.h
 ----------

Abstract base class for the mixer.
This is what the player uses to setup
voices and stuff.. this way
it can be abstracted to hardware
devices!
********************************/


class Player_Data;

class Mixer {
public: 
	/* Needed for Software Mixers */
	virtual Uint32 write_bytes(Sint8* buf,Uint32 todo) =0;
        virtual void link_player_data(Player_Data *p_player_data) =0;
	virtual void request_player_data() =0;
	/* External Control (player/program)*/
	virtual void setup_voice(int p_voice_index,Sample_Data *p_sample_data,Sint32 p_start_index) =0;
	virtual void stop_voice(int p_voice_index) =0;
	virtual void set_voice_frequency(int p_voice_index,Uint32 p_freq) =0;
	virtual void set_voice_panning(int p_voice_index,int p_pan) =0;
	virtual void set_voice_volume(int p_voice_index,int p_vol) =0;
	virtual void set_number_of_channels(int p_numb_channels) =0;
        virtual void set_voice_vibrato(int p_voice_index,int p_speed,int p_depth)=0;
        virtual void set_voice_filter(int p_voice_index,Sint32 p_coef1, Sint32 p_coef2,Sint32 p_coef3,bool p_enabled)=0;
        virtual void set_voice_reverb_send(int p_voice_index,int p_reverb)=0;

        virtual void set_reverb_enabled(bool p_enabled) {};
        virtual bool is_reverb_enabled() { return false; };
        virtual void set_reverb_params(char p_room_size, char p_damp, char p_wet, char p_dry, char p_width) {};
     //   virtual void set_voice_filter(int p_voice_index,int p_speed,int p_depth)=0;

	/* External Control (sound driver)*/
	virtual void set_mix_frequency(int p_mix_frequency) =0;
        virtual void set_mix_stereo(bool p_mix_stereo) =0;
        virtual void set_mix_16bits(bool p_mix_16bits) =0;
	
	/* Info retrieving */	
	virtual Sint32 get_voice_sample_pos_index(int p_voice_index) =0;
	virtual int get_voice_panning_pos(int p_voice_index) =0;
	virtual int get_voice_volume(int p_voice_index) =0;
	virtual Sample_Data *get_voice_sample_data_ptr(int p_voice_index) =0;
	virtual bool is_voice_stopped(int p_voice_index) =0;	
        virtual int get_number_of_channels()=0;
	virtual int get_mix_frequency() =0;
	
	virtual bool is_song_playing() { return true; }
	virtual bool has_song_finished() { return false; }

	Mixer();
	virtual ~Mixer();
};

#endif
