/***************************************************************************
                          interface_widget_sample_view.cpp  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_widget_sample_view.h"


int Sample_View::color_values[] = {
    10, 20, 30,
    250, 100, 100,
    250, 250, 250,
    200, 100, 250
};


void Sample_View::allocate_colormap () {

	Gdk_Color tmpcolor;
	int i;

	for (i=0;i<Max_Colors*3;i+=3) {

                //tmpcolor=colors[i/3];
		//tmpcolor=colors[i/3];

		colors[i/3].red = color_values[i] * 0xFFFF / 0xFF;
		colors[i/3].green = color_values[i+1] * 0xFFFF / 0xFF;
		colors[i/3].blue = color_values[i+2] * 0xFFFF / 0xFF;
	        get_colormap().alloc(colors[i/3]);
	}

}

void Sample_View::realize_impl() {

	Gdk_WindowAttr attributes;
        int attributes_mask;
	int i;

	set_flags(GTK_REALIZED);

	attributes->x=0;
	attributes->y=0;
	attributes->width = width();
	attributes->height = height();
	attributes->wclass = GDK_INPUT_OUTPUT;
	attributes->window_type = GDK_WINDOW_CHILD;
	attributes->event_mask = get_events () | GDK_EXPOSURE_MASK;
	attributes->visual = get_visual ();
	attributes->colormap = get_colormap ();	

	attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;


	window.create(get_parent_window(), attributes, attributes_mask);
	gtkobj()->window=window;

	expose_event.connect(slot(this,&Sample_View::do_expose_event));

	allocate_colormap();


	for (i=0;i<Max_Colors;i++) {

		GC[i].create(get_window());
		GC[i].set_foreground(colors[i]);

	}

	GC[Col_BackGround].set_exposures(1);
	window.set_user_data(gtkobj());
	window.set_background(colors[Col_BackGround]);

}

gint Sample_View::do_expose_event(GdkEventExpose* p0) {

        redraw_all=true;
	draw_sample();
	return 0;

}

Uint16 Sample_View::get_height_at_pos(int s_position,int p_height_max) {

	Sint32 tmp_val=0;
	Sint8 * sample_8bits;
	Sint16 * sample_16bits;

	

	if ((s_position>=0) && (s_position<sample->size) && (p_height_max>0)) {

		if (sample->is_16bits==0) {

			(void*)sample_8bits=sample->data_ptr;

			tmp_val=sample_8bits[s_position];
			tmp_val+=128;
			tmp_val=255-tmp_val;
			tmp_val=(tmp_val*p_height_max)/255;

		} else {

			(void*)sample_16bits=sample->data_ptr;
			tmp_val=sample_16bits[s_position];
			tmp_val+=32768;
			tmp_val=65535-tmp_val;
			tmp_val=(tmp_val*p_height_max)/65535;
		}

	}

	return tmp_val;

}

void Sample_View::recalculate() {

	int i,current_pos,old_pos,j;

	int new_width=width();

	int max,min,aux;
	
	if (table_max!=NULL) free(table_max);
	if (table_min!=NULL) free(table_min);
	if (frames_played!=NULL) free(frames_played);
	(void*)table_max=malloc(new_width*2);
	(void*)table_min=malloc(new_width*2);
	(void*)frames_played=malloc(new_width);
        memset(frames_played,0,width());
	

	old_pos=-1;

	for (i=0;i<sample->size;i++) {

		current_pos=i*new_width/sample->size;

		if (current_pos>old_pos) {

			if ( (old_pos>=0) && (current_pos>=0) && (current_pos<new_width) ) {
		

				for (j=0;j<(current_pos-old_pos);j++) {

	                		table_min[old_pos+j]=min;
	                		table_max[old_pos+j]=max;
                                }

				max=-1;
				min=900000;
			}

			old_pos=current_pos;
		}

		//accum+=get_percentage_at_pos(i);
		//count++;
                aux=get_height_at_pos(i,height());
		if (aux<min) min=aux;
		if (aux>max) max=aux;
		

	}

	if ( (old_pos>=0) && (old_pos<new_width) ) {

		table_min[old_pos]=min;
		table_max[old_pos]=max;
	}


	need_recalculation=false;

}


void Sample_View::draw_position(int pos) {

	int min,max;
	int i=pos;

	

	max=table_max[i];
	min=table_min[i];
	

	//sort of interpolate
	if (i>0) {

		if (max<(table_min[i-1]-1)) max=table_min[i-1]-1;
		if (min>(table_max[i-1]+1)) min=table_max[i-1]+1;
	}


	max++; //so when the difference between min/max is 0, we can se at least a dot

	if ( ( sample->loop_on ) &&
             ( (i==(sample->loop_begin*width()/sample->size)) ||
	      ((unsigned)i==(sample->loop_end*width()/sample->size)) ||
      	      (((unsigned)i==width()-1) && (sample->loop_end==sample->size)) //[[TODO]] fix this heh :)
	    )) {

		window.draw_rectangle(GC[Col_Loop_BackGround],TRUE,i,0,1,height());
		window.draw_rectangle(GC[Col_Loop_ForeGround],TRUE,i,min,1,(max-min));

	} else if (frames_played[i]>0) {

		window.draw_rectangle(GC[Col_BackGround],TRUE,i,0,1,height());
		window.draw_rectangle(GC[Col_Loop_ForeGround],TRUE,i,0,1,height());

	} else {
		window.draw_rectangle(GC[Col_BackGround],TRUE,i,0,1,height());
		window.draw_rectangle(GC[Col_ForeGround],TRUE,i,min,1,(max-min));
	}

}

void Sample_View::draw_sample() {

	int i;
//        window.draw_rectangle(GC[Col_BackGround],TRUE,0,0,width()-1,height()-1);

	if ((sample==NULL) || (sample->data_ptr==NULL) || (sample->size<1)) {

				
		window.draw_rectangle(GC[Col_BackGround],TRUE,0,0,width(),height());
		return;
	}

	if ( (old_width!=width()) || (old_height!=height()) ) need_recalculation=true;


	// normalize positions previously drawn played
	if (!need_recalculation && !redraw_all) {

		for(i=0;i<width();i++) {

			if (frames_played[i]) {

				frames_played[i]=0;
				draw_position(i);	
			}

		}
	}

	if (need_recalculation) recalculate();

	//calculate if any of the positions if being played
	if (mixer!=NULL) {

		for (i=0;i<mixer->get_number_of_channels();i++) {

	         	if (mixer->get_voice_sample_data_ptr(i)==sample) {

				int dest;

				dest=mixer->get_voice_sample_pos_index(i);

				if ((dest>=0) &&(dest<sample->size)) {

	               			frames_played[dest*width()/sample->size]=1;
				}
			}
		}
	}
	
	// redraw
	for(i=0;i<width();i++) {

		if ((redraw_all) || (frames_played[i])) {

			draw_position(i);	
		}
	}

	old_width=width();
	old_height=height();
	redraw_all=false;
}


Sample_View::Sample_View(){

	redraw_all=true;
	sample=NULL;
	table_min=NULL;
	table_max=NULL;
	frames_played=NULL;
        mixer=NULL;
	need_recalculation=true;
}
Sample_View::~Sample_View(){


}
