/***************************************************************************
                          interface_widget_envelope.cpp  -  description
                             -------------------
    begin                : Sun Mar 25 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_widget_envelope.h"
#include <stdio.h>
int Envelope_Editor::color_values[] = {
    10, 20, 30,
    250, 100, 100,
    250, 250, 250,
    210, 210, 250
};


void Envelope_Editor::allocate_colormap () {

	Gdk_Color tmpcolor;
	int i;

	for (i=0;i<Max_Colors*3;i+=3) {

                //tmpcolor=colors[i/3];
		//tmpcolor=colors[i/3];

		colors[i/3].red = color_values[i] * 0xFFFF / 0xFF;
		colors[i/3].green = color_values[i+1] * 0xFFFF / 0xFF;
		colors[i/3].blue = color_values[i+2] * 0xFFFF / 0xFF;
	        get_colormap().alloc(colors[i/3]);
	}

}

void Envelope_Editor::realize_impl() {

	Gdk_WindowAttr attributes;
        int attributes_mask;
	int i;

        set_flags(GTK_REALIZED|GTK_CAN_FOCUS|GTK_HAS_GRAB);

	attributes->x=gtkobj()->allocation.x;
	attributes->y=gtkobj()->allocation.y;
	attributes->width = width();
	attributes->height = height();
	attributes->wclass = GDK_INPUT_OUTPUT;
	attributes->window_type = GDK_WINDOW_CHILD;
	attributes->event_mask = get_events () | GDK_EXPOSURE_MASK;
	attributes->visual = get_visual ();
	attributes->colormap = get_colormap ();	

	attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;

	window.create(get_parent_window(), attributes, attributes_mask);
	gtkobj()->window=window;

	expose_event.connect(slot(this,&Envelope_Editor::do_expose_event));

	allocate_colormap();


	for (i=0;i<Max_Colors;i++) {

		GC[i].create(get_window());
		GC[i].set_foreground(colors[i]);

	}

	GC[Col_BackGround].set_exposures(1);
	window.set_user_data(gtkobj());
	window.set_background(colors[Col_BackGround]);

}

gint Envelope_Editor::do_expose_event(GdkEventExpose* p0) {

        redraw_all=true;
	draw_envelope();
	return 0;

}

Sint16 Envelope_Editor::get_height_at_pos(int e_position,int p_height_max) {

        int heightpos,max;

	heightpos=envelope->get_height_at_pos(e_position*100/zoom_amount);

	if (heightpos==NO_ENVELOPE_POINT) {

		return NO_ENVELOPE_POINT;
	}

	max=envelope->get_max();
	
	if (envelope->is_signed()) {
         	
		heightpos+=max;
		max*=2;
	}


	heightpos=max-heightpos;	


       	return heightpos*p_height_max/max;

}

void Envelope_Editor::recalculate() {


	int new_width=width();

	if (frames_played!=NULL) free(frames_played);
	(void*)frames_played=malloc(new_width);
        memset(frames_played,0,width());

	need_recalculation=false;

}


void Envelope_Editor::draw_position(int pos) {

	int min,max,prev;
	int divide_y,real_x,old_real_x;	
	int real_node=-1;
	int i;


	max=get_height_at_pos(pos,height()-bottom_height);
	min=max;

        real_x=pos*100/zoom_amount;
	old_real_x=(pos-1)*100/zoom_amount;

	for (i=0;i<envelope->node_count;i++) if (envelope->node[i].tick_offset==real_x) real_node=i;
	
	i=pos;

	if ( (real_x!=old_real_x) && (envelope->loop_on) && ((real_node==envelope->loop_begin_node) || (real_node==envelope->loop_end_node)) ) {

		window.draw_rectangle(GC[Col_Loop_BackGround],TRUE,i,0,1,height()-bottom_height);

	} else if ( (real_x!=old_real_x) && (envelope->sustain_loop_on) && ((real_node==envelope->sustain_loop_begin_node) || (real_node==envelope->sustain_loop_end_node)) ) {


		window.draw_rectangle(GC[Col_Loop_BackGround],TRUE,i,0,1,height()-bottom_height);

	} else if (frames_played[i]) {

		window.draw_rectangle(GC[Col_ForeGround],TRUE,i,0,1,height()-bottom_height);
	} else {

		window.draw_rectangle(GC[Col_BackGround],TRUE,i,0,1,height()-bottom_height);
	}

	if (envelope->is_signed()) {
		
		divide_y=(height()-bottom_height)/2;
	} else {

		divide_y=(height()-bottom_height)-3;
	}

	if  (real_x!=old_real_x) {

        	if (real_x % 50==0) {

			window.draw_rectangle(GC[Col_Loop_BackGround],TRUE,pos,divide_y-5,1,7);

		} else if (real_x % 10==0) {

			window.draw_rectangle(GC[Col_Loop_BackGround],TRUE,pos,divide_y-3,1,5);

		} else if (zoom_amount>=200) {

			window.draw_rectangle(GC[Col_Loop_BackGround],TRUE,pos,divide_y-1,1,3);
		} else {

			window.draw_rectangle(GC[Col_Loop_BackGround],TRUE,pos,divide_y,1,1);
		}

	} else {

		window.draw_rectangle(GC[Col_Loop_BackGround],TRUE,pos,divide_y,1,1);
	}


//	} else {

//				window.draw_rectangle(GC[Col_Loop_BackGround],FALSE,(i*zoom_amount/100),divide_y-1,0,2);
//	}


	if (max==NO_ENVELOPE_POINT) {


		return;
	}

	// Make sure we draw a continuous line
	if (i>0) {
		prev=get_height_at_pos(i-1,height()-bottom_height);
		if (max<(prev-1)) max=prev-1;
		if (min>(prev+1)) min=prev+1;
	}

	max++;	
	window.draw_rectangle(GC[Col_ForeGround],TRUE,i,min,1,(max-min));
}

void Envelope_Editor::draw_envelope() {

	int i;
	int tmp_index;

//        window.draw_rectangle(GC[Col_BackGround],TRUE,0,0,width()-1,height()-1);

	if (envelope==NULL) return;

	if ( (old_width!=width()) || (old_height!=height()) ) need_recalculation=true;


	// normalize positions previously drawn played
	if (!need_recalculation && !redraw_all) {

		for(i=0;i<width();i++) {

			if (frames_played[i]) {

				frames_played[i]=0;
				draw_position(i);	
			}
		}
	}

	if (need_recalculation) recalculate();

	//calculate if any of the positions is being played

	for (i=0;i<player->get_voice_amount_limit();i++) {

         	if ( (tmp_index=player->get_voice_envelope_pos(i,envelope))!=-1 ) {

			int dest;
			dest=tmp_index*zoom_amount/100;

			if ((dest>=0) &&(dest<width())) {

				frames_played[dest]=1;
			}
		}
	}

	// redraw
	for(i=0;i<width();i++) {

		if ((redraw_all) || (frames_played[i])) {

			draw_position(i);	
		}
	}

	draw_points();

	if (redraw_all) {

		char envelope_info_text[100];
		window.draw_rectangle(GC[Col_BackGround],TRUE,0,height()-bottom_height,width(),bottom_height);
		sprintf(envelope_info_text,"Node %i/%i - Tick %i, Value %i. Zoom: %i%%",grab_point_number+1,envelope->node_count,envelope->node[grab_point_number].tick_offset,envelope->node[grab_point_number].value,zoom_amount);
		window.draw_string(font,GC[Col_Loop_BackGround],0,height()-3,envelope_info_text);

	}

	old_width=width();
	old_height=height();
	redraw_all=false;
}

// widget -> envelope conversion

int Envelope_Editor::get_envelope_pos_x(int p_posx) {

	return p_posx*100/zoom_amount;	
}

int Envelope_Editor::get_envelope_pos_y(int p_posy) {

	int new_y,max;

	max=envelope->get_max();

	if (envelope->is_signed()) max*=2;

	new_y=p_posy*max/(height()-bottom_height);

	new_y=envelope->get_max()-new_y;

	return new_y;
}


int Envelope_Editor::get_point_x(int p_node) {

	 return envelope->node[p_node].tick_offset*zoom_amount/100;
}

int Envelope_Editor::get_point_y(int p_node) {

        int heightpos,max;

	heightpos=envelope->node[p_node].value;

	max=envelope->get_max();
	
	if (envelope->is_signed()) {
         	
		heightpos+=max;
		max*=2;
	}

	heightpos=max-heightpos;	

	return heightpos*(height()-bottom_height)/max;
}

void Envelope_Editor::draw_points() {

	int i;

	for (i=0;i<envelope->node_count;i++) {

		int node_x,node_y;

		node_x=get_point_x(i);
		node_y=get_point_y(i);
		if (i==grab_point_number) {

			window.draw_rectangle(GC[Col_Loop_BackGround],FALSE,node_x-2,node_y-2,5,5);
		}else {

			window.draw_rectangle(GC[Col_Loop_ForeGround],FALSE,node_x-1,node_y-2,3,3);
		}
	}


}
void Envelope_Editor::attempt_node_grab(int p_node_x,int p_node_y) {


        int i;

	grabbing_point=false;

	// check if we can grab an existing node
	for (i=0;i<envelope->node_count;i++) {

		int node_x,node_y,dist;
		node_x=get_point_x(i);
		node_y=get_point_y(i);

		dist=(int)sqrt((p_node_x-node_x)*(p_node_x-node_x)+(p_node_y-node_y)*(p_node_y-node_y));

                if (dist<6) {

			grabbing_point=true;
			grab_point_number=i;
			grab_x=node_x;
			grab_y=node_y;
               }

	}
	
	// if not.. let's see if we can create it
	if (!grabbing_point) {

		if ( (i=envelope->add_position(get_envelope_pos_x(p_node_x),get_envelope_pos_y(p_node_y)))>=0 ) {

			grabbing_point=true;
			grab_point_number=i;
		}
	}

	redraw_all=true;
	queue_draw();

}

gint Envelope_Editor::button_release_event_impl(GdkEventButton* event) {

        zooming=false;
        grabbing_point=false;
	return 0;

}

gint Envelope_Editor::enter_notify_event_impl(GdkEventCrossing* event) {

        zooming=false;
	grabbing_point=false;
	return 0;

}

gint Envelope_Editor::leave_notify_event_impl(GdkEventCrossing* event) {

        zooming=false;
	grabbing_point=false;
	return 0;

}
gint Envelope_Editor::motion_notify_event_impl(GdkEventMotion* event) {

	if (grabbing_point) {


		envelope->set_position(grab_point_number,get_envelope_pos_x(event->x),get_envelope_pos_y(event->y));
		redraw_all=true;
		queue_draw();
		
	}

	if (zooming) {

		int newzoom;

		newzoom=zoom_original+(grab_x-event->x)*10;

		if (newzoom<10) newzoom=10;
		if (newzoom>2000) newzoom=2000;
                zoom_amount=newzoom;
                redraw_all=true;
		need_recalculation=true;
		queue_draw();

	}

	return 1;

}

void Envelope_Editor::start_zoom(int x, int y) {

	zooming=true;
	grab_x=x;
	grab_y=y;
	zoom_original=zoom_amount;
	need_recalculation=true;

}
void Envelope_Editor::delete_selected_node() {

	if (grab_point_number>=0) envelope->del_position(grab_point_number);

}


Envelope_Editor::Envelope_Editor(){

	redraw_all=true;
	envelope=NULL;
	frames_played=NULL;
	need_recalculation=true;
	zoom_amount=100;
	grabbing_point=false;

        font.load("-adobe-courier-bold-r-normal--*-140-*-*-*-*-*-*");
        font_height=font.ascent()+font.descent();
	bottom_height=font_height+8;
}
Envelope_Editor::~Envelope_Editor(){
}
