/***************************************************************************
                          sound_driver_diskwrite.cpp  -  description
                             -------------------
    begin                : Mon Mar 4 2002
    copyright            : (C) 2002 by red
    email                : red@server
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "sound_driver_diskwrite.h"

int Sound_Driver_DiskWrite::get_mix_frequency() {

	return mix_frequency;
}
bool Sound_Driver_DiskWrite::get_mix_stereo() {

	return mix_stereo;

}
bool Sound_Driver_DiskWrite::get_mix_16bits() {


	return true;
}
int Sound_Driver_DiskWrite::get_mix_buffer_size() {

	return SAVE_BUFFER_SIZE*2;
}

string Sound_Driver_DiskWrite::get_name() {

	return "Wave Writer";
}

int Sound_Driver_DiskWrite::init() {

	finished_dump=false;
	began_saving=false;
	mix_16bits=true;
}

bool Sound_Driver_DiskWrite::finish() {

	if ((began_saving) && (!finished_dump))  end_dump();
}

bool Sound_Driver_DiskWrite::is_active() {

	return true;
}


void Sound_Driver_DiskWrite::start_dump() {

	string fname="dump.wav";

	if (writer.open(fname.c_str())) return ;
	
	cout << "saving to " << fname << endl;
	
//	int DataLen = smp->data.size * (smp->data.is_16bits ? 2 : 1);

	writer.store_byte_array( (Uint8*) "RIFF", 4 );

 	head_len_pos=writer.get_file_pos();	
	writer.store_dword(0xFFFFFFF + 24 + 4);
	
	writer.store_byte_array( (Uint8*) "WAVE", 4 );

	writer.store_byte_array( (Uint8*) "fmt ", 4 );
	writer.store_dword(0x10);
	writer.store_word(0x01); // always 0x01
	writer.store_word(mix_stereo? 2 : 1); // number of channels
	writer.store_dword(mix_frequency); // sample rate
	writer.store_dword(mix_frequency*(mix_16bits  ? 2 : 1)); // bytes per second
	writer.store_word(mix_16bits ? 2 : 1); // bytes per samp
	writer.store_word(mix_16bits ? 16 : 8); // bits per sample

	writer.store_byte_array( (Uint8*) "data", 4 );

 	
 	data_len_pos=writer.get_file_pos();
   	writer.store_dword(0xFFFFFFF);

	written=0;	
//	writer.store_byte_array( (Uint8*)smp->data.data_ptr , smp->data.size*(smp->data.is_16bits?2:1) );
	
	mixer->set_mix_frequency(mix_frequency);
	mixer->set_mix_stereo(mix_stereo);
	mixer->set_mix_16bits(mix_16bits);

}
void Sound_Driver_DiskWrite::end_dump() {

	
        writer.set_file_pos(head_len_pos);
	writer.store_dword(written + 24 + 4);
        writer.set_file_pos(data_len_pos);
	writer.store_dword(written);
	
	writer.close();


}



bool Sound_Driver_DiskWrite::update() {

        if (finished_dump) return false;

	for (int i=0;i<500;i++) {

	        if (mixer->is_song_playing()) {
	
			if (mixer->has_song_finished()) {
			
				end_dump();	
				finished_dump=true;	
			} else {
			
				int savec,j;
				if (!began_saving) {
				
				 	start_dump();
				}
				
				savec=mixer->write_bytes((Sint8*)save_buffer,SAVE_BUFFER_SIZE);
				for (j=0;j<SAVE_BUFFER_SIZE/(mix_stereo?2:1);j++)
					writer.store_word(save_buffer[j]);
				written+=SAVE_BUFFER_SIZE*2;
			}	
	        }
	}	
}



Sound_Driver_DiskWrite::Sound_Driver_DiskWrite(){
}
Sound_Driver_DiskWrite::~Sound_Driver_DiskWrite(){
}
