/***************************************************************************
                          interface_widget_visual1.h  -  description
                             -------------------
    begin                : Sun May 6 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_WIDGET_VISUAL1_H
#define INTERFACE_WIDGET_VISUAL1_H

#include <gtk--/widget.h>
#include <gtk--/window.h>

#include "editor.h"
#include "player_data.h"

/**
  *@author Juan Linietsky
  */


class Info_View_Data : public Gtk::Widget {

	/* Color info */

	enum Info_View_Data_Colormap {

		Col_BackGround,
		Col_ForeGround,
		Col_Cursor,
		Col_Row_Hilite_Minor,
		Col_Row_Hilite_Major,
		Col_BackGround_Selected,
		Col_Row_Hilite_Selected,
		Col_ForeGround_Selected,
		Col_SepChannels,
		Col_SepNewChannels,
		Col_Mask,
		Col_ForeGround_Inactive,
		Max_Colors
	};

	static int color_values[];

       	Gdk_Color colors[Max_Colors];
	void allocate_colormap ();

	Gdk_GC	GC[Max_Colors];

	/* Font */
 	Gdk_Font font;

	void print_single_row(int rowofs);
	void print_rows();


        int get_row_height();
        int get_visible_rows();
        int get_font_height();
	int get_font_width();

	Editor *editor;
	Player_Data *player;

	int window_offset;
	Gdk_Window window;


public:

	// Events/overrides
	void realize_impl();
	gint do_expose_event(GdkEventExpose* p0);
	void draw_impl(GdkRectangle* p0);
        gint button_press_event_impl(GdkEventButton* p0) {

		grab_focus(); // is this the best way to do it? I cant figure it out!

		return 0;
	}
	void link_to_editor(Editor *p_editor);
	void link_to_player(Player_Data *p_player);

	Info_View_Data();
	~Info_View_Data();
};

#endif
