/***************************************************************************
                          interface_update_config.cpp  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"

void Interface::update_config_widgets() {

        config_page_updating_in_progress=true;

	{
		gchar *empty_strings[1]={""};
		int i;

		clist_config_sound_driver_name.freeze();
		clist_config_sound_driver_name.clear();


		for (i=0;i<driver_manager->get_amount_of_drivers();i++) {

			clist_config_sound_driver_name.append(empty_strings);
        		clist_config_sound_driver_name.set_text(i,0,driver_manager->get_driver_name(i));
		}
		clist_config_sound_driver_name.thaw();
                clist_config_sound_driver_name.set_column_justification(0, GTK_JUSTIFY_LEFT);
	}

	{
		gchar *empty_strings[1]={""};
		int i;

		clist_config_mixer_proc.freeze();
		clist_config_mixer_proc.clear();


		for (i=0;i<software_mixer->get_amount_of_mixer_procedures();i++) {

			clist_config_mixer_proc.append(empty_strings);
        		clist_config_mixer_proc.set_text(i,0,software_mixer->get_mixer_procedure_name(i));
		}
		clist_config_mixer_proc.thaw();
                clist_config_mixer_proc.set_column_justification(0, GTK_JUSTIFY_LEFT);

	}
	{
		gchar *empty_strings[2]={"",""};
		int i;
                clist_config_keyboard_type.freeze();
                clist_config_keyboard_type.clear();


		for (i=0;i<KEY_MAX_KEYS;i++) {
                        char keyz[4]={'\'','.','\'',0};
			
   			clist_config_keyboard_type.append(empty_strings);
			keyz[1]=(char)key_assign[i];
        		clist_config_keyboard_type.set_text(i,0,keyz);
        		clist_config_keyboard_type.set_text(i,1,key_names[i]);
		}
		clist_config_keyboard_type.thaw();
                clist_config_keyboard_type.set_column_justification(0, GTK_JUSTIFY_LEFT);

	}

        checkbutton_config_enable_filters.set_active(player->are_filters_enabled());

	entry_main_font_name.set_text(fontname);
	entry_main_song_path->set_text(song_path);
	entry_main_data_path->set_text(data_path);
   	
    	config_reverb_parms[0]->get_adjustment()->set_value(reverb.room);
     	config_reverb_parms[1]->get_adjustment()->set_value(reverb.damp);
     	config_reverb_parms[2]->get_adjustment()->set_value(reverb.wet);
       	config_reverb_parms[3]->get_adjustment()->set_value(reverb.dry);
 	config_reverb_parms[4]->get_adjustment()->set_value(reverb.width);

        config_page_updating_in_progress=false;
	update_sound_driver_widgets();



}

void Interface::set_fonts() {
	
 	font.load(fontname);
	tracker.set_font(&font);
 	

}


void Interface::update_sound_driver_widgets() {

	#define SET_SPIN_MAX(spinbtn,maxval) tmp_adjustment=spinbtn->get_adjustment(); tmp_adjustment->set_upper(maxval); spinbtn->set_adjustment(tmp_adjustment)
	Gtk::Adjustment *tmp_adjustment;

        char tmp_string[20];
	config_page_updating_in_progress=true;

	entry_config_sound_status.set_text((driver_manager->is_active_driver_active()?"Active":"Disabled"));
        checkbutton_config_stereo.set_active(driver_manager->get_mix_stereo());
        checkbutton_config_16bits.set_active(driver_manager->get_mix_16bits());
	sprintf(tmp_string,"%i",driver_manager->get_mix_frequency());
	combo_config_frequency.get_entry()->set_text(tmp_string);
	sprintf(tmp_string,"%i (%ims)",driver_manager->get_mix_buffer_size(),driver_manager->get_mix_buffer_size()*1000/driver_manager->get_mix_frequency());
	combo_config_buffersize.get_entry()->set_text(tmp_string);
        SET_SPIN_MAX(spinbutton_config_virtual_channels,player->get_mixer_ptr()->get_number_of_channels());
        spinbutton_config_virtual_channels->set_value(player->get_virtual_channels());

	config_page_updating_in_progress=false;

}