/***************************************************************************
                          editor_commands.cpp  -  description
                             -------------------
    begin                : Thu Jan 25 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "editor.h"
#include <stdio.h>

void Editor::cursor_move_up(int amount) {

        int limit;

	limit=0;

	cursor_y-=amount;
	if (cursor_y<0) cursor_y=0;

	shift_selection_update();

	set_flag_redraw_row();

}

void Editor::cursor_move_up() {

	cursor_move_up(cursor_spacing);
}

void Editor::cursor_move_down(int amount) {

        int limit;

	limit=song->get_pattern(current_pattern)->get_length()-1;

	cursor_y+=amount;

	if (cursor_y>limit) cursor_y=limit;

        shift_selection_update();
	set_flag_redraw_row();
}

void Editor::cursor_move_down() {

	cursor_move_down(cursor_spacing);	
}

void Editor::cursor_move_left(int amount) {

	cursor_x-=amount;
	if (cursor_x<0) cursor_x=0;
	shift_selection_update();
	set_flag_redraw_row();

}

void Editor::cursor_move_right(int amount) {

	cursor_x+=amount;
	if (cursor_x>=PATTERN_WIDTH) cursor_x=PATTERN_WIDTH-1;
	shift_selection_update();
	set_flag_redraw_row();
}


void Editor::cursor_move_field_right() {

	
	cursor_field++;
	if (cursor_field>=FIELDS_MAX) {

		if (cursor_x==PATTERN_WIDTH-1) cursor_field=FIELDS_MAX-1;
		else {
		
			cursor_move_right(1);
			cursor_field=0;
		}
	}

	shift_selection_update();
	set_flag_redraw_row();

}

void Editor::cursor_move_field_left() {

	
	cursor_field--;
	if (cursor_field<0) {

		if (cursor_x==0) cursor_field=0;
		else {
		
			cursor_move_left(1);
			cursor_field=FIELDS_MAX-1;
		}
	}

	shift_selection_update();
	set_flag_redraw_row();
}

void Editor::cursor_page_up() {

	cursor_move_up(song->variables.row_highlight_major);

}


void Editor::cursor_page_down() {

	cursor_move_down(song->variables.row_highlight_major);
}


void Editor::cursor_home() {

	if (cursor_field>0) {

		cursor_field=0;

	} else if (cursor_x>0) {

		cursor_x=0;
		cursor_field=0;
		
	} else {

		cursor_y=0;
	}

	shift_selection_update();
}

void Editor::cursor_end() {

	if (cursor_field<FIELDS_MAX-1) {

		cursor_field=FIELDS_MAX-1;

	} else if (cursor_x<PATTERN_WIDTH-1) {

		cursor_x=PATTERN_WIDTH-1;
		cursor_field=FIELDS_MAX-1;

	} else {

		cursor_y=song->get_pattern(current_pattern)->get_length()-1;
	}

	shift_selection_update();
}


void Editor::cursor_tab() {

	cursor_move_right(1);
	cursor_field=0;

}

void Editor::cursor_back_tab() {

	shift_selection_end();

	if (cursor_field==0) cursor_move_left(1);
	else cursor_field=0;

}


void Editor::cursor_next_pattern() {

	cursor_goto_pattern(current_pattern+1);

}

void Editor::cursor_prev_pattern() {

	cursor_goto_pattern(current_pattern-1);
}

void Editor::cursor_goto_pattern(int p_pattern) {
	
	if ((p_pattern<0) || (p_pattern>=MAX_PATTERNS)) return;

       	char tmp_reason[20];
       	sprintf(tmp_reason,"Pattern %i",current_pattern);
       	current_pattern=p_pattern;
	push_current_pattern_to_undo_list(tmp_reason);
       	normalize_selection();
}

void Editor::cursor_insert() {

	int i,limit;
	Note aux_note;
	limit=song->get_pattern(current_pattern)->get_length()-1;


	for(i=limit;i>cursor_y;i--) {

		aux_note=song->get_pattern(current_pattern)->get_note(cursor_x,i-1);
		song->get_pattern(current_pattern)->get_note_ref(cursor_x,i)=aux_note;
	}

	CURRENT_NOTE_SET.clear();
}

void Editor::cursor_delete() {

	int i,limit;
	
	Note aux_note;
	limit=song->get_pattern(current_pattern)->get_length()-1;

        for(i=cursor_y;i<limit;i++) {

		aux_note=song->get_pattern(current_pattern)->get_note(cursor_x,i+1);
		song->get_pattern(current_pattern)->get_note_ref(cursor_x,i)=aux_note;
//		song->get_pattern(current_pattern)->note_ref(cursor_x,i)=song->get_pattern(current_pattern)->note_ref(cursor_x,i+1);

	}

	song->get_pattern(current_pattern)->get_note_ref(cursor_x,limit).clear();

}




void Editor::toggle_mask_at_cursor() {

	switch (cursor_field) {

		case 2:
		case 3:{ instrument_mask=!instrument_mask; } break;
		case 4:
		case 5:{ volume_mask=!volume_mask; } break;
		case 6:
		case 7:
		case 8:{ command_mask=!command_mask; } break;
	}

}

void Editor::clear_field_at_cursor() {

	switch (cursor_field) {

		case 0:{

			CURRENT_NOTE_SET.note=EMPTY_FIELD;
			if (volume_mask) CURRENT_NOTE_SET.volume=EMPTY_FIELD;
			if (instrument_mask) CURRENT_NOTE_SET.instrument=EMPTY_FIELD;
			if (command_mask) CURRENT_NOTE_SET.command=EMPTY_FIELD;
			last_note=CURRENT_NOTE_GET.note;

		} break;
		case 1: break;
		case 2:
		case 3:{

			CURRENT_NOTE_SET.instrument=EMPTY_FIELD;
			last_instrument=EMPTY_FIELD;
		} break;
		case 4:
		case 5:{

			CURRENT_NOTE_SET.volume=EMPTY_FIELD;
			last_volume=EMPTY_FIELD;;
		} break;
			
		case 6: {

			CURRENT_NOTE_SET.command=EMPTY_FIELD;
			last_command=CURRENT_NOTE_GET.command;
			last_parameter=CURRENT_NOTE_GET.parameter;
		} break;
		case 7:
		case 8:{

			CURRENT_NOTE_SET.parameter=0;
			last_command=CURRENT_NOTE_GET.command;
			last_parameter=CURRENT_NOTE_GET.parameter;
		} break;
	}

	cursor_move_down();

}


// keyboard internationalization
int Editor::get_note_increment(char key) {

	//fixme: internationaliza it! :D

	int i;
	int tmpval=99;

	for (i=0;i<MAX_NOTE_INCR;i++) if (note_increments[i]==key) tmpval=i;

	return tmpval;

}


void Editor::default_octave_raise() {

	default_octave++;
	default_octave=BOUND(default_octave,0,9);

}

void Editor::default_octave_lower() {

	default_octave--;
	default_octave=BOUND(default_octave,0,9);


}
char Editor::get_default_octave() {

	return default_octave;
}


