/***************************************************************************
                          mixer_software_control.cpp  -  description
                             -------------------
    begin                : Wed Apr 18 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mixer_software.h"
#include <stdio.h>

void Mixer_Software::setup_voice(int p_voice_index,Sample_Data *p_sample_data,Sint32 p_start_index) {


	if (p_sample_data==NULL) {

		ERROR("p_sample_data is null!!");
		return;
	}

	if (p_start_index<0) {
         	ERROR("start index < 0???");
		return;
	}

	if (p_start_index>=p_sample_data->size) {

		if (p_sample_data->loop_on) {

			ERROR("Sample offset in loop not implemented!");

		} else {

			return;
		}
	}
			

	channel[p_voice_index]->sample_data_ptr=p_sample_data;
	channel[p_voice_index]->start_index=p_start_index;
	channel[p_voice_index]->needs_restart=true;
	//channel[p_voice_index]->oldlvol=0; // avoid clicking
	//channel[p_voice_index]->oldrvol=0;
	
}

void Mixer_Software::stop_voice(int p_voice_index) {


	channel[p_voice_index]->active=false;
}
void Mixer_Software::set_voice_frequency(int p_voice_index,Uint32 p_freq) {

	channel[p_voice_index]->current_frequency=p_freq;
}
void Mixer_Software::set_voice_panning(int p_voice_index,int p_pan) {


	channel[p_voice_index]->panning=p_pan;

}

/* 0 - 255 */
void Mixer_Software::set_voice_reverb_send(int p_voice_index,int p_reverb) {

	channel[p_voice_index]->reverb_send=p_reverb;

}

bool Mixer_Software::is_voice_stopped(int p_voice_index) {

	return !channel[p_voice_index]->active;
}
void Mixer_Software::set_voice_volume(int p_voice_index,int p_vol) {


	channel[p_voice_index]->volume=p_vol;
}
void Mixer_Software::set_voice_filter(int p_voice_index,Sint32 p_coef1, Sint32 p_coef2,Sint32 p_coef3,bool p_enabled) {


	channel[p_voice_index]->filter_coef1=p_coef1;
	channel[p_voice_index]->filter_coef2=p_coef2;
	channel[p_voice_index]->filter_coef3=p_coef3;
	channel[p_voice_index]->filter_enabled=p_enabled;	

	if (!p_enabled) {
	
		channel[p_voice_index]->filter_history1=0;
		channel[p_voice_index]->filter_history2=0;	
	}
}

Sint32 Mixer_Software::get_voice_sample_pos_index(int p_voice_index) {

	if (channel[p_voice_index]->active) {

		return channel[p_voice_index]->current_index >> FRACBITS;

	} else {

         	return -1;
	}

}
int Mixer_Software::get_number_of_channels() {

	return mix_channels;
}

Sample_Data* Mixer_Software::get_voice_sample_data_ptr(int p_voice_index) {

	if (channel[p_voice_index]->active) {

		return channel[p_voice_index]->sample_data_ptr;

	} else {

         	return NULL;
	}

}

bool Mixer_Software::is_song_playing() {


	return (player_data->get_play_mode()==Player_Data::PLAY_SONG);
		

}
bool Mixer_Software::has_song_finished() {

	return player_data->reached_end_of_song();
}

int Mixer_Software::get_voice_panning_pos(int p_voice_index) {

	if (channel[p_voice_index]->active) {

		return channel[p_voice_index]->panning;

	} else {

         	return -1;
	}


}

void Mixer_Software::set_reverb_enabled(bool p_enabled) {

	do_reverb=p_enabled;
}

bool Mixer_Software::is_reverb_enabled() {

	return do_reverb;
}
void Mixer_Software::set_reverb_params(char p_room_size, char p_damp, char p_wet, char p_dry, char p_width) {

        reverb.setroomsize((float)p_room_size/127.0);
        reverb.setdamp((float)p_damp/127.0);
	reverb.setwet((float)p_wet/127.0);
	reverb.setdry((float)p_dry/127.0);
	reverb.setwidth((float)p_width/127.0);
	reverb.setmode(0);
}

int Mixer_Software::get_voice_volume(int p_voice_index) {

	if (channel[p_voice_index]->active) {

		return channel[p_voice_index]->volume;

	} else {

         	return -1;
	}


}