/***************************************************************************
                          mutex_lock_pthreads.h  -  description
                             -------------------
    begin                : Sun Mar 18 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MUTEX_LOCK_PTHREADS_H
#define MUTEX_LOCK_PTHREADS_H

#include "mutex_lock.h"
#include <pthread.h>

/**
  *@author Juan Linietsky
  */

/******************************
 mutex_lock_pthread.h
 ------------------------

pthreads version of mutex locking
********************************/

class Mutex_Lock_Pthreads : public Mutex_Lock  {

	pthread_mutex_t internal_mutex;

public:

	void grab() {

        	pthread_mutex_lock(&internal_mutex);
	};
	void release() {

        	pthread_mutex_unlock(&internal_mutex);
	};

	Mutex_Lock_Pthreads();
	~Mutex_Lock_Pthreads();
};

#endif
