#
# 	Fonctions de conversions variees
# 	(c) 1995-7 Alexandre Burton
# 	v. 1.80a (10/08/97)
#

proc floatToScreenX { xFloat } {  
	global limite
	expr ($xFloat * $limite(rangeX)) + $limite(pad)
}

proc floatToScreenY { yFloat } {
    	global limite relation
    	expr (abs($yFloat-1) * $limite(rangeY)) + $limite(pad)	
}

proc screenToFloatX { xScreen } {
    	global limite
    	expr ($xScreen - $limite(pad)) / $limite(rangeX)
}

proc screenToFloatY { yScreen } {
    	global limite
    	expr abs((($yScreen - $limite(pad)) / $limite(rangeY)) -1)
}

proc paramToFloat {param cible} {
    	global seuil ambitus actif relation tcl_precision
    	if {$cible == "actif"} {set cible $actif}
    	switch -glob -- $relation($cible) {
		li* {
		    return [expr 1.0 * (($param - $seuil($cible)) / $ambitus($cible))]
		}
		ra* {
		    return [expr 1.0 * (($param - $seuil($cible)) / $ambitus($cible))]
		}
		lo* { 	
		    set tcl_precision 12
		    set val [expr 1.0* log10($param/$seuil($cible)) / log10(1.0*($seuil($cible)+$ambitus($cible))/$seuil($cible))] 
		    set tcl_precision 6
		    return $val
		}
		default { bell ;  puts "$relation($cible)?????" }
    	}
}

proc floatToParam {float cible} {
    global limite ambitus seuil relation fenetre pad
    switch -glob -- $relation($cible) {
	li* {
	    set param [expr ($float  * $ambitus($cible)) + $seuil($cible)]
	}
	ra* {
	    set param [expr ($float  * $ambitus($cible)) + $seuil($cible)]
	}
	lo* { 	
	    set param [expr pow(($ambitus($cible)+$seuil($cible))/$seuil($cible),$float )* $seuil($cible) ]
	}
	default { bell ;  puts "$relation($cible)?????" }
    }
	set param [format %.5f $param]	
    return $param 
}

proc timeToFloat {time} {
    global soundOutInfo value 
    if {![info exists soundOutInfo(duree)]} {return "-"}
    expr 1.0 * $time / $soundOutInfo(duree)
}

proc floatToTime {float cible} {
    global soundOutInfo tcl_precision value
    if {![info exists soundOutInfo(duree)]} {return "-"}
    set tcl_precision 6
    set time [expr $float * $soundOutInfo(duree)] 
    set tcl_precision 10
    return $time
}

proc floatToTable {float cible} {
    global tableSize tcl_precision gensize soundOutInfo
    if ![info exists gensize($cible)] {
	set tableSize $soundOutInfo(userGEN)
    } else {
	set tableSize $gensize($cible)
    }
    set table [expr $float * $tableSize]
    set table [format %.3f $table]
    return $table    
}

proc getMaxY { stuff } {
    array set dataCourant $stuff
    set maxY 0
    foreach x [array names dataCourant] {
	if {$dataCourant($x) > $maxY} {set maxY $dataCourant($x)}
    }
   return $maxY
}

proc getMinY { stuff } {
    array set dataCourant $stuff
    set minY 1
    foreach x [array names dataCourant] {
	if {$dataCourant($x) < $minY} {set minY $dataCourant($x)}
    }
    return $minY
}

proc rawrand {} {
    global lastvalue
    set lastvalue [expr (46965277*$lastvalue+13849)%65536]
	return $lastvalue	
}
