(**************************************************************************)
(*  The CDuce compiler                                                    *)
(*  Alain Frisch <Alain.Frisch@inria.fr> and the CDuce team               *)
(*  Copyright CNRS,INRIA, 2003,2004 (see LICENSE for details)             *)
(**************************************************************************)

open Ident 
open Lambda

type env
val global_size: env -> int
val from_comp_unit: (Types.CompUnit.t -> env) ref

val dump: Format.formatter -> env -> unit

val empty : Types.CompUnit.t -> env
val empty_toplevel : env
val serialize: env Serialize.Put.f
val deserialize: env Serialize.Get.f

val find : id -> env -> var_loc
val find_slot : id -> env -> int

val compile_expr : env -> Typed.texpr -> Lambda.expr


val comp_unit:
  ?run:bool ->
  ?show:(id option -> Types.t -> Value.t option -> unit) ->
  ?loading:(Types.CompUnit.t -> unit) ->
  ?directive:(Typer.t -> env -> Ast.toplevel_directive -> unit) ->

  Typer.t -> env -> Ast.pmodule_item list -> 
  Typer.t * env * Lambda.code_item list
