/***************************************************************************
                          FakePropertiesDialog.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef FAKEPROPERTIESDIALOG_H
#define FAKEPROPERTIESDIALOG_H

#include <qvariant.h>
#include <qdialog.h>

#include "FakeFolderItem.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QButtonGroup;
class QCheckBox;
class QFrame;
class QLabel;
class QLineEdit;
class QPushButton;


class FakePropertiesDialog : public QDialog
{
    Q_OBJECT

public:
    FakePropertiesDialog(FakeFolderItem *item, FileEntry *entry, QWidget* parent = 0, const char* name = 0);
    FakePropertiesDialog(FakeFolderItem *item, QWidget* parent = 0, const char* name = 0);
     FakePropertiesDialog(FakeFolderItem *item, FakeFoldersList *foldersList, FakeFileEntriesList *entriesList,
     							QWidget* parent = 0, const char* name = 0);

    ~FakePropertiesDialog();

signals:
	void applied();
	void canceled();

protected slots:
	void okSlot();
	void cancelSlot();

protected:

    QPushButton* okBtn;
    QPushButton* cancelBtn;
    QFrame* baseFrm;
    QLabel* typeRepLbl;
    QLineEdit* nameTxt;
    QLabel* nameLbl;
    QLabel* typeLbl;
    QFrame* iconFrm;
    QLabel* iconImg;
    QFrame* Line1;
    QLabel* locationLbl;
    QLabel* locationRepLbl;
    QLabel* sizeRepLbl;
    QLabel* sizeLbl;
    QLabel* origLocationLbl;
    QLabel* origLocationRepLbl;
    QFrame* Line2;
    QButtonGroup* visibFrm;
    QCheckBox* rrChk;
    QCheckBox* joiletChk;
    QCheckBox* hfsChk;
        QCheckBox* applToSubdirChk;
	QGridLayout* FakePropertiesDialogLayout;
    QGridLayout* baseFrmLayout;
    QHBoxLayout* iconFrmLayout;
    QVBoxLayout* visibFrmLayout;

	bool multiItems;
	
	FileEntry *thisEntry;
	FakeFolderItem *folderItem;
	FakeFoldersList *foldersList;
	FakeFileEntriesList *entriesList;

    QString formateSize(unsigned long);
    void init(bool editable = true);
    void initControls(double visibility, bool isDir, bool tristate = false);
    void initLabels(QString name, QPixmap icon, QString location, unsigned long size,
    						QString type, QString source, bool editable = true, bool highlite = false);
	bool applyVisibilityToFolder(FakeFolderItem *thisFolder, int v, bool addHFS, bool addJoi, bool addRR);
	bool renameFolder(QString n);
	bool applyNameToFile(FileEntry *entry, QString n);
	bool applyVisibilityToFile(FileEntry *entry, int v, bool addHFS, bool addJoi, bool addRR);
	
	double getTypeFromFolder(FakeFolderItem *item);
	double getTypeFromEntriesList(FakeFileEntriesList *entriesList, int *size);
	double getTypeFromFolderList(FakeFoldersList *foldersList, int *size);
};
#endif // FAKEPROPERTIESDIALOG_H

