/***************************************************************************
                          CdboFileItem.cpp  -  description
                             -------------------
    begin                : Mon Nov 19 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//#include <iostream.h>
// QT includes
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qlistview.h>
#include <qdatetime.h>
#include <qfileinfo.h>

// KDE includes
#include <kurl.h>
#include <klocale.h>

// app includes
#include "CdboFileItem.h"
#include "FileItem.h"
//==============================================
CdboFileItem::CdboFileItem(QListView * parent, QString path):QListViewItem(parent){
	this->path = path;
	sizeField = 1;
	nameField = 0;
	locationField = 4;
	modifiedField = 2;
	ownerField = 3;
}
//==============================================
CdboFileItem::CdboFileItem(CdboFileItem * parent, QString path):QListViewItem(parent){
	this->path = path;
	sizeField = 1;
	nameField = 0;
	locationField = 4;
	modifiedField = 2;
	ownerField = 3;
}
//=======================================
CdboFileItem::~CdboFileItem(){
}
//===========================================================
void CdboFileItem::init(){
	if(path == "topNodeInCDBOWithStrangePath"){
		pathToTop = "/";
		return;
	}
	QFileInfo d( path );
	
	name = d.fileName();
	
	if(path == "/"){
		name = "Root Directory (/)";
		setText(locationField, "");
	}
	else
		setText(locationField, d.dirPath());
		
	setText(nameField, name);
	
	setFileSize( (int)d.size());
	
	setText(modifiedField,d.lastModified().date().toString());
	setText(ownerField,d.owner());
}
//===========================================================
void CdboFileItem::setFileSize(int size) {
	this->size = size;
	QString buff;
	if(size < 1024)
		buff = QString::number(size) + "B";
	else if(size / 1024 < 1024)
		buff = QString::number(size / 1024) + "KB";
	else
		buff = buff.setNum( ((double)size) / 1024 / 1024, 'f', 1) + "MB";
	
	setText(sizeField,buff);
}
//=======================================
QString CdboFileItem::key ( int column, bool) const{
	
	if(column == sizeField){
		QString tmpString;
		tmpString.sprintf( "%08d", size );
		return tmpString;
	}
	if ( column == modifiedField) {
		QFileInfo d( path );
		QString tmpString;
		//QDateTime epoch(d.lastModified());
		QDateTime epoch( QDate( 1980, 1, 1 ) );
		tmpString.sprintf( "%08d", epoch.secsTo( d.lastModified() ) );
		return tmpString;
    }
	return text(column);
}