/***************************************************************************
                          AudioTreeCntPanel.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "AudioTreeCntPanel.h"

#include <qframe.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <kiconloader.h>

/* 
 *  Constructs a AudioTreeCntPanel which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
AudioTreeCntPanel::AudioTreeCntPanel( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    if ( !name )
	setName( "AudioTreeCntPanel" );
    resize( 34, 435 ); 
    setMaximumSize( QSize( 34, 3100 ) );
    setCaption( tr( "Form1" ) );
    AudioTreeCntPanelLayout = new QHBoxLayout( this ); 
    AudioTreeCntPanelLayout->setSpacing( 0 );
    AudioTreeCntPanelLayout->setMargin( 0 );

    Frame4 = new QFrame( this, "Frame4" );
    Frame4->setMaximumSize( QSize( 32, 32767 ) );
    Frame4->setFrameShape( QFrame::StyledPanel );
    Frame4->setFrameShadow( QFrame::Raised );
    Frame4Layout = new QVBoxLayout( Frame4 ); 
    Frame4Layout->setSpacing( 1 );
    Frame4Layout->setMargin( 1 );

    itemPropBtn = new QToolButton( Frame4, "itemPropBtn" );
    itemPropBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, itemPropBtn->sizePolicy().hasHeightForWidth() ) );
    itemPropBtn->setMinimumSize( QSize( 30, 31 ) );
    itemPropBtn->setMaximumSize( QSize( 30, 31 ) );
    itemPropBtn->setFocusPolicy( QToolButton::TabFocus );
    itemPropBtn->setText( tr( "" ) );
    itemPropBtn->setAutoRaise( TRUE );
    QToolTip::add(  itemPropBtn, tr( "View Item Properties." ) );
    itemPropBtn->setPixmap( UserIcon("file_properties", KIcon::SizeMedium ) );
    Frame4Layout->addWidget( itemPropBtn );

    deleteNodeBtn = new QToolButton( Frame4, "deleteNodeBtn" );
    deleteNodeBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, deleteNodeBtn->sizePolicy().hasHeightForWidth() ) );
    deleteNodeBtn->setMinimumSize( QSize( 30, 31 ) );
    deleteNodeBtn->setMaximumSize( QSize( 30, 31 ) );
    deleteNodeBtn->setFocusPolicy( QToolButton::TabFocus );
    deleteNodeBtn->setText( tr( "" ) );
    deleteNodeBtn->setAutoRaise( TRUE );

    deleteNodeBtn->setPixmap( BarIcon("edittrash", KIcon::SizeMedium ) );
    QToolTip::add(  deleteNodeBtn, tr( "Delete item." ) );
    Frame4Layout->addWidget( deleteNodeBtn );

    Line1_2_2_2 = new QFrame( Frame4, "Line1_2_2_2" );
    Line1_2_2_2->setMaximumSize( QSize( 32, 32767 ) );
    Line1_2_2_2->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    Frame4Layout->addWidget( Line1_2_2_2 );

    upBtn = new QToolButton( Frame4, "upBtn" );
    upBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, upBtn->sizePolicy().hasHeightForWidth() ) );
    upBtn->setMinimumSize( QSize( 30, 31 ) );
    upBtn->setMaximumSize( QSize( 30, 31 ) );
    upBtn->setFocusPolicy( QToolButton::TabFocus );
    upBtn->setText( tr( "" ) );
    upBtn->setAutoRaise( TRUE );
    upBtn->setPixmap( BarIcon("up", KIcon::SizeMedium ) );

    QToolTip::add(  upBtn, tr( "Move selected Item up." ) );
    Frame4Layout->addWidget( upBtn );

    downBtn = new QToolButton( Frame4, "downBtn" );
    downBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, downBtn->sizePolicy().hasHeightForWidth() ) );
    downBtn->setMinimumSize( QSize( 30, 31 ) );
    downBtn->setMaximumSize( QSize( 30, 31 ) );
    downBtn->setFocusPolicy( QToolButton::TabFocus );
    downBtn->setText( tr( "" ) );
    downBtn->setAutoRaise( TRUE );
    	downBtn->setPixmap( BarIcon("down", KIcon::SizeMedium ) );
    QToolTip::add(  downBtn, tr( "Move selected Item up." ) );
    Frame4Layout->addWidget( downBtn );

    Line1_2 = new QFrame( Frame4, "Line1_2" );
    Line1_2->setMaximumSize( QSize( 32, 32767 ) );
    Line1_2->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    Frame4Layout->addWidget( Line1_2 );

    isoPropBtn = new QToolButton( Frame4, "isoPropBtn" );
    isoPropBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, isoPropBtn->sizePolicy().hasHeightForWidth() ) );
    isoPropBtn->setMinimumSize( QSize( 30, 31 ) );
    isoPropBtn->setMaximumSize( QSize( 30, 31 ) );
    isoPropBtn->setFocusPolicy( QToolButton::TabFocus );
    isoPropBtn->setText( tr( "" ) );
    isoPropBtn->setAutoRaise( TRUE );
        isoPropBtn->setPixmap( UserIcon("isoSetup", KIcon::SizeMedium ) );
    QToolTip::add(  isoPropBtn, tr( "Edit Audio Settings." ) );
    Frame4Layout->addWidget( isoPropBtn );

    burnBtn = new QToolButton( Frame4, "burnBtn" );
    burnBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, burnBtn->sizePolicy().hasHeightForWidth() ) );
    burnBtn->setMinimumSize( QSize( 30, 31 ) );
    burnBtn->setMaximumSize( QSize( 30, 31 ) );
    burnBtn->setFocusPolicy( QToolButton::TabFocus );
    burnBtn->setText( tr( "" ) );
    burnBtn->setAutoRaise( TRUE );
        burnBtn->setPixmap( UserIcon("burn", KIcon::SizeMedium ) );
    QToolTip::add(  burnBtn, tr( "Burn a New Audio CD" ) );
    Frame4Layout->addWidget( burnBtn );

    Line1_2_2 = new QFrame( Frame4, "Line1_2_2" );
    Line1_2_2->setMaximumSize( QSize( 32, 32767 ) );
    Line1_2_2->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    Frame4Layout->addWidget( Line1_2_2 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Frame4Layout->addItem( spacer );
    AudioTreeCntPanelLayout->addWidget( Frame4 );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
AudioTreeCntPanel::~AudioTreeCntPanel()
{
    // no need to delete child widgets, Qt does it all for us
}

