/***************************************************************************
                          RecordOptPnl.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qspinbox.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qbuttongroup.h>
#include <qlineedit.h>

#include <kapp.h>
#include <ksimpleconfig.h>

#include "RecordOptPnl.h"


RecordOptPnl::RecordOptPnl( QWidget* parent,  const char* name, WFlags fl )
	:RecordOptPnlBase( parent, name, fl ){

	config = kapp->config();
	readOptions();
	 connect( useCustOptChk, SIGNAL( clicked() ), this, SLOT( useCustOptSlot() ) );
}

RecordOptPnl::~RecordOptPnl(){
}
void RecordOptPnl::readOptions(){
	////////////////////////////////////////////////////////////
	config->setGroup("Recording Options");
     bool buff = config->readBoolEntry("Eject Media At End", true);//
	ejectChk->setChecked(buff);
	
	buff = config->readBoolEntry("Check Drive First", false);///
	checkDriveChk->setChecked(buff);
	
	buff = config->readBoolEntry("Disk At Once", false);
	daoChk->setChecked(buff);
	
	buff = config->readBoolEntry("Fixate CD", true);
	fixateChk->setChecked(buff);
	
	buff = config->readBoolEntry("Burn Proof", false);
	burnProofChk->setChecked(buff);
	
	QString strBuff = config->readEntry("Media Catalog Number", "");
	if(strBuff != "")
		mcnTxt->setText(strBuff);
	
	buff = config->readBoolEntry("Use Custom Options", false);
	useCustOptChk->setChecked(buff);
	useCustOptSlot();
	
	///////// Custom Opt //////////////////////////////////
	strBuff = config->readEntry("FIFO Size", "");
	if(strBuff != "")
		fifoSizeTxt->setText(strBuff);
	buff = config->readBoolEntry("Use Inf Files", false);
	useInfChk->setChecked(buff);
	int iBuff = config->readNumEntry("Default Pregap", 0);
     defPregapSpn->setValue( iBuff );
	iBuff = config->readNumEntry("SCSI Time Out", 0);
     scsiTimeOutSpn->setValue( iBuff );
	strBuff = config->readEntry("Driver Name", "");
	if(strBuff != "")
		driverNameTxt->setText(strBuff);
	strBuff = config->readEntry("Driver Options", "");
	if(strBuff != "")
		driverOptTxt->setText(strBuff);
		
	///////////////Erase opt///////////////////////	
     config->setGroup("Erase options");
     buff = config->readBoolEntry("Dummy Erase", false);//
	dummyEraseChk->setChecked(buff);
	buff = config->readBoolEntry("Eject After Erase", true);//
	ejectEraseChk->setChecked(buff);
	buff = config->readBoolEntry("Check Drive First", false);//
	checkDriveEraseChk->setChecked(buff);
	
}
//-----------------------------------------------------------------------------------------------
void RecordOptPnl::saveOptions(){
	////////////////////////////////////////////////////////////
	config->setGroup("Recording Options");
     config->writeEntry("Eject Media At End", ejectChk->isChecked());
	config->writeEntry("Check Drive First", checkDriveChk->isChecked());
	config->writeEntry("Disk At Once", daoChk->isChecked());
	config->writeEntry("Fixate CD", fixateChk->isChecked());
	config->writeEntry("Burn Proof", burnProofChk->isChecked());
	config->writeEntry("Media Catalog Number",  mcnTxt->text());	
	config->writeEntry("Use Custom Options", useCustOptChk->isChecked());
	
	///////// Special Opt //////////////////////////////////
	config->writeEntry("FIFO Size", fifoSizeTxt->text());	
	config->writeEntry("Use Inf Files", useInfChk->isChecked());
	config->writeEntry("Default Pregap", defPregapSpn->value());
	config->writeEntry("SCSI Time Out", scsiTimeOutSpn->value());
	config->writeEntry("Driver Name", driverNameTxt->text());
	config->writeEntry("Driver Options", driverOptTxt->text());
	
	///////////////////////////////////////////////////	
     config->setGroup("Erase options");
     config->writeEntry("Dummy Erase", dummyEraseChk->isChecked());
	config->writeEntry("Eject After Erase", ejectEraseChk->isChecked());
	config->writeEntry("Check Drive First", checkDriveEraseChk->isChecked());
	config->sync();
}
//----------------------------------------------------------------------------------------------
void RecordOptPnl::applyDefaults(){
	KSimpleConfig *config = (KSimpleConfig *)(kapp->config());
	config->deleteGroup("Recording options");
	config->deleteGroup("Erase options");
	readOptions();
}
//------------------------------------------------------------------------------------------
void RecordOptPnl::useCustOptSlot(){
	custOptPnl->setEnabled(useCustOptChk->isChecked());
}




