/***************************************************************************
                          InfoPnl.h  -  description
                             -------------------
    begin                : Tue Jul 24 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef INFOPNL_H
#define INFOPNL_H

#include <qvariant.h>
#include <qwidget.h>

class QGridLayout; 
class QTextBrowser;

class KProcess;
class KShellProcess;
class KConfig;

class InfoPnl : public QWidget
{ 
    Q_OBJECT

public:
    InfoPnl( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~InfoPnl();
    void saveData();

protected slots:
	void gotName(KProcess *);
	void receivedName(KProcess *, char *, int);
	void gotCdrecordV(KProcess *);
	void receivedCdrecordV(KProcess *, char *, int);
	void gotMkisofsV(KProcess *);
	void receivedMkisofsV(KProcess *, char *, int);
	void gotCdparanoiaV(KProcess *);
	void receivedCdparanoiaV(KProcess *, char *, int);
	void gotCdda2wavV(KProcess *);
	void receivedCdda2wavV(KProcess *, char *, int);
	/*void gotOgg123V(KProcess *);
	void receivedOgg123V(KProcess *, char *, int);
	void gotMpg123V(KProcess *);
	void receivedMpg123V(KProcess *, char *, int);
*/

private:
	QString message;
	KConfig *config;
	
	void initData();
	
	void updateInfo();
	
	void getName();
	void getSystem();
	void getCdrecordV();
	void getMkisofsV();
	void getCdparanoiaV();
	void getCdda2wavV();
	/*void getMpg123V();
	void getOgg123V();
	*/
	
	//KShellProcess *cdboProc;
	KProcess *cdboProc;
	
	
	
	QString user;
	QString system;
	QString cdrecord;
	QString mkisofs;
	QString cdda2wav;
	QString cdparanoia;
	/*QString ogg123;
	QString mpg123;*/
	
    	QGridLayout* infoPnlLayout;
    	QTextBrowser* infoBrws;


};

#endif // INFOPNL_H
