/***************************************************************************
                          InfoPnl.cpp  -  description
                             -------------------
    begin                : Tue Jul 24 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// #include <iostream.h>

#include <qpushbutton.h>
#include <qtextbrowser.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qfile.h>

#include <klocale.h>
#include <kprocess.h>
#include <kconfig.h>
#include <kapp.h>

#include "InfoPnl.h"
#include "../../cdbakeoven.h"

/* 
 *  Constructs a InfoPnl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
InfoPnl::InfoPnl( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl ){

	//QPixmap image0( ( const char** ) image0_data );
	
	//image0.save("/home/shlomo/back.png", "PNG");
	
    if ( !name )
 		setName( "InfoPnl" );

	config = kapp->config(); 		
	
	user = "Unknown";
	system = "Unable to dermine";
	cdrecord ="cdrecord not available</B>"\
			" <font color=red>(recording not possible)</font><B>";
	mkisofs = "mkisofs not available</B>"\
				" <font color=red>(ISO creation not possible)</font><B>";
	cdda2wav = "Not Available";
	cdparanoia = "Not Available";
	/*mpg123 = "mpg123 not available</B>"\
				" <font color=red>(MP3 conversion not possible)</font><B>";
	ogg123 = "ogg123 not available</B>"\
				" <font color=red>(Ogg Vorbis conversion not possible)</font><B>";*/
	 		
     //resize( 506, 425 );
     QPalette pal;
     QColorGroup cg;
     cg.setColor( QColorGroup::Foreground, black );
     cg.setColor( QColorGroup::Button, QColor( 228, 228, 228) );
     cg.setColor( QColorGroup::Light, white );
     cg.setColor( QColorGroup::Midlight, QColor( 241, 241, 241) );
     cg.setColor( QColorGroup::Dark, QColor( 114, 114, 114) );
     cg.setColor( QColorGroup::Mid, QColor( 152, 152, 152) );
     cg.setColor( QColorGroup::Text, black );
     cg.setColor( QColorGroup::BrightText, white );
     cg.setColor( QColorGroup::ButtonText, black );
     cg.setColor( QColorGroup::Base, white );
     cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
     cg.setColor( QColorGroup::Shadow, black );
     cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
     cg.setColor( QColorGroup::HighlightedText, white );
     pal.setActive( cg );

     cg.setColor( QColorGroup::Foreground, black );
     cg.setColor( QColorGroup::Button, QColor( 228, 228, 228) );
     cg.setColor( QColorGroup::Light, white );
     cg.setColor( QColorGroup::Midlight, white );
     cg.setColor( QColorGroup::Dark, QColor( 114, 114, 114) );
     cg.setColor( QColorGroup::Mid, QColor( 152, 152, 152) );
     cg.setColor( QColorGroup::Text, black );
     cg.setColor( QColorGroup::BrightText, white );
     cg.setColor( QColorGroup::ButtonText, black );
     cg.setColor( QColorGroup::Base, white );
     cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
     cg.setColor( QColorGroup::Shadow, black );
     cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
     cg.setColor( QColorGroup::HighlightedText, white );
     pal.setInactive( cg );
     cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
     cg.setColor( QColorGroup::Button, QColor( 228, 228, 228) );
     cg.setColor( QColorGroup::Light, white );
     cg.setColor( QColorGroup::Midlight, white );
     cg.setColor( QColorGroup::Dark, QColor( 114, 114, 114) );
     cg.setColor( QColorGroup::Mid, QColor( 152, 152, 152) );
     cg.setColor( QColorGroup::Text, QColor( 128, 128, 128) );
     cg.setColor( QColorGroup::BrightText, white );
     cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
     cg.setColor( QColorGroup::Base, white );
     cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
     cg.setColor( QColorGroup::Shadow, black );
     cg.setColor( QColorGroup::Highlight, QColor( 0, 0, 128) );
     cg.setColor( QColorGroup::HighlightedText, white );
     pal.setDisabled( cg );
     setPalette( pal );
     setCaption( i18n( "Form1" ) );
     setAutoMask( true );
     setBackgroundOrigin( QWidget::WidgetOrigin );



     infoPnlLayout = new QGridLayout( this );
     infoPnlLayout->setSpacing( 6 );
     infoPnlLayout->setMargin( 11 );

	
     infoBrws = new QTextBrowser( this, "infoBrws" );
     infoBrws->setMinimumSize( QSize( 400, 0 ) );
     infoBrws->setMaximumSize( QSize( 32767, 800 ) );
	 cg.setColor( QColorGroup::Foreground, black );
     cg.setColor( QColorGroup::Button, QColor( 208, 223, 236) );
     cg.setColor( QColorGroup::Light, white );
     cg.setColor( QColorGroup::Midlight, QColor( 231, 239, 245) );
     cg.setColor( QColorGroup::Dark, QColor( 104, 112, 118) );
     cg.setColor( QColorGroup::Mid, QColor( 139, 148, 157) );
     cg.setColor( QColorGroup::Text, black );
     cg.setColor( QColorGroup::BrightText, white );
     cg.setColor( QColorGroup::ButtonText, black );
     cg.setColor( QColorGroup::Base, QColor( 208, 223, 236) );
     cg.setColor( QColorGroup::Background, QColor( 208, 223, 236) );
     cg.setColor( QColorGroup::Shadow, black );
     cg.setColor( QColorGroup::Highlight, QColor( 10, 95, 137) );
     cg.setColor( QColorGroup::HighlightedText, white );
     pal.setActive( cg );
     cg.setColor( QColorGroup::Foreground, black );
     cg.setColor( QColorGroup::Button, QColor( 208, 223, 236) );
     cg.setColor( QColorGroup::Light, white );
     cg.setColor( QColorGroup::Midlight, QColor( 241, 248, 255) );
     cg.setColor( QColorGroup::Dark, QColor( 104, 112, 118) );
     cg.setColor( QColorGroup::Mid, QColor( 139, 148, 157) );
     cg.setColor( QColorGroup::Text, black );
     cg.setColor( QColorGroup::BrightText, white );
     cg.setColor( QColorGroup::ButtonText, black );
     cg.setColor( QColorGroup::Base, QColor( 208, 223, 236) );
     cg.setColor( QColorGroup::Background, QColor( 208, 223, 236) );
     cg.setColor( QColorGroup::Shadow, black );
     cg.setColor( QColorGroup::Highlight, QColor( 10, 95, 137) );
     cg.setColor( QColorGroup::HighlightedText, white );
     pal.setInactive( cg );
     /*cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
     cg.setColor( QColorGroup::Button, QColor( 208, 223, 236) );
     cg.setColor( QColorGroup::Light, white );
     cg.setColor( QColorGroup::Midlight, QColor( 241, 248, 255) );
     cg.setColor( QColorGroup::Dark, QColor( 104, 112, 118) );
     cg.setColor( QColorGroup::Mid, QColor( 139, 148, 157) );
     cg.setColor( QColorGroup::Text, black );
     cg.setColor( QColorGroup::BrightText, white );
     cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
     cg.setColor( QColorGroup::Base, QColor( 208, 223, 236) );
     cg.setColor( QColorGroup::Background, QColor( 208, 223, 236) );
     cg.setColor( QColorGroup::Shadow, black );
     cg.setColor( QColorGroup::Highlight, QColor( 10, 95, 137) );
     cg.setColor( QColorGroup::HighlightedText, white );
     pal.setDisabled( cg );
     */
     infoBrws->setPalette( pal );
     infoBrws->setBackgroundOrigin( QTextBrowser::ParentOrigin );
     infoBrws->setFrameShape( QTextBrowser::NoFrame );
     infoBrws->setFrameShadow( QTextBrowser::Plain );
     infoBrws->setVScrollBarMode( QTextBrowser::AlwaysOff );
     infoBrws->setHScrollBarMode( QTextBrowser::AlwaysOff );
 //infoBrws->setText("<br>\n<center><big><B>Welcome to CD Bake Oven 1.6.1</B></big>\n</center>\n<br>\n<B>Introduction</B>\n<BR><BR>This dialog provides you with total control over every step\nof the CD-Creation process.  You must have sufficient access rights to the tools nessesary for Cd Bake Oven to function properly. Following is an overview of you system, and it's capabilities. \n<BR><BR>\n<table>\n<tr>\n   <td>\n      User:\n   </td>\n   <td>\n      <B>shlomo</B>\n   </td>\n   </tr>\n   <tr>\n   <td>\n      System:\n   </td>\n   <td>\n      <B>Linux Mandrake8.0</B>\n   </td>\n   </tr>\n   <tr>\n   <td>\n      cdrecord:\n   </td>\n   <td>\n      <B>Not Available</B> <font color=red>(recording not possible)</font>\n   </td>\n   </tr>\n   <tr>\n   <td>\n      mkisofs:\n   </td>\n   <td>\n      <B>Not Detected</B>\n   </td>\n   </tr>\n   <tr>\n   <td>\n      cdda2wav:\n   </td>\n   <td>\n      <B>Not Detected</B>\n   </td>\n   </tr>\n   <tr>\n   <td>\n      cdparanoia:\n   </td>\n   <td>\n      <B>Not Detected</B>\n   </td>\n   </tr>\n</table>\n\n<BR><BR>Use tabs on the left side to browse current settings.");
	updateInfo();
	infoBrws->setTextFormat( QTextBrowser::RichText );

     infoPnlLayout->addWidget( infoBrws, 1, 0 );

     QSpacerItem* spacer = new QSpacerItem( 30, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
     infoPnlLayout->addItem( spacer, 1, 1 );
	
	initData();
	/*getCdrecordV();
	getMkisofsV();
	getSystem();
	getCdparanoiaV();
	getCdda2wavV();*/
}

/*  
 *  Destroys the object and frees any allocated resources
 */
InfoPnl::~InfoPnl(){

}
//==============================================
void InfoPnl::initData(){
	/////////////////////////////////////////
	config->setGroup("Default Settings");		
    	bool bBuff = config->readBoolEntry("Dont Check Sys", true);
	
	config->setGroup("System Settings");	
	user = config->readEntry("User Name", "Unknown");
	if(user == "Unknown" || !bBuff){
		getName();
		getCdrecordV();
		getMkisofsV();
		getSystem();
		getCdparanoiaV();
		getCdda2wavV();
		//getOgg123V();
		//getMpg123V();
	}
	else{
		system = config->readEntry("System", "Unable to dermine");
		cdrecord = config->readEntry("cdrecord Version", "cdrecord not available</B>"\
			" <font color=red>(recording not possible)</font><B>");
		mkisofs = config->readEntry("mkisofs Version", "mkisofs not available</B>"\
				" <font color=red>(ISO creation not possible)</font><B>");
		cdda2wav = config->readEntry("cdda2wav Version", "Not Available");
		cdparanoia = config->readEntry("cdparanoia Version", "Not Available");
		/*mpg123 = config->readEntry("mpg123 Version", "mpg123 not available</B>"\
				" <font color=red>(MP3 conversion not possible)</font><B>");
		ogg123 = config->readEntry("ogg123 Version", "ogg123 not available</B>"\
				" <font color=red>(Ogg Vorbis conversion not possible)</font><B>");*/
		updateInfo();
	}
}
//==============================================
void InfoPnl::saveData(){
	///////////////////////////////////////////////////
	config->setGroup("System Settings");		
    	
	config->writeEntry("User Name", user);
	config->writeEntry("System", system);
	config->writeEntry("cdrecord Version", cdrecord);
	config->writeEntry("mkisofs Version", mkisofs);
	config->writeEntry("cdda2wav Version", cdda2wav);
	config->writeEntry("cdparanoia Version", cdparanoia);
	/*config->writeEntry("mpg123 Version", mpg123);
	config->writeEntry("ogg123 Version", ogg123);*/

}
//==============================================
void InfoPnl::updateInfo(){
	message = "<center><big><B>Welcome to CD Bake Oven " + QString(VERSION) +"</B></big>\n"\
		"</center>\n<!--br>\n<B>Introduction</B>\n<BR--><BR>"\
		"This dialog provides you with total control over every step\n"\
		"of the CD-Creation process.  You must have sufficient access rights"\
		" to the tools necessary for CD Bake Oven to function properly. "\
		"The following is an overview of your system, and it's capabilities. \n<BR><BR>\n"\
		"<table>\n<tr>\n "\
		"  <td>\n      "\
		"User:\n   </td>\n   <td>\n      <B>" + user + "</B>\n"\
		"   </td>\n   </tr>\n   <tr>\n   <td>\n "\
		"     System:\n   </td>\n   <td>\n"\
		"      <B>" + system + "</B>\n   </td>\n"\
		"   </tr>\n   "\
		"<tr>\n   <td colspan=2><center><B><u>Tools:</u></b></center></td></tr>"\
		"   <tr><td>\n      recording:\n"\
		"   </td>\n   <td>\n      <B>" + cdrecord + "</B>\n"\
		"   </td>\n   </tr>\n"\
		"   <tr>\n   <td>\n"\
		"     ISO:\n   </td>\n   <td>\n"\
		"      <B>" + mkisofs + "</B>\n   </td>\n   </tr>\n"\
		"   <tr>\n   <td>\n      cdda2wav:\n"\
		"   </td>\n   <td>\n      <B>" + cdda2wav + "</B>\n"\
		"   </td>\n   </tr>\n   <tr>\n   <td>\n"\
		"      cdparanoia:\n   </td>\n   <td>\n "\
		"     <B>" + cdparanoia + "</B>\n   </td>\n"\
		"   </tr>"\
		/*"\n   <tr>\n   <td>\n"\
		"      MP3:\n   </td>\n   <td>\n "\
		"     <B>" + mpg123 + "</B>\n   </td>\n"\
		"   </tr>\n   <tr>\n   <td>\n"\
		"      Ogg Vorbis :\n   </td>\n   <td>\n "\
		"     <B>" + ogg123 + "</B>\n   </td>\n"\
		"   </tr>"\*/
		"\n</table><BR>"\
		"Use tabs on the left side to browse current settings.";

		
		infoBrws->setText( i18n(message) );
}
//==============================================
void InfoPnl::getSystem(){
	QString buff;
	
	QFile ostype("/proc/sys/kernel/ostype");	
	if(ostype.open(IO_ReadOnly))
     		ostype.readLine(buff,(unsigned int)250);
     		
	if(buff && buff!= "")
		system = buff;
		
     QFile osrelease("/proc/sys/kernel/osrelease");
     	if(osrelease.open(IO_ReadOnly))
     		osrelease.readLine(buff,(unsigned int)250);
     	
     	if(buff && buff!= ""){
     		if(system == "Unable to dermine")
			system = buff;
   		else
   			system =  system + " " + buff;
	}
	if(system != "Unable to dermine")
		updateInfo();
}
//==============================================
void InfoPnl::getName(){
		cdboProc = new KProcess();
		*cdboProc << "whoami";
		connect(cdboProc, SIGNAL(processExited(KProcess *)),
     					this, SLOT(gotName(KProcess *)));
     					
  		connect(cdboProc, SIGNAL(receivedStdout (KProcess *, char *, int)),
			this, SLOT(receivedName(KProcess *, char *, int)));
	
		connect(cdboProc, SIGNAL(receivedStderr (KProcess *, char *, int)),
			this, SLOT(receivedName(KProcess *, char *, int )));
	
		if(!cdboProc->start(KProcess::NotifyOnExit, KProcess::AllOutput)){
			delete cdboProc;
		}			
}
//---------------------------------------------------------------------------------------------
void InfoPnl::receivedName(KProcess *, char *buffer, int buflen){	
	if(buflen > 0){
		QString buff(buffer);
		buff = buff.left(buflen);
		user = buff;
		updateInfo();
	}
}
//---------------------------------------------------------------------------------------------
void InfoPnl::gotName(KProcess * proc){	
	delete proc;
}
//==============================================
void InfoPnl::getCdrecordV(){
		cdboProc = new KProcess();
		*cdboProc << "cdrecord" << "-version";
		connect(cdboProc, SIGNAL(processExited(KProcess *)),
     					this, SLOT(gotCdrecordV(KProcess *)));
     					
  		connect(cdboProc, SIGNAL(receivedStdout (KProcess *, char *, int)),
			this, SLOT(receivedCdrecordV(KProcess *, char *, int)));
	
		connect(cdboProc, SIGNAL(receivedStderr (KProcess *, char *, int)),
			this, SLOT(receivedCdrecordV(KProcess *, char *, int )));
	
		if(!cdboProc->start(KProcess::NotifyOnExit, KProcess::AllOutput)){
			delete cdboProc;
		}			
}
//---------------------------------------------------------------------------------------------
void InfoPnl::receivedCdrecordV(KProcess *, char *buffer, int buflen){	
	if(buflen > 0){
		QString buff(buffer);
		buff = buff.left(buflen);
		
		cdrecord = buff.left(buff.find(" ", 9));
		updateInfo();
	}
}
//---------------------------------------------------------------------------------------------
void InfoPnl::gotCdrecordV(KProcess * proc){	
	delete proc;
}
//==============================================
void InfoPnl::getMkisofsV(){
		cdboProc = new KProcess();
		*cdboProc << "mkisofs" << "-version";
			
		connect(cdboProc, SIGNAL(processExited(KProcess *)),
     					this, SLOT(gotMkisofsV(KProcess *)));
     					
  		connect(cdboProc, SIGNAL(receivedStdout (KProcess *, char *, int)),
			this, SLOT(receivedMkisofsV(KProcess *, char *, int)));
	
		connect(cdboProc, SIGNAL(receivedStderr (KProcess *, char *, int)),
			this, SLOT(receivedMkisofsV(KProcess *, char *, int )));
	
		if(!cdboProc->start(KProcess::NotifyOnExit, KProcess::AllOutput)){
			delete cdboProc;
		}			
}
//---------------------------------------------------------------------------------------------
void InfoPnl::receivedMkisofsV(KProcess *, char *buffer, int buflen){	
	if(buflen > 0){
		QString buff(buffer);
		buff = buff.left(buflen);
		
		mkisofs = buff.left(buff.find(" ", 9));
		updateInfo();
	}
}
//---------------------------------------------------------------------------------------------
void InfoPnl::gotMkisofsV(KProcess * proc){	
	delete proc;
}
void InfoPnl::getCdparanoiaV(){
		//cdboProc = new KShellProcess();
		cdboProc = new KProcess();
		*cdboProc << "cdparanoia" << "-V";
			
		connect(cdboProc, SIGNAL(processExited(KProcess *)),
     					this, SLOT(gotCdparanoiaV(KProcess *)));
     					
  		connect(cdboProc, SIGNAL(receivedStdout (KProcess *, char *, int)),
			this, SLOT(receivedCdparanoiaV(KProcess *, char *, int)));
	
		connect(cdboProc, SIGNAL(receivedStderr (KProcess *, char *, int)),
			this, SLOT(receivedCdparanoiaV(KProcess *, char *, int )));
	
		if(!cdboProc->start(KProcess::NotifyOnExit, KProcess::AllOutput)){
			delete cdboProc;
		}			
}
//---------------------------------------------------------------------------------------------
void InfoPnl::receivedCdparanoiaV(KProcess *, char *buffer, int buflen){	
	if(buflen > 0){
		QString buff(buffer);
		buff = buff.left(buflen);
		
		QStringList list(QStringList::split(" ", buff));
		cdparanoia = list[0] + " " + list[3];
		updateInfo();
	}
}
//---------------------------------------------------------------------------------------------
void InfoPnl::gotCdparanoiaV(KProcess * proc){	
	delete proc;
}
void InfoPnl::getCdda2wavV(){
		cdboProc = new KProcess();
		*cdboProc << "cdda2wav" << "--help";
		connect(cdboProc, SIGNAL(processExited(KProcess *)),
     					this, SLOT(gotCdda2wavV(KProcess *)));
     					
  		connect(cdboProc, SIGNAL(receivedStdout (KProcess *, char *, int)),
			this, SLOT(receivedCdda2wavV(KProcess *, char *, int)));
	
		connect(cdboProc, SIGNAL(receivedStderr (KProcess *, char *, int)),
			this, SLOT(receivedCdda2wavV(KProcess *, char *, int )));
	
		if(!cdboProc->start(KProcess::NotifyOnExit, KProcess::AllOutput)){
			delete cdboProc;
		}			
}
//---------------------------------------------------------------------------------------------
void InfoPnl::receivedCdda2wavV(KProcess *, char *buffer, int buflen){	
	if(buflen > 0){
		QString buff(buffer);
		buff = buff.left(buflen);
		if(cdda2wav.find("cdda2wav ") != -1)
			return;
			
		buff = buff.right(buff.length() - buff.find("Version") -  7);
		cdda2wav = "cdda2wav " + buff.left(buff.find("_"));
		
		updateInfo();
 	}
}
//---------------------------------------------------------------------------------------------
void InfoPnl::gotCdda2wavV(KProcess * proc){	
	delete proc;
}
/*/---------------------------------------------------------------------------------------------
void InfoPnl::getOgg123V(){
		cdboProc = new KProcess();
		*cdboProc << "ogg123" << "-V";
		connect(cdboProc, SIGNAL(processExited(KProcess *)),
     					this, SLOT(gotOgg123V(KProcess *)));
     					
  		connect(cdboProc, SIGNAL(receivedStdout (KProcess *, char *, int)),
			this, SLOT(receivedOgg123V(KProcess *, char *, int)));
	
		connect(cdboProc, SIGNAL(receivedStderr (KProcess *, char *, int)),
			this, SLOT(receivedOgg123V(KProcess *, char *, int )));
	
		if(!cdboProc->start(KProcess::NotifyOnExit, KProcess::AllOutput)){
			delete cdboProc;
		}			
}
//---------------------------------------------------------------------------------------------
void InfoPnl::receivedOgg123V(KProcess *, char *buffer, int buflen){	
	if(buflen > 0){
		QString buff(buffer);
		buff = buff.left(buflen);	
		ogg123 = buff;
		
		updateInfo();
 	}
}
//---------------------------------------------------------------------------------------------
void InfoPnl::gotOgg123V(KProcess * proc){	
	delete proc;
}
//---------------------------------------------------------------------------------------------
void InfoPnl::getMpg123V(){
		cdboProc = new KProcess();
		*cdboProc << "mpg123";
		connect(cdboProc, SIGNAL(processExited(KProcess *)),
     					this, SLOT(gotMpg123V(KProcess *)));
     					
  		connect(cdboProc, SIGNAL(receivedStdout (KProcess *, char *, int)),
			this, SLOT(receivedMpg123V(KProcess *, char *, int)));
	
		connect(cdboProc, SIGNAL(receivedStderr (KProcess *, char *, int)),
			this, SLOT(receivedMpg123V(KProcess *, char *, int )));
	
		if(!cdboProc->start(KProcess::NotifyOnExit, KProcess::AllOutput)){
			delete cdboProc;
		}			
}
//---------------------------------------------------------------------------------------------
void InfoPnl::receivedMpg123V(KProcess *, char *buffer, int buflen){	
	if(buflen > 0){
		QString buff(buffer);
		buff = buff.left(buflen);
		
		if(mpg123.find("mpg123 ") != -1 && mpg123.find("not possible)") == -1)
			return;
		
		buff = buff.right(buff.length() - buff.find("Version") -  8);
		mpg123 = "mpg123 " + buff.left(buff.find(" "));
		
		//mpg123 = buff;
		updateInfo();
 	}
}
//---------------------------------------------------------------------------------------------
void InfoPnl::gotMpg123V(KProcess * proc){	
	delete proc;
}*/
#include "InfoPnl.moc"
