/***************************************************************************
                          CdboOpt.h  -  description
                             -------------------
    begin                : Fri Jun 1 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CDBOOPT_H
#define CDBOOPT_H

#include <kconfig.h>
#include <kprocess.h>

#include "CdboOptBase.h"

class CdboOpt : public CdboOptBase{
    Q_OBJECT

public:
    CdboOpt( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~CdboOpt();
	
	static const int StandartOutput = 0;
	static const int QuiteOutput = 1;
	static const int CustomOutput = 2;

    	void saveOptions();	
	void readOptions();
	void applyDefaults();
	
protected slots:
    virtual void customOutSlot();
    virtual void tmpBrowseSlot();
    virtual void quiteOutSlot();
    virtual void stdOutSlot();
    virtual void chekSizeSlot();
    virtual void showWarningsSlot();

    void sizeCheckProcessDoneSlot(KProcess *proc);
    void receivedSizeMessageSlot(KProcess *proc, char *buffer, int buflen);//

private:
	KConfig *config;
	KProcess *cdboProc;
	
	QString tempDir;
	//////////////////////////
	void enableCustOut(bool yes);
	void checkTmpSize();
	
	bool showMessage;
};

#endif // CDBOOPT_H
