/***************************************************************************
                          DriveInfoPnl.h  -  description
                             -------------------
    begin                : Thu May 31 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef DRIVEINFOPNL_H
#define DRIVEINFOPNL_H

#include <qcombobox.h>
#include <qvariant.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>

#include <klocale.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QButtonGroup;
class QPushButton;
class KConfig;
class KProcess;

class DriveInfoPnl : public QWidget
{ 
    Q_OBJECT

public:
     DriveInfoPnl( QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
     ~DriveInfoPnl();
	
	static const int Target = 1;
    	static const int Source = 2;
    	
     void readOptions();
     void saveOptions();
	void setType(int t);
	
	QString getScsiDevice();
	
     QString getDriveName();

     inline bool isReady() { return devicesCmb->count() > 0; }
	inline void setTitle(QString title) { driveInfoPnlFrm->setTitle( tr( title ) ); }
	inline void setDevImage(QPixmap image) { deviceBtn->setPixmap( image );}
	inline void setUsrBtnTitle(QString title) { usrBtn->setText( tr( title ) ); }
	inline void setEjected() { ejected = true; }
	inline bool isEjected() { return ejected; }
	
	inline QPushButton* getDetectBtn() { return  detectBtn; }
	inline QPushButton* getUsrBtn() { return  usrBtn; }
	

public slots:
	void closeTray();
	void eject();	
	void blockBtns(bool);
	void closeTrayAndWait();
	
protected slots:
	void deviceBtnSlot();
     void processComplited(KProcess *);

private:
	int type;
	bool ejected;
	bool done;
	bool blocked;
	 KConfig *config;
	 KProcess *cdboProc;
	
	QButtonGroup* driveInfoPnlFrm;
     QPushButton* usrBtn;
     QComboBox* devicesCmb;
     QPushButton* detectBtn;
     QPushButton* deviceBtn;
     QHBoxLayout* driveInfoPnlLayout;
     QGridLayout* driveInfoPnlFrmLayout;
};

#endif // DRIVEINFOPNL_H
