/***************************************************************************
                          SessionTypeDialog.h  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef SESSIONTYPEDIALOG_H
#define SESSIONTYPEDIALOG_H

#include <qvariant.h>
#include <qdialog.h>
class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QButtonGroup;
class QLabel;
class QPushButton;
class QRadioButton;

class SessionTypeDialog : public QDialog
{ 
    Q_OBJECT

public:
    SessionTypeDialog(int * chosenType, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~SessionTypeDialog();

    static const int firstSession = 0;
    static const int middleSession = 1;
    static const int finalSession = 2;
    static const int invalidSession = 3;

protected slots:
    virtual void cancelSlot();
    virtual void firstSlot();
    virtual void middleSlot();
    virtual void finalSlot();
    virtual void okSlot();

private:
	void init();
    QGridLayout* SessionTypeDialogLayout;
    QVBoxLayout* ButtonGroup1Layout;
     QLabel* TextLabel1;
    QButtonGroup* ButtonGroup1;
    QRadioButton* firstRBtn;
    QRadioButton* middleRBtn;
    QRadioButton* finalRBtn;
    QPushButton* okBtn;
    QPushButton* cancelBtn;
    int *chosenType;
};

#endif // SESSIONTYPEDIALOG_H
