/***************************************************************************
                          NewCdDialogBase.cpp  -  description
                             -------------------
    begin                : Sun May 13 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include "NewCdDialogBase.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include "dialogParts/DialogCntPnl.h"
#include "dialogParts/DriveInfoPnl.h"
#include "dialogParts/SpeedPnl.h"
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/* 
 *  Constructs a NewCdDialogBase which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
NewCdDialogBase::NewCdDialogBase( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "NewCdDialogBase" );
    resize( 777, 496 ); 
    setMinimumSize( QSize( 750, 460 ) );
    setMaximumSize( QSize( 801, 496 ) );
    setCaption( i18n( "Create New CD Dialog" ) );
    NewCdDialogBaseLayout = new QGridLayout( this ); 
    NewCdDialogBaseLayout->setSpacing( 0 );
    NewCdDialogBaseLayout->setMargin( 0 );

    Frame5 = new QFrame( this, "Frame5" );
    Frame5->setMaximumSize( QSize( 325, 32767 ) );
    Frame5->setFrameShape( QFrame::StyledPanel );
    Frame5->setFrameShadow( QFrame::Raised );
    Frame5->setLineWidth( 1 );
    Frame5->setMargin( 4 );
    Frame5->setMidLineWidth( 0 );
    Frame5Layout = new QVBoxLayout( Frame5 ); 
    Frame5Layout->setSpacing( 5 );
    Frame5Layout->setMargin( 8 );

    targetDevicePnl = new DriveInfoPnl( Frame5, "targetDevicePnl" );
    targetDevicePnl->setMinimumSize( QSize( 310, 128 ) );
    targetDevicePnl->setMaximumSize( QSize( 320, 134 ) );
    Frame5Layout->addWidget( targetDevicePnl );

    speedPnl = new SpeedPnl( Frame5, "speedPnl" );
    speedPnl->setMinimumSize( QSize( 310, 65 ) );
    speedPnl->setMaximumSize( QSize( 320, 75 ) );
    Frame5Layout->addWidget( speedPnl );

    NewCdDialogBaseLayout->addWidget( Frame5, 0, 0 );

    dialogCntPnl = new DialogCntPnl( this, "dialogCntPnl" );

    NewCdDialogBaseLayout->addMultiCellWidget( dialogCntPnl, 1, 1, 0, 1 );

    detailsPnl = new QFrame( this, "detailsPnl" );
    detailsPnl->setFrameShape( QFrame::StyledPanel );
    detailsPnl->setFrameShadow( QFrame::Raised );
    detailsPnlLayout = new QVBoxLayout( detailsPnl ); 
    detailsPnlLayout->setSpacing( 5 );
    detailsPnlLayout->setMargin( 8 );

    GroupBox6 = new QGroupBox( detailsPnl, "GroupBox6" );
    GroupBox6->setEnabled( TRUE );
    GroupBox6->setMinimumSize( QSize( 460, 75 ) );
    GroupBox6->setMaximumSize( QSize( 465, 95 ) );
    GroupBox6->setTitle( i18n( "Recording Details" ) );
    QWhatsThis::add(  GroupBox6, i18n( "Recording Details." ) );

    numberSpn = new QSpinBox( GroupBox6, "numberSpn" );
    numberSpn->setGeometry( QRect( 280, 30, 50, 30 ) ); 
    numberSpn->setMinimumSize( QSize( 50, 30 ) );
    numberSpn->setMaximumSize( QSize( 50, 30 ) );
    numberSpn->setButtonSymbols( QSpinBox::PlusMinus );
    numberSpn->setMinValue( 1 );
    numberSpn->setValue( 1 );
    QToolTip::add(  numberSpn, i18n( "Specify number of copies to make" ) );

    numOfCopiesLbl = new QLabel( GroupBox6, "numOfCopiesLbl" );
    numOfCopiesLbl->setGeometry( QRect( 200, 30, 80, 35 ) ); 
    numOfCopiesLbl->setMinimumSize( QSize( 80, 35 ) );
    numOfCopiesLbl->setMaximumSize( QSize( 90, 35 ) );
    numOfCopiesLbl->setText( i18n( "Number<br>of Copies" ) );
    numOfCopiesLbl->setAlignment( int( QLabel::WordBreak | QLabel::AlignCenter ) );
    numOfCopiesLbl->setIndent( -1 );

    customBurnBtn = new QPushButton( GroupBox6, "customBurnBtn" );
    customBurnBtn->setGeometry( QRect( 360, 30, 90, 30 ) ); 
    customBurnBtn->setMinimumSize( QSize( 90, 30 ) );
    customBurnBtn->setMaximumSize( QSize( 90, 30 ) );
    customBurnBtn->setText( i18n( "Cus&tom" ) );
    QToolTip::add(  customBurnBtn, i18n( "Configure recording options" ) );

    actionCmb = new QComboBox( FALSE, GroupBox6, "actionCmb" );
    actionCmb->setGeometry( QRect( 10, 30, 180, 30 ) );
    actionCmb->setMinimumSize( QSize( 180, 30 ) );
    actionCmb->setMaximumSize( QSize( 180, 30 ) );
    QToolTip::add(  actionCmb, i18n( "Choose the action to take." ) );
    detailsPnlLayout->addWidget( GroupBox6 );

    GroupBox6_2 = new QGroupBox( detailsPnl, "GroupBox6_2" );
    GroupBox6_2->setMinimumSize( QSize( 460, 115 ) );
    GroupBox6_2->setMaximumSize( QSize( 460, 115 ) );
    GroupBox6_2->setTitle( i18n( "ISO Image (if used)" ) );
    QWhatsThis::add(  GroupBox6_2, i18n( "ISO image." ) );

    imageLbl = new QLabel( GroupBox6_2, "imageLbl" );
    imageLbl->setGeometry( QRect( 10, 30, 404, 30 ) ); 
    imageLbl->setFrameShape( QLabel::Box );
    imageLbl->setFrameShadow( QLabel::Raised );
    imageLbl->setText( QString::null );
    QToolTip::add(  imageLbl, i18n( "Temporary directory used to store iso image in." ) );

    imageBrowseBtn = new QPushButton( GroupBox6_2, "imageBrowseBtn" );
    imageBrowseBtn->setGeometry( QRect( 420, 30, 28, 30 ) ); 
    imageBrowseBtn->setMinimumSize( QSize( 28, 30 ) );
    imageBrowseBtn->setMaximumSize( QSize( 28, 30 ) );
    imageBrowseBtn->setText( i18n( "..." ) );
    QToolTip::add(  imageBrowseBtn, i18n( "Browse for ISO Image file." ) );

    isoPreviewBtn = new QPushButton( GroupBox6_2, "isoPreviewBtn" );
    //isoPreviewBtn->setEnabled( true );
    isoPreviewBtn->setGeometry( QRect( 240, 70, 100, 30 ) ); 
    isoPreviewBtn->setMinimumSize( QSize( 100, 30 ) );
    isoPreviewBtn->setMaximumSize( QSize( 100, 30 ) );
    isoPreviewBtn->setText( i18n( "&Preview" ) );
    QToolTip::add(  isoPreviewBtn, i18n( "Preview ISO Image." ) );

    isoOptionsBtn = new QPushButton( GroupBox6_2, "isoOptionsBtn" );
    //isoOptionsBtn->setEnabled( FALSE );
    isoOptionsBtn->setGeometry( QRect( 350, 70, 100, 30 ) );
    isoOptionsBtn->setMinimumSize( QSize( 100, 30 ) );
    isoOptionsBtn->setMaximumSize( QSize( 100, 30 ) );
    isoOptionsBtn->setText( i18n( "&Options" ) );
    QToolTip::add(  isoOptionsBtn, i18n( "Configure new ISO Image settings." ) );

    removeIsoChk = new QCheckBox( GroupBox6_2, "removeIsoChk" );
    removeIsoChk->setGeometry( QRect( 10, 80, 220, 17 ) );
    removeIsoChk->setText( i18n( "Delete Image(s) after recording" ) );
    QToolTip::add(  removeIsoChk, i18n( "When done recording, remove image file(s).<b></b> (Does nothing after burn 'on-the-fly')." ) );
    detailsPnlLayout->addWidget( GroupBox6_2 );

    NewCdDialogBaseLayout->addWidget( detailsPnl, 0, 1 );

    // signals and slots connections
    connect( imageBrowseBtn, SIGNAL( clicked() ), this, SLOT( isoBrowseSlot() ) );
    connect( customBurnBtn, SIGNAL( clicked() ), this, SLOT( customBtnSlot() ) );
    connect( isoOptionsBtn, SIGNAL( clicked() ), this, SLOT( isoOptionsSlot() ) );
    connect( isoPreviewBtn, SIGNAL( clicked() ), this, SLOT( isoPreviewSlot() ) );

    // tab order
    setTabOrder( imageBrowseBtn, isoPreviewBtn );
    setTabOrder( isoPreviewBtn, isoOptionsBtn );
    setTabOrder( isoOptionsBtn, actionCmb );
    setTabOrder( actionCmb, customBurnBtn );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
NewCdDialogBase::~NewCdDialogBase()
{
    // no need to delete child widgets, Qt does it all for us
}

void NewCdDialogBase::customBtnSlot()
{
    qWarning( "NewCdDialogBase::customBtnSlot(): Not implemented yet!" );
}

void NewCdDialogBase::isoBrowseSlot()
{
    qWarning( "NewCdDialogBase::isoBrowseSlot(): Not implemented yet!" );
}

void NewCdDialogBase::isoOptionsSlot()
{
    qWarning( "NewCdDialogBase::isoOptionsSlot(): Not implemented yet!" );
}

void NewCdDialogBase::isoPreviewSlot()
{
    qWarning( "NewCdDialogBase::isoPreviewSlot(): Not implemented yet!" );
}

#include "NewCdDialogBase.moc"
