/***************************************************************************
                          NewCdDialog.h  -  description
                             -------------------
    begin                : Sun May 13 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef NEWCDDIALOG_H
#define NEWCDDIALOG_H

#include <qwidget.h>
#include <qstring.h>
#include <qevent.h>

#include <kconfig.h>
#include <kprocess.h>

#include "NewCdDialogBase.h"
#include "CdboDialogBase.h"
#include "CdboDialogActionFactory.h"
#include "dialogParts/DriveInfoPnl.h"
#include "dialogParts/SpeedPnl.h"
#include "dialogParts/DialogCntPnl.h"


class NewCdDialog : public NewCdDialogBase, public CdboDialogBase  {
 Q_OBJECT

public:
	NewCdDialog(QWidget *parent, const char *name, QString image = "");
	NewCdDialog(QStringList *flist, QWidget *parent, const char *name, bool createImageOnly = false ) ;
	NewCdDialog(QString *mappings, QWidget *parent, const char *name, bool createImageOnly = false ) ;
	~NewCdDialog();
	
	//implementing pure virtuals
	virtual void blockBtns(bool) const;
	virtual QString getActionType() const;
	
	inline virtual void output(int type, QString message) const { dialogCntPnl->output(type, message); }
	inline virtual void status(QString message) const { dialogCntPnl->status(message); }
	
	inline virtual QString getScsiDevice() const { return targetDevicePnl->getScsiDevice(); }
	inline virtual QString getSpeed() const { return speedPnl->getSpeed(); }
	

protected slots:
	virtual void closeEvent(QCloseEvent *e);
	
	void taskDone(bool);
	void taskFailedToStart();

    void startBtnSlot();
    void quitSlot();
    void detectDestSlot();
    void settingsSlot();
    void cancelSlot();
    void eraseSlot();
    void cancelledByUser();

    virtual void customBtnSlot();
    virtual void isoBrowseSlot();
    virtual void isoOptionsSlot();
    virtual void isoPreviewSlot();

   virtual void keyPressEvent(QKeyEvent *e);

private:
	void init();
	void restructureActions(int type);
	void blockActionBtns(bool);
	
	void startBurn();
	void startCreateOnTheFly();
	
	bool createImageOnly;
	bool createImage;
	bool createOnTheFly;
	
	bool stillCreating;
	bool stillChecking;
	bool stillBurning;
	bool stillCreatingOnTheFly;
	
	int copiesWanted;
	int copiesDone;
	
	QString imageAddr;
	QStringList *fileList;
	QString *isoFileMappings;
	
	KConfig *config;
	CdboDialogActionFactory *factory;
	
	//methods
	void saveOptions();
	void readOptions();
	void initBtns();
	bool confermExit();
	void popUpSettings(int);
	void cleanUp();
};
#endif