/***************************************************************************
                          MainDialog.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//QT includes
#include <qcheckbox.h>

//KDE includes
#include <kapp.h>
#include <kconfig.h>

#include "MainDialog.h"
#include "CdboDialogBase.h"


MainDialog::MainDialog( QWidget* parent, const char* name, bool modal,
                    WFlags f) : MainDialogBase( parent, name, modal, f ) {
	config = kapp->config();
	config->setGroup("Default Settings");	
	bool  onStart = config->readBoolEntry("show Main Dialog on start", true);
	doOnStartChk->setChecked(onStart);
	type = CdboDialogBase::None;
}
MainDialog::~MainDialog(){
}
//------------------------------------------------------------------------------------------------
int MainDialog::popUp(){
	exec();
	return type;
}
//------------------------------------------------------------------------------------------------
void MainDialog::copyCdSlot(){
	type = CdboDialogBase::CdCopyDialogType;
	saveOptions();
	accept();
}
void MainDialog::exitSlot(){
	saveOptions();
	accept();
}
void MainDialog::cancelSlot(){
	reject();
}
void MainDialog::configureSlot(){
	type = CdboDialogBase::SettingsDialogType;
	saveOptions();
	accept();
}
void MainDialog::eraseCdSlot(){
	type = CdboDialogBase::EraseDialogType;
	saveOptions();
	accept();
}
void MainDialog::musicSlot(){
	type = CdboDialogBase::MusicDialogType;
	saveOptions();
	accept();
}
void MainDialog::newCdSlot(){
	type = CdboDialogBase::NewCdDialogType;
	saveOptions();
	accept();
}
void MainDialog::saveOptions(){
	config->setGroup("Default Settings");	
	bool  onStart = doOnStartChk->isChecked();
	config->writeEntry("show Main Dialog on start", onStart);
}

