;;; Interrupt time measurement program for the C64/C128
;;; for measuring the performance of data transfers.

;;; Copyright  1996,2001,2002 Marko Mkel (msmakela@nic.funet.fi)
;;; Commented and reformatted in 2001.
;;; Converted from DASM to XA syntax in 2002.

chrout = $ffd2

	.text
	.word $3000
	*=$3000

	sei
loop:	lda $dc0e
	ora #$80
	sta $dc0e		; assume 50 Hz operation
	lda #0
	sta $dc0b		; reset the time of day clock
	sta $dc0a
	sta $dc09
	sta $dc08
	cli			; allow an interrupt to occur
	sei
	ldx #3
read:	lda $dc08,x		; read the time of day clock
	sta todbuf,x
	dex
	bpl read
	lda todbuf+1
	ora todbuf+2
	ora todbuf+3
	bne disp
	lda todbuf
	cmp #2
	bcc nodisp		; do not display times shorter than 200 ms
disp:	ldx #3			; display hours, minutes and seconds
next:	lda todbuf,x
	jsr printbcd
	lda #"."
	jsr chrout
	dex
	bne next
	lda todbuf
	ora #"0"
	jsr chrout		; display tenths of seconds
	lda #13
	jsr chrout		; carriage return
nodisp:
	jmp loop		; return to the measurement loop

	;; print a binary coded decimal number as two digits
printbcd:
	pha
	lsr
	lsr
	lsr
	lsr
	jsr print
	pla
print:	ora #"0"
	jmp chrout

	;; buffer for reading the time of day clock
todbuf:
;	.dsb 4
