;;; @file pia.s
;;; Definitions for the MC 6821 PIA controlled memory expansion
;;; for the Commodore 64 and 128
;;; @author Marko Mkel (msmakela@nic.funet.fi)

	;; flag -> is there a RAM expansion
ramexp	= 1
#if host = 64
bank	= $a9	; temporary variable that holds the memory bank
#endif

#include "piabase.s"

	;; initialize the RAM expansion
#define initram	pia_init

	;; increment and compare pointers
#define incmptr_decl pia_incmptr_decl:piadata

	;; load a memory block
#define do_load plain_load

	;; save a memory block
#define do_save plain_save
