;;; @file pc64.s
;;; Transfer routines for the 4-bit PET/C64/C128/Vic-20 to PC cable
;;; designed by Wolfgang Lorenz
;;; @author Marko Mkel (msmakela@nic.funet.fi)

	;; additional commands for info mode
#define infoinit
	;; initialize the cable
#if host = 20	; set CB1 to trigger on falling edge
#define initcable lda #$ef:and ack:sta ack
#else
#if host >= 201 && host <= 203; trig falling CA1, manual control of CB2
#define initcable lda ack:and #$fe:ora#$e0:sta ack
#else
#define initcable
#endif
#endif
	;; deinitialize the cable
#define deinitcable
	;; set the PA2 line on C64 (work around an Action Replay bug)
#if host = 64
#define pc64_pa2 lda#ackval:ora ack:sta ack
#else
#define pc64_pa2
#endif
	;; wait for strobe
#if clearviaifr
#define wait_strobe lda #strval:.(:wait bit strobe:beq wait:.):sta strobe
#else
#define wait_strobe lda #strval:.(:wait bit strobe:beq wait:.)
#endif

	;; determine whether a request is pending
#define isrequest pc64_pa2:lda #strval:bit strobe:beq return:ldx #$f:stx ddr

	; .A = data, .Y = 00, .X preserved
receive_switch:
receive:
#if clearviaifr
rereceive:
#endif
	wait_strobe
#if clearviaifr
#else
rereceive:
#endif
	lda ack
	and #255 - ackval
	ldy data
	sta ack
	tya
	lsr
	lsr
	lsr
	lsr
	sta stemp
	wait_strobe
	lda ack
	ora #ackval
	tay
	lda data
	sty ack
	and #$F0
	ora stemp
	ldy #0
	rts

	; .A trashed, .Y = 00, .X preserved
send_switch:
send:
	tay
	wait_strobe
	sty data
	lda ack
	and #255 - ackval
	sta ack
	tya
	lsr
	lsr
	lsr
	lsr
	tay
	wait_strobe
	sty data
	lda ack
	ora #ackval
	sta ack
	ldy #0
	rts
