;;; @file c2n232.s
;;; Transfer routines for the Commodore cassette drive emulator C2N232
;;; designed by Marko Mkel
;;; @author Marko Mkel (msmakela@nic.funet.fi)

	;; additional commands for info mode
#define infoinit lda #$f0:jsr send
	;; initialize the cable (clear the cassette read status if needed)
#if host = 16
#define initcable
#else
#if host >= 201 && host <= 203 && c2nrdval = $80
#define initcable bit c2n1read-1
#else
#if clearviaifr
#define initcable lda #c2nrdval:sta c2nread
#else
#define initcable bit c2nread
#endif
#endif
#endif
	;; deinitialize the cable
#define deinitcable

	;; branch on high-to-low transition (or no transition) on CASS READ
#if c2nrdval = $80
#define c2nbr bit c2nread:bpl wait
#define c2nbrn bit c2nread:bmi noret
#else
#if host = 16
#define c2nbr lda #c2nrdval:bit c2nread:bne wait
#define c2nbrn lda #c2nrdval:bit c2nread:beq noret
#else
#define c2nbr lda #c2nrdval:bit c2nread:beq wait
#define c2nbrn lda #c2nrdval:bit c2nread:bne noret
#endif
#endif
	;; wait for high-to-low transition on CASS READ
#if c2nrdval = $80
#define c2nrdlo .(:wait c2nbr:.)
#else
#define c2nrdlo .(:wait=*+2:c2nbr:.)
#endif

	;; clear the status of the CASS READ line
#if host >= 201 && host <= 203	; PET
#if c2nrdval = $80 		; cassette #1
#define c2nclrd bit c2n1read-1
#else
#define c2nclrd			; cassette #2 => accessing c2nwrite
#endif				; already has cleared the interrupt
#else				; not PET
#if clearviaifr
#define c2nclrd sta c2nread	; VIA-based machines (VIC-20)
#else
#define c2nclrd			; on CIA, the status is cleared by reading
#endif
#endif

	;; lower or raise the cassette write line
#if host = 16
#define c2nwr0 ora #c2nwrval
#define c2nwr1 and #255-c2nwrval
#else
#define c2nwr0 and #255-c2nwrval
#define c2nwr1 ora #c2nwrval
#endif
	;; determine whether a request is pending
#define isrequest .(:lda c2nwrite:c2nwr0:sta c2nwrite:\
	sta send_nibble+1:c2nwr1:tax:c2nbrn:\
	stx c2nwrite:jmp return:noret c2nclrd:.)

	;; read a bit to the Carry flag
#if host >= 201 && host <= 203 && c2nrdval = $80
#define c2nrdbit lda c2nread:c2nclrd:cmp #c2nrdval
#else
#define c2nrdbit lda #c2nrdval:and c2nread:c2nclrd:cmp #c2nrdval
#endif

	; .A = data, .Y = 00, .X preserved
receive_switch:
receive:
#if host = 16
	lda #c2nwrval
	ora c2nwrite
#else
	lda #255-c2nwrval
	and c2nwrite
#endif
	sta c2nwrite	; drop WRITE
	c2nrdlo
	c2nclrd

rereceive:	; rereceive (without handshake)
	txa		; backup .X
	pha
	lda c2nwrite
	c2nwr1
	sta c2nwrite	; raise WRITE
	tay
	c2nwr0
	tax
	c2nrdbit	; receive bit 0
	stx c2nwrite	; drop WRITE
	ror stemp
	c2nrdbit	; receive bit 1
	sty c2nwrite	; raise WRITE
	ror stemp
	c2nrdbit	; receive bit 2
	stx c2nwrite	; drop WRITE
	ror stemp
	c2nrdbit	; receive bit 3
	sty c2nwrite	; raise WRITE
	ror stemp
	c2nrdbit	; receive bit 4
	stx c2nwrite	; drop WRITE
	ror stemp
	c2nrdbit	; receive bit 5
	sty c2nwrite	; raise WRITE
	ror stemp
	c2nrdbit	; receive bit 6
	stx c2nwrite	; drop WRITE
	ror stemp
	c2nrdbit	; receive bit 7
	sty c2nwrite	; raise WRITE
	pla
	tax
	ldy #0
	lda stemp
	ror
#if host <> 16
	eor #$ff
#endif
	rts

	; .A trashed, .Y = 00, .X preserved
send_switch:
send:
	pha
	and #$f
	.(
	jsr send_half
	pla
	lsr
	lsr
	lsr
	lsr
send_half:		; send a nibble
	.)
#if host = 210 || host = 220	; 2 MHz operation
	asl		; double the pulse width
#endif
	tay
	iny
	c2nrdlo
	c2nclrd
send_nibble:
	lda #0	; placeholder
	sta c2nwrite	; drop WRITE
	c2nwr1
	.(:delay dey:bne delay:.)
	sta c2nwrite	; raise WRITE
	rts
