;;; @file wrfile.s
;;; Extension for writing files to 8-bit Commodores
;;; @author Marko Mkel (msmakela@nic.funet.fi)
;;; @author Olaf Seibert (seibert@mbfys.kun.nl)

;;; The protocol for writing a file is as follows.
;;; C=			other computer
;;;			<- <length>filename (<length> >= 80 quits)
;;;			<- 00 (filler byte for c2n232 on c64/c128)
;;; <st (00=ok, nonzero=error)> ->
;;;			<- <length><chksum>datablock (255 bytes max)
;;;			<- 00 (filler byte for c2n232 on c64/c128)
;;; ok (80) or repeat block (81) or stop (82) ->
;;;
;;; The last block has length 0 and no checksum or data.

;;; Note that this code is binary patched before it is loaded to the computer.
;;; In sequences a9 xx a2 xx a0 xx, the 2nd and 3nd "xx" are replaced
;;; with the device number and the secondary address.

#include "ext.s"

	jsr prepare		; prepare for using the link
	jsr receive
	jmp loop1
loop	jsr receive_switch	; get file name length
loop1	SETNAM(filebuf)		; set the file name
	tax			; test length
	bpl noexit
	jmp exit		; negative length => reinstall server and exit.
noexit	beq nofnam

	stx fnamlen
	ldx #0			; receive file name
fnam	jsr receive		; preserves x but sets y to 0.
	sta filebuf,x
	inx
fnamlen = *+1
	cpx #0
	bcc fnam

	;; the patcher looks for lda#, ldx#, ldy# with identical constants
nofnam	lda #fileno
	ldx #fileno		; device number (self-modified)
	ldy #fileno		; secondary address (self-modified)
	SETLFS
	jsr close		; try to close the file first just in case
	clc
	lda #fileno
	jsr open		; now open the file
	READST			; and test for ourselves if we must continue
	beq wrfile

	;; abort the transfer and return to the main loop
abort	sei
	tax
	jsr receive		; get the filler byte
	txa
	jsr send_switch		; send the status code

eof	jsr clrchn
	lda #fileno
	jsr close

	lda #1
	bne loop		; branch always

wrfile	ldx #fileno		; go and select the file for writing
	jsr chkout
	READST
	bne abort
	sei
	jsr receive		; get the filler byte
nextblock
	jsr send_switch		; send zero status code

	;; loop to receive blocks to the file
	jsr receive_switch
	sta blklen
	tax			; zero?
	beq eof			; end of file
	jsr receive		; checksum
	sta checksum
	ldx #0
	stx chksum		; clear checksum

recv	jsr receive
	sta filebuf,x
	sec			; update checksum
chksum = *+1
	adc #0			; placeholder for self-modifying code
	sta chksum
	inx
blklen = *+1
	cpx #0			; placeholder for self-modifying code
	bne recv

checksum = *+1
	eor #0			; compare checksums (self-modifying code)
	beq writeit
	jsr receive		; get the filler byte
	lda #$81
	bne nextblock		; repeat block

	;; write max 255 bytes to the file
writeit
#if pet
	cli
#endif
	ldx #0
wr	READST			; test ST for error
	bne done
	lda filebuf,x
	jsr chrout
	inx
	cpx blklen
	bne wr

	sei
	jsr receive		; get the filler byte
	lda #$80
	bne nextblock		; next block

done	lda #$82
	bne abort		; abort the transfer and return to main loop

filebuf				; 255 bytes of file data
