/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import org.apache.tika.exception.TikaException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class ParseContext
implements Serializable {
    private static final long serialVersionUID = -5921436862145826534L;
    private final Map<String, Object> context = new HashMap<String, Object>();
    private static final EntityResolver IGNORING_SAX_ENTITY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    };
    private static final XMLResolver IGNORING_STAX_ENTITY_RESOLVER = new XMLResolver(){

        @Override
        public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
            return "";
        }
    };

    public <T> void set(Class<T> key, T value) {
        if (value != null) {
            this.context.put(key.getName(), value);
        } else {
            this.context.remove(key.getName());
        }
    }

    public <T> T get(Class<T> key) {
        return (T)this.context.get(key.getName());
    }

    public <T> T get(Class<T> key, T defaultValue) {
        T value = this.get(key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public XMLReader getXMLReader() throws TikaException {
        XMLReader reader = this.get(XMLReader.class);
        if (reader != null) {
            return reader;
        }
        try {
            reader = this.getSAXParser().getXMLReader();
        }
        catch (SAXException e) {
            throw new TikaException("Unable to create an XMLReader", e);
        }
        reader.setEntityResolver(IGNORING_SAX_ENTITY_RESOLVER);
        return reader;
    }

    public SAXParser getSAXParser() throws TikaException {
        SAXParser parser = this.get(SAXParser.class);
        if (parser != null) {
            return parser;
        }
        try {
            return this.getSAXParserFactory().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("Unable to configure a SAX parser", e);
        }
        catch (SAXException e) {
            throw new TikaException("Unable to create a SAX parser", e);
        }
    }

    public SAXParserFactory getSAXParserFactory() {
        SAXParserFactory factory = this.get(SAXParserFactory.class);
        if (factory == null) {
            factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (ParserConfigurationException parserConfigurationException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
        return factory;
    }

    private DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = this.get(DocumentBuilderFactory.class);
        if (documentBuilderFactory != null) {
            return documentBuilderFactory;
        }
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        ParseContext.tryToSetSAXFeatureOnDOMFactory(documentBuilderFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        ParseContext.tryToSetXercesManager(documentBuilderFactory);
        return documentBuilderFactory;
    }

    public DocumentBuilder getDocumentBuilder() throws TikaException {
        DocumentBuilder documentBuilder = this.get(DocumentBuilder.class);
        if (documentBuilder != null) {
            return documentBuilder;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = this.getDocumentBuilderFactory();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(IGNORING_SAX_ENTITY_RESOLVER);
            documentBuilder.setErrorHandler(null);
            return documentBuilder;
        }
        catch (ParserConfigurationException e) {
            throw new TikaException("XML parser not available", e);
        }
    }

    public XMLInputFactory getXMLInputFactory() {
        XMLInputFactory factory = this.get(XMLInputFactory.class);
        if (factory != null) {
            return factory;
        }
        factory = XMLInputFactory.newFactory();
        this.tryToSetStaxProperty(factory, "javax.xml.stream.isNamespaceAware", true);
        this.tryToSetStaxProperty(factory, "javax.xml.stream.isValidating", false);
        factory.setXMLResolver(IGNORING_STAX_ENTITY_RESOLVER);
        return factory;
    }

    private static void tryToSetSAXFeatureOnDOMFactory(DocumentBuilderFactory dbf, String feature, boolean value) {
        try {
            dbf.setFeature(feature, value);
        }
        catch (AbstractMethodError | Exception throwable) {
            // empty catch block
        }
    }

    private static void tryToSetXercesManager(DocumentBuilderFactory dbf) {
        for (String securityManagerClassName : new String[]{"com.sun.org.apache.xerces.internal.util.SecurityManager", "org.apache.xerces.util.SecurityManager"}) {
            try {
                Object mgr = Class.forName(securityManagerClassName).newInstance();
                Method setLimit = mgr.getClass().getMethod("setEntityExpansionLimit", Integer.TYPE);
                setLimit.invoke(mgr, 4096);
                dbf.setAttribute("http://apache.org/xml/properties/security-manager", mgr);
                return;
            }
            catch (Throwable throwable) {
            }
        }
    }

    private void tryToSetStaxProperty(XMLInputFactory factory, String key, boolean value) {
        try {
            factory.setProperty(key, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

