#
# $Header: /cvsroot/catalog/catalog/t/05mifluz.t,v 1.9 2001/07/11 10:28:08 loic Exp $
#
use strict;

package main;

use Test;

use Catalog::tools::tools;
use Catalog::dmoz;

require "t/lib.pl";
require "t/fulltext.pl";

#$::opt_verbose = 'hook_mifluz|normal';
#$::opt_verbose = 'mifluz|normal';
#$::opt_error_stack = 1;
#DBI->trace(3);

conftest_generic();

#
# Do not do anything if mifluz was not chosen
#
{
    my($fulltext_conf) = load_config("conf/fulltext.conf");
    if(!exists($fulltext_conf->{'fulltext_type'}) ||
       $fulltext_conf->{'fulltext_type'} ne 'mifluz') {
	print STDERR " skip ";
	plan test => 1;
	ok(1, 1, "fake");
	exit(0);
    }
}

require Catalog::tools::mifluz;

fulltext_prepare();

plan test => 7;

#
# The fulltext configuration provided by default is fit for dmoz.org
# dumps. 
#
{
    my($dmoz) = dmoz_loader();
    my($db) = $dmoz->db()->instance();
    my($hook) = $db->{'hook'};
    ok(defined($hook), 1, "hook not defined");
    my($table);
    foreach $table (qw(dmozrecords catalog_category_dmoz)) {
	my($rows) = $db->exec_select("select rowid from $table");
	my($rowid);
	foreach $rowid (map { $_->{'rowid'} } @$rows) {
	    $hook->hook_insert($table, $rowid);
	}
    }
    $hook->logoff();
    my($count) = $db->exec_select_one("select count from catalog_category_dmoz where rowid = 1")->{'count'};
    ok($count, 159, "wrong count expected 159");

    #
    # Search
    #
    my($cgi) = Catalog::tools::cgi->new();
    $cgi->param('context' => 'hsearch');
    $cgi->param('name' => 'dmoz');
    $cgi->param('url' => 'http://fake/');
    $cgi->param('text' => 'website');
    $cgi->param('dump' => "t/tmp/html/mifluz$Test::ntest.html");
    my($t) = $dmoz->selector($cgi);
    ok($t =~ /www.scifistation.com/, 1, "search for website");

    #
    # Delete a row and search again
    #
    my($rowid) = $t =~ /scifistation.*?rowid=(\d+)/s;
    ok(defined($rowid), 1, "cannot find scifistation rowid");

    my($row) = $dmoz->db()->exec_select_one("select * from dmozrecords where rowid = $rowid");

    $dmoz->centryremove_all_api("dmoz", $rowid);

    $cgi = Catalog::tools::cgi->new();
    $cgi->param('context' => 'hsearch');
    $cgi->param('name' => 'dmoz');
    $cgi->param('url' => 'http://fake/');
    $cgi->param('text' => 'website');
    $cgi->param('dump' => "t/tmp/html/mifluz$Test::ntest.html");
    $t = $dmoz->selector($cgi);
    ok($t !~ /www.scifistation.com/, 1, "search for website (after delete)");

    #
    # Insert this row
    #
    $dmoz->db()->insert('dmozrecords', %$row);
    
    $cgi = Catalog::tools::cgi->new();
    $cgi->param('context' => 'hsearch');
    $cgi->param('name' => 'dmoz');
    $cgi->param('url' => 'http://fake/');
    $cgi->param('text' => 'website');
    $cgi->param('dump' => "t/tmp/html/mifluz$Test::ntest.html");
    $t = $dmoz->selector($cgi);
    ok($t =~ /www.scifistation.com/, 1, "search for website (after insert)");

    #
    # Update this row
    #
    $row->{'description'} =~ s/website//ig;

    $dmoz->db()->update('dmozrecords', "rowid = $row->{'rowid'}",
			'description' => $row->{'description'});

    $cgi = Catalog::tools::cgi->new();
    $cgi->param('context' => 'hsearch');
    $cgi->param('name' => 'dmoz');
    $cgi->param('url' => 'http://fake/');
    $cgi->param('text' => 'website');
    $cgi->param('dump' => "t/tmp/html/mifluz$Test::ntest.html");
    $t = $dmoz->selector($cgi);
    ok($t !~ /www.scifistation.com/, 1, "search for website (after update)");

    $hook->logoff();

    my($opt) = $dmoz->cmd_opt();
    system("blib/script/index_dmoz -dbopt \"$opt\" -database test t/tmp/index.txt");
}

fulltext_clean();
conftest_generic_clean();

# Local Variables: ***
# mode: perl ***
# End: ***
